/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChestBlaze;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDTWorkChestBlazeRenderer
extends TileEntityRenderer<TileEntityDTWorkChestBlaze> {
    private static final RenderType END_SPACE_0 = RenderType.func_228630_a_((int)1);
    private static final RenderType END_SPACE_1 = RenderType.func_228630_a_((int)13);
    private static final Random RANDOM = new Random(31100L);

    public TileEntityDTWorkChestBlazeRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityDTWorkChestBlaze tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        this.renderCube(tileEntityIn, 0.99f, 0.15f, matrix4f, bufferIn.getBuffer(END_SPACE_0));
        this.renderCube(tileEntityIn, 0.99f, 0.5f, matrix4f, bufferIn.getBuffer(END_SPACE_1));
    }

    private void renderCube(TileEntityDTWorkChestBlaze tileEntityIn, float offset, float brightness, Matrix4f matrixIn, IVertexBuilder builder) {
        float r = (RANDOM.nextFloat() * 0.5f + 0.1f) * brightness;
        float g = (RANDOM.nextFloat() * 0.5f + 0.4f) * brightness;
        float b = (RANDOM.nextFloat() * 0.5f + 0.5f) * brightness;
        this.renderFace(tileEntityIn, matrixIn, builder, 0.0f, 1.0f, offset, offset, 1.0f, 1.0f, 0.0f, 0.0f, r, g, b);
    }

    private void renderFace(TileEntityDTWorkChestBlaze tileEntityIn, Matrix4f matrix, IVertexBuilder builder, float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float r, float g, float b) {
        builder.func_227888_a_(matrix, f0, f2, f4).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, f1, f2, f5).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, f1, f3, f6).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, f0, f3, f7).func_227885_a_(r, g, b, 1.0f).func_181675_d();
    }
}

