/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.util;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Utils {
    public static final Random random = new Random();

    public static boolean canInsert(IInventory inventory, ItemStack stack) {
        int count = stack.func_190916_E();
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (inventory.func_94041_b(i, stack) && (itemStack.func_190926_b() || Container.func_195929_a((ItemStack)itemStack, (ItemStack)stack))) {
                count -= itemStack.func_77976_d() - itemStack.func_190916_E();
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canInsert(IInventory inventory, List<ItemStack> stacks) {
        return Utils.canInsert(inventory, stacks, 0, inventory.func_70302_i_());
    }

    public static boolean canInsert(IInventory inventory, List<ItemStack> stacks, int b, int e) {
        if (b > e) {
            throw new IllegalArgumentException();
        }
        int[] sizes = new int[stacks.size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = stacks.get(i).func_190916_E();
        }
        int[] limit = new int[e - b];
        int[] spans = new int[e - b];
        for (int i = b; i < e; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            limit[i] = itemStack.func_77976_d() - itemStack.func_190916_E();
            spans[i] = -1;
        }
        for (int s = 0; s < sizes.length; ++s) {
            ItemStack stack = stacks.get(s);
            for (int i = b; i < e && sizes[s] != 0; ++i) {
                ItemStack itemStack;
                if (!inventory.func_94041_b(i, stack)) continue;
                ItemStack itemStack2 = itemStack = spans[i] < 0 ? inventory.func_70301_a(i) : stacks.get(spans[i]);
                if (!itemStack.func_190926_b() && !Container.func_195929_a((ItemStack)itemStack, (ItemStack)stack)) continue;
                if (sizes[s] < limit[i]) {
                    int n = i;
                    limit[n] = limit[n] - sizes[s];
                    sizes[s] = 0;
                } else {
                    int n = s;
                    sizes[n] = sizes[n] - limit[i];
                    limit[i] = 0;
                }
                spans[i] = s;
            }
        }
        for (int size : sizes) {
            if (size <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean insert(IInventory inventory, ItemStack stack) {
        return Utils.insert(inventory, stack, 0, inventory.func_70302_i_());
    }

    public static boolean insert(IInventory inventory, ItemStack stack, int s, int e) {
        ItemStack inventoryStack;
        int i;
        if (!stack.func_190926_b()) {
            for (i = s; i < e; ++i) {
                inventoryStack = inventory.func_70301_a(i);
                if (!Container.func_195929_a((ItemStack)stack, (ItemStack)inventoryStack)) continue;
                int count = inventoryStack.func_190916_E() + stack.func_190916_E();
                if (count > stack.func_77976_d()) {
                    if (inventoryStack.func_190916_E() >= stack.func_77976_d()) continue;
                    stack.func_190918_g(stack.func_77976_d() - inventoryStack.func_190916_E());
                    inventoryStack.func_190920_e(stack.func_77976_d());
                    continue;
                }
                stack.func_190920_e(0);
                inventoryStack.func_190920_e(count);
                break;
            }
        }
        if (!stack.func_190926_b()) {
            for (i = s; i < e; ++i) {
                inventoryStack = inventory.func_70301_a(i);
                if (!inventoryStack.func_190926_b() || !inventory.func_94041_b(i, stack)) continue;
                inventory.func_70299_a(i, stack.func_77979_a(stack.func_190916_E()));
                break;
            }
        }
        return stack.func_190926_b();
    }

    private Utils() {
    }

    public static int setValue(int target, int pos, int len, int value) {
        int mask = (1 << len) - 1;
        return target & ~(mask << pos) | (value & mask) << pos;
    }

    public static int getValue(int target, int pos, int len) {
        int mask = (1 << len) - 1;
        return target >> pos & mask;
    }

    public static boolean getValue(int target, int pos) {
        return Utils.getValue(target, pos, 1) == 1;
    }

    public static int setValue(int target, int pos, boolean b) {
        return Utils.setValue(target, pos, 1, b ? 1 : 0);
    }

    @Nonnull
    public static <T> T nonNull() {
        return null;
    }

    public static ResourceLocation modResource(String path) {
        return new ResourceLocation("corail_dt", path);
    }

    public static Item modItem(String path) {
        return (Item)ForgeRegistries.ITEMS.getValue(Utils.modResource(path));
    }

    public static NamedTag<Item> modTag(String path) {
        return new NamedTag<Item>(Utils.modResource(path));
    }

    public static String toString(ItemStack itemStack) {
        ResourceLocation rl = itemStack.func_77973_b().getRegistryName();
        return rl.toString() + ":" + itemStack.func_190916_E();
    }

    public static ItemStack asString(String string) {
        Item item;
        String[] parts = string.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new ItemStack((IItemProvider)item, parts.length == 3 ? Integer.parseInt(parts[2]) : 1);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack merge(ItemStack t, ItemStack o) {
        if (t.func_77973_b() != o.func_77973_b()) {
            throw new IllegalArgumentException();
        }
        return new ItemStack((IItemProvider)t.func_77973_b(), t.func_190916_E() + o.func_190916_E());
    }

    public static class Content
    extends Inventory {
        public Content(int size) {
            this(size, null);
        }

        public Content(int size, Consumer<Integer> update) {
            super(size);
            if (update != null) {
                this.func_110134_a(i -> update.accept(0));
            }
        }

        public void load(ListNBT nbt) {
            int i;
            NonNullList list = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (i = 0; i < nbt.size(); ++i) {
                CompoundNBT itemStackTag = nbt.func_150305_b(i);
                int j = itemStackTag.func_74771_c("Slot") & 0xFF;
                if (j >= list.size()) continue;
                list.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)itemStackTag));
            }
            for (i = 0; i < list.size(); ++i) {
                this.func_70299_a(i, (ItemStack)list.get(i));
            }
        }

        public ListNBT save() {
            ListNBT nbt = new ListNBT();
            for (int index = 0; index < this.func_70302_i_(); ++index) {
                ItemStack itemStack = this.func_70301_a(index);
                if (itemStack.func_190926_b()) continue;
                CompoundNBT itemStackTag = itemStack.func_77955_b(new CompoundNBT());
                itemStackTag.func_74774_a("Slot", (byte)index);
                nbt.add((Object)itemStackTag);
            }
            return nbt;
        }
    }

    public static class NamedTag<T>
    implements ITag.INamedTag<T> {
        private final ResourceLocation resourceLocation;

        public NamedTag(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public boolean func_230235_a_(T element) {
            throw new UnsupportedOperationException();
        }

        public List<T> func_230236_b_() {
            throw new UnsupportedOperationException();
        }

        public ResourceLocation func_230234_a_() {
            return this.resourceLocation;
        }
    }
}

