/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt;

import com.google.common.reflect.Reflection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlserverevents.FMLServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.configuration.ConfigurationScreen;
import org.cursegame.minecraft.dt.gui.GuiDT;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.network.PacketHandler;
import org.cursegame.minecraft.dt.recipe.RecipeService;
import org.cursegame.minecraft.dt.registry.ModBlocks;
import org.cursegame.minecraft.dt.registry.ModContainers;
import org.cursegame.minecraft.dt.registry.ModEvents;
import org.cursegame.minecraft.dt.registry.ModItems;
import org.cursegame.minecraft.dt.registry.ModTabs;
import org.cursegame.minecraft.dt.registry.ModTileEntityTypes;
import org.cursegame.minecraft.dt.registry.ModTriggers;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTableRenderer;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChestBlazeRenderer;

@Mod(value="corail_dt")
public class ModDT {
    public static final String MOD_ID = "corail_dt";
    public static final String MOD_NAME = "Corail Deconstructing Table";
    public static final Logger LOGGER = LogManager.getLogger((String)"corail_dt");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    public ModDT() {
        Reflection.initialize((Class[])new Class[]{PacketHandler.class, ModTriggers.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.getInstance().client.specification);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configuration.getInstance().server.specification);
        context.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory(ConfigurationScreen::new));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        MinecraftForge.EVENT_BUS.register(ModEvents.class);
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        RecipeService.getInstance().initialize(event.getServer().m_129894_());
    }

    private void clientInit(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(ModTileEntityTypes.DT_W_C_B, TileEntityDTWorkChestBlazeRenderer::new);
        BlockEntityRenderers.m_173590_(ModTileEntityTypes.CRYSTAL_TABLE, TileEntityCrystalTableRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DT_W_C_B, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.CRYSTAL_TABLE, (RenderType)RenderType.m_110457_());
        MenuScreens.m_96206_(ModContainers.DT, GuiDT::new);
        ResourceLocation property = new ResourceLocation(MOD_ID, "fullness");
        ItemProperties.register((Item)ModItems.VIAL_0, (ResourceLocation)property, ItemVial::getFullnessPropertyOverride);
        ItemProperties.register((Item)ModItems.VIAL_1, (ResourceLocation)property, ItemVial::getFullnessPropertyOverride);
        ItemProperties.register((Item)ModItems.VIAL_2, (ResourceLocation)property, ItemVial::getFullnessPropertyOverride);
        ItemProperties.register((Item)ModItems.VIAL_3, (ResourceLocation)property, ItemVial::getFullnessPropertyOverride);
        ItemProperties.register((Item)ModItems.VIAL_4, (ResourceLocation)property, ItemVial::getFullnessPropertyOverride);
    }
}

