/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.block;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cursegame.minecraft.dt.registry.ModTileEntityTypes;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTable;

public class BlockCrystalTable
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    private final Map<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final VoxelShape SHELL = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape SHAPE_U = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0));
    public static final VoxelShape SHAPE_D = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    public static final VoxelShape SHAPE_N = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0));
    public static final VoxelShape SHAPE_S = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0));
    public static final VoxelShape SHAPE_E = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0));
    public static final VoxelShape SHAPE_W = Shapes.m_83110_((VoxelShape)SHELL, (VoxelShape)Block.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));

    public BlockCrystalTable() {
        super(BlockCrystalTable.getBuilder().m_60953_(LightBlock.f_153659_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static VoxelShape getVoxelShape(BlockState blockState) {
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case UP: {
                return SHAPE_U;
            }
            case DOWN: {
                return SHAPE_D;
            }
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
            case EAST: {
                return SHAPE_E;
            }
        }
        return SHELL;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BlockCrystalTable.getVoxelShape(blockState);
    }

    public String m_7705_() {
        return "corail_dt.block.crystal_table";
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof TileEntityCrystalTable) {
            ((TileEntityCrystalTable)blockEntity).setCustomName(itemStack.m_41786_());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return null;
        }
        BlockState state = this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockState = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockState;
        }
        return null;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEVEL});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityCrystalTable(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockCrystalTable.m_152132_(blockEntityType, ModTileEntityTypes.CRYSTAL_TABLE, (BlockEntityTicker)(level.f_46443_ ? (l, p, s, blockEntity) -> blockEntity.tickClient() : (l, p, s, blockEntity) -> blockEntity.tickServer()));
    }

    public static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76412_).m_60999_().m_60918_(SoundType.f_56744_).m_60978_(0.8f).m_60955_().m_60953_(LightBlock.f_153659_);
    }
}

