/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTBase;

public abstract class BlockDTBase<T extends TileEntityDTBase>
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    protected BlockDTBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        TileEntityDTBase tileEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TileEntityDTBase && (tileEntity = (TileEntityDTBase)blockEntity).getContainer(player) != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tileEntity, (BlockPos)blockPos);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof TileEntityDTBase) {
            ((TileEntityDTBase)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState oldBlockState, Level level, BlockPos blockPos, BlockState blockState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!oldBlockState.m_60713_(blockState.m_60734_()) && (blockEntity = level.m_7702_(blockPos)) instanceof TileEntityDTBase) {
            ((TileEntityDTBase)blockEntity).dropContents(level, blockPos);
        }
        super.m_6810_(oldBlockState, level, blockPos, blockState, isMoving);
    }

    public RenderShape m_7514_(BlockState p_48727_) {
        return RenderShape.MODEL;
    }
}

