/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.SlotDT;
import org.cursegame.minecraft.dt.registry.ModContainers;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.tileentity.DTContainerProvider;

public class ContainerDT
extends AbstractContainerMenu {
    private final DTContainer dtContainer;
    private final ContainerData dtData;
    private int clickSlotId;
    private long clickSlotTimestamp;
    private long clickSlotDelay = 300L;
    private int iSize;
    private int wSize;
    private int vSize;
    private int oSize;
    private int pSize;
    private int diskSlot;
    private int bookSlot;
    private int vialSlot;
    private int fuelSlot;
    private int bondSlot;
    private int wIndex;
    private int iIndex;
    private int oIndex;
    private int vIndex;
    private int pIndex;
    protected Map<Pair<Integer, Integer>, Slot> slotByXYMap = new HashMap<Pair<Integer, Integer>, Slot>();
    static int[][] inventory3x3;
    static int[][] inventory9x3;

    public ContainerDT(int windowId, Inventory playerInventory, DTContainer dtContainer) {
        super(ModContainers.DT, windowId);
        this.dtContainer = dtContainer;
        this.dtData = dtContainer.newTrackedData();
        this.m_38884_(this.dtData);
        if (playerInventory.f_35978_.f_19853_.f_46443_) {
            for (int i = 0; i < this.dtData.m_6499_(); ++i) {
                this.dtData.m_8050_(i, 0);
            }
        }
        this.addSlots(playerInventory);
    }

    public ContainerDT(int windowId, Inventory pi, FriendlyByteBuf dtData) {
        this(windowId, pi, ContainerDT.getContainer(pi, dtData));
    }

    private static DTContainer getContainer(Inventory pi, FriendlyByteBuf dtData) {
        BlockPos blockPos = dtData.m_130135_();
        DTContainerProvider dtContainerProvider = (DTContainerProvider)pi.f_35978_.f_19853_.m_7702_(blockPos);
        return dtContainerProvider.getContainer(pi.f_35978_);
    }

    public BlockPos getPosition() {
        return this.dtContainer.getPos();
    }

    public DTContainer getDTContainer() {
        return this.dtContainer;
    }

    public SlotDT getItemSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.iIndex));
    }

    public SlotDT getDiskSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.diskSlot));
    }

    public SlotDT getBookSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.bookSlot));
    }

    public SlotDT getVialSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.vialSlot));
    }

    public SlotDT getFuelSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.fuelSlot));
    }

    public SlotDT getBondSlot() {
        return (SlotDT)((Object)this.f_38839_.get(this.bondSlot));
    }

    public boolean m_6875_(Player player) {
        return this.dtContainer.canInteract(player);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.dtContainer.disarm(player);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (this.clickSlotTimestamp < System.currentTimeMillis() - this.clickSlotDelay) {
            this.clickSlotId = slotId;
        }
        this.clickSlotTimestamp = System.currentTimeMillis();
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if ((this.clickSlotId >= this.wIndex && this.clickSlotId < this.wIndex + this.wSize && index >= this.wIndex && index < this.wIndex + this.wSize || this.clickSlotId >= this.iIndex && this.clickSlotId < this.iIndex + this.iSize && index >= this.iIndex && index < this.iIndex + this.iSize || this.clickSlotId >= this.oIndex && this.clickSlotId < this.oIndex + this.oSize && index >= this.oIndex && index < this.oIndex + this.oSize) && !this.m_38903_(itemStack1, this.pIndex, this.pIndex + this.pSize, true)) {
                return ItemStack.f_41583_;
            }
            if (this.clickSlotId >= this.pIndex && this.clickSlotId < this.pIndex + this.pSize && index >= this.pIndex && index < this.pIndex + this.pSize) {
                if (this.m_38903_(itemStack1, this.wIndex, this.wIndex + this.wSize, false) || this.m_38903_(itemStack1, this.iIndex, this.iIndex + this.iSize, false)) {
                    this.dtContainer.requestUpdateRecipe();
                } else {
                    return ItemStack.f_41583_;
                }
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemStack;
    }

    public void commandHeadS(Player player) {
        int i;
        ModDT.LOGGER.debug("commandHeadS");
        NonNullList items = NonNullList.m_122779_();
        for (i = 0; i < this.oSize; ++i) {
            Slot slot = this.m_38853_(this.oIndex + i);
            items.add((Object)slot.m_7993_());
            slot.m_5852_(ItemStack.f_41583_);
        }
        items.sort(Comparator.comparing(ItemStack::m_41778_));
        for (i = 0; i < this.oSize; ++i) {
            this.m_38903_((ItemStack)items.get(i), this.oIndex, this.oIndex + this.oSize, false);
        }
    }

    public void commandHeadD(Player player) {
        ModDT.LOGGER.debug("commandHeadD");
        for (int i = this.oIndex; i < this.oIndex + this.oSize; ++i) {
            this.clickSlotId = i;
            this.m_7648_(player, i);
        }
    }

    private void addSlots(Inventory playerInventory) {
        int i;
        int index;
        this.iSize = this.dtContainer.getInventoryI().m_6643_();
        this.wSize = this.dtContainer.getInventoryW().m_6643_();
        this.vSize = this.dtContainer.getInventoryV().m_6643_();
        this.oSize = this.dtContainer.getInventoryO().m_6643_();
        this.pSize = 36;
        this.iIndex = index = 0;
        this.m_38897_(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, 56, 36));
        if (this.dtContainer.getMode().hasISlots()) {
            for (int[] i2 : inventory9x3) {
                if (index == 8) {
                    SlotDT slotDT = new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, inventory3x3[2][0] + 115 + 1, inventory3x3[2][1] + 17 + 1);
                    slotDT.setActive(false);
                    this.m_38897_(slotDT);
                }
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, i2[0] + -61 + 1, i2[1] + 17 + 1));
            }
        } else {
            for (int i3 = 1; i3 < this.dtContainer.getInventoryI().m_6643_(); ++i3) {
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.wIndex = index;
        if (this.dtContainer.getMode().hasWSlots()) {
            this.diskSlot = index++;
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), this.diskSlot - this.wIndex, 32, 54));
            this.bookSlot = index++;
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), this.bookSlot - this.wIndex, 8, 54));
            this.vialSlot = index++;
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), this.vialSlot - this.wIndex, 8, 36));
            this.fuelSlot = index++;
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), this.fuelSlot - this.wIndex, 80, 54).setActive(this.dtContainer.getMode().hasFuelFlame() || this.dtContainer.getMode().hasFuelBlaze()));
            this.bondSlot = index++;
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), this.bondSlot - this.wIndex, 8, 18){

                public int m_6641_() {
                    return 1;
                }
            });
            for (i = 0; i < 5; ++i) {
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), index++ - this.wIndex, 7 + 18 * i + 1, 90));
            }
        } else {
            for (i = 0; i < this.dtContainer.getInventoryW().m_6643_(); ++i) {
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryW(), index++ - this.wIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.oIndex = index;
        if (this.dtContainer.getMode().hasOSlots()) {
            for (int[] i2 : inventory9x3) {
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryO(), index++ - this.oIndex, i2[0] + 183 + 1, i2[1] + 17 + 1));
            }
        } else {
            for (i = 0; i < this.dtContainer.getInventoryO().m_6643_(); ++i) {
                this.m_38897_(new SlotDT(this.dtContainer.getInventoryO(), index++ - this.oIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.vIndex = index;
        for (int[] i2 : inventory3x3) {
            this.m_38897_(new SlotDT(this.dtContainer.getInventoryV(), index++ - this.vIndex, i2[0] + 115 + 1, i2[1] + 17 + 1, false));
        }
        this.pIndex = index;
        for (int y = -1; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new SlotDT((Container)playerInventory, index++ - this.pIndex, x * 18 + 7 + 1, y == -1 ? 184 : y * 18 + 125 + 1));
            }
        }
    }

    protected Slot m_38897_(Slot slot) {
        this.slotByXYMap.put((Pair<Integer, Integer>)Pair.of((Object)slot.f_40220_, (Object)slot.f_40221_), slot);
        return super.m_38897_(slot);
    }

    static {
        int x;
        int y;
        inventory3x3 = new int[9][2];
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                ContainerDT.inventory3x3[x + y * 3][0] = x * 18;
                ContainerDT.inventory3x3[x + y * 3][1] = y * 18;
            }
        }
        inventory9x3 = new int[27][2];
        for (y = 0; y < 9; ++y) {
            for (x = 0; x < 3; ++x) {
                ContainerDT.inventory9x3[x + y * 3][0] = x * 18;
                ContainerDT.inventory9x3[x + y * 3][1] = y * 18;
            }
        }
    }
}

