/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.gui.Button;
import org.cursegame.minecraft.dt.gui.ButtonTile;

public abstract class Gui<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    static ButtonTile.Offset[] OFFSET_H = new ButtonTile.Offset[]{ButtonTile.Offset.of(2, 0, Button::isDisabled), ButtonTile.Offset.of(1, 0, Button::m_5702_)};
    static ButtonTile.Offset[] OFFSET_V = new ButtonTile.Offset[]{ButtonTile.Offset.of(0, 2, Button::isDisabled), ButtonTile.Offset.of(0, 1, Button::m_5702_)};
    private AbstractContainerMenu dummy;
    private int oSize;
    private int oLeft;

    Gui(T sc, Inventory i, Component titleIn) {
        super(sc, i, titleIn);
    }

    public T m_6262_() {
        String callerClassName = null;
        if (((Boolean)Configuration.getInstance().client.allowIntegration.get()).booleanValue()) {
            return (T)super.m_6262_();
        }
        callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        if (callerClassName.startsWith("net.minecraft.") || callerClassName.startsWith("net.minecraftforge.") || callerClassName.startsWith("org.cursegame.minecraft.")) {
            return (T)super.m_6262_();
        }
        if (this.dummy == null) {
            this.dummy = new AbstractContainerMenu(null, this.f_97732_.f_38840_){

                public boolean m_6875_(Player player) {
                    return false;
                }
            };
        }
        return (T)this.dummy;
    }

    public void setOSize(int oSize) {
        this.oSize = oSize;
    }

    public int getXSize() {
        return this.f_97726_ + this.oSize;
    }

    public int getGuiLeft() {
        String callerClassName;
        if (((Boolean)Configuration.getInstance().client.allowIntegration.get()).booleanValue() && (callerClassName = Thread.currentThread().getStackTrace()[2].getClassName()).startsWith("vazkii.quark")) {
            return this.f_97735_;
        }
        return this.f_97735_ + this.oLeft;
    }

    public void setOLeft(int oLeft) {
        this.oLeft = oLeft;
    }

    public int getX() {
        return this.f_97735_;
    }

    public void setX(int x) {
        this.f_97735_ = x;
    }

    public int getY() {
        return this.f_97736_;
    }

    public void setY(int y) {
        this.f_97736_ = y;
    }

    public int getW() {
        return this.f_97726_;
    }

    public void setW(int w) {
        this.f_97726_ = w;
    }

    public int getH() {
        return this.f_97727_;
    }

    public void setH(int h) {
        this.f_97727_ = h;
    }

    public void setPlayerInventoryTitleX(int playerInventoryTitleX) {
        this.f_97730_ = playerInventoryTitleX;
    }

    public void setPlayerInventoryTitleY(int playerInventoryTitleY) {
        this.f_97731_ = playerInventoryTitleY;
    }

    protected Font getFont() {
        return this.f_96547_;
    }

    protected String abbreviate(String text, int width) {
        String string = text;
        while (this.getFont().m_92895_(string) > width) {
            string = StringUtils.abbreviate((String)string, (int)(string.length() - 1));
        }
        return string;
    }

    protected void doDrawString(PoseStack ms, String text, int x, int y, int color) {
        this.getFont().m_92883_(ms, text, (float)x, (float)y, color);
    }

    protected void doDrawCenteredString(PoseStack ms, String text, int x, int y, int color) {
        this.getFont().m_92883_(ms, text, (float)Math.round((float)x - (float)this.getFont().m_92895_(text) / 2.0f), (float)Math.round(y), color);
    }

    protected void doDrawRightAlignedString(PoseStack ms, String text, int x, int y, int color) {
        this.getFont().m_92883_(ms, text, (float)(x - this.getFont().m_92895_(text)), (float)y, color);
    }

    protected void doDrawStringWithShadow(PoseStack ms, String text, float x, float y, int color) {
        this.getFont().m_92763_(ms, (Component)new TextComponent(text), x, y, color);
    }

    protected void doDrawCenteredStringWithShadow(PoseStack ms, String text, float x, float y, int color) {
        this.getFont().m_92763_(ms, (Component)new TextComponent(text), x - (float)this.getFont().m_92895_(text) / 2.0f, y, color);
    }

    protected void setVisibility(Button button, boolean visible, boolean active) {
        button.f_93624_ = visible;
        button.f_93623_ = active;
    }

    protected void setPressed(ButtonTile button, boolean pressed) {
        button.setPressed(pressed);
    }

    public boolean m_7043_() {
        return false;
    }

    protected <U extends Button> U add(U button) {
        return (U)((Object)((Button)super.m_142416_(button)));
    }

    protected void enableRepeatEvents(boolean enable) {
        this.f_96541_.f_91068_.m_90926_(enable);
    }

    public void m_7856_() {
        super.m_7856_();
        this.enableRepeatEvents(true);
        this.doInit();
    }

    protected void doInit() {
    }

    protected final void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        this.doDrawBackground(ms, mouseX, mouseY);
    }

    protected void doDrawBackground(PoseStack ms, int mouseX, int mouseY) {
    }

    protected final void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        this.doDrawForeground(ms, mouseX, mouseY);
    }

    protected void doDrawForeground(PoseStack ms, int mouseX, int mouseY) {
        super.m_7027_(ms, mouseX, mouseY);
    }

    protected void doRenderBackgroundBacklit(PoseStack ms) {
        super.m_7333_(ms);
    }

    public final boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.isMouseClicked(mouseX, mouseY, button);
    }

    protected boolean isMouseClicked(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public final boolean m_5534_(char codePoint, int modifiers) {
        return this.isCharTyped(codePoint, modifiers);
    }

    protected boolean isCharTyped(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.isKeyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void m_181908_() {
        this.doContainerTick();
    }

    protected void doContainerTick() {
    }

    public final void m_7379_() {
        super.m_7379_();
        this.enableRepeatEvents(false);
    }

    public final void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.doUpdateControls();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.doRenderTooltip(matrixStack, mouseX, mouseY);
    }

    protected final void m_7025_(PoseStack ms, int mouseX, int mouseY) {
        this.doRenderTooltip(ms, mouseX, mouseY);
    }

    protected void doRenderTooltip(PoseStack ms, int mouseX, int mouseY) {
        super.m_7025_(ms, mouseX, mouseY);
    }

    public final void m_96602_(PoseStack matrixStack, Component text, int mouseX, int mouseY) {
        this.doRenderTooltip(matrixStack, text, mouseX, mouseY);
    }

    protected void doRenderTooltip(PoseStack matrixStack, Component text, int mouseX, int mouseY) {
        super.m_96602_(matrixStack, text, mouseX, mouseY);
    }

    protected void doUpdateControls() {
    }
}

