/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.Button;
import org.cursegame.minecraft.dt.gui.ButtonTile;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.gui.Gui;
import org.cursegame.minecraft.dt.gui.GuiConstants;
import org.cursegame.minecraft.dt.gui.SlotDT;
import org.cursegame.minecraft.dt.network.PacketHandler;
import org.cursegame.minecraft.dt.network.ServerMessageDT;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.util.I18N;

@OnlyIn(value=Dist.CLIENT)
public class GuiDT
extends Gui<ContainerDT>
implements GuiConstants {
    private static final int C_TEXT = 0xA8A8A8;
    private static final int C_WARN = 0xA80000;
    private static final int C_INFO = 43008;
    private ButtonTile bS;
    private ButtonTile bC;
    private ButtonTile bA;
    private ButtonTile bN;
    private ButtonTile bB;
    private ButtonTile bHS;
    private ButtonTile bHD;
    private ButtonTile.Offset[] normalOffsets = new ButtonTile.Offset[]{ButtonTile.Offset.of(1, 1, Button::isDisabled), ButtonTile.Offset.of(1, 0, Button::m_5702_)};
    private ButtonTile.Offset[] toggleOffsets = new ButtonTile.Offset[]{ButtonTile.Offset.of(1, 1, Button::isDisabled), ButtonTile.Offset.of(0, 1, Button::isPressed), ButtonTile.Offset.of(1, 0, Button::m_5702_)};
    private Slot hoveringSlot;

    public GuiDT(ContainerDT container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setH(208);
        this.setPlayerInventoryTitleX(8);
        this.setPlayerInventoryTitleY(114);
        int oSize = 0;
        if (container.getDTContainer().getMode().hasISlots()) {
            oSize += SCREEN_L_SIDE.getW();
        }
        if (container.getDTContainer().getMode().hasOSlots()) {
            oSize += SCREEN_R_SIDE.getW();
        }
        this.setOSize(oSize);
        if (container.getDTContainer().getMode().hasISlots()) {
            this.setOLeft(-SCREEN_L_SIDE.getW());
        }
    }

    @Override
    public void doInit() {
        DTContainer dtContainer = ((ContainerDT)this.f_97732_).getDTContainer();
        this.bS = new ButtonTile(this, B_1, I18n.m_118938_((String)I18N.BUTTON_START.getKey(), (Object[])new Object[0]), this.normalOffsets, this.commandStart());
        this.add(this.bS);
        this.bC = new ButtonTile(this, B_1, I18n.m_118938_((String)I18N.BUTTON_CANCEL.getKey(), (Object[])new Object[0]), this.normalOffsets, this.commandCancel());
        this.add(this.bC);
        this.bA = new ButtonTile(this, B_2, I18n.m_118938_((String)I18N.BUTTON_AUTO.getKey(), (Object[])new Object[0]), this.toggleOffsets, this.commandToggleAuto());
        this.add(this.bA);
        this.bN = new ButtonTile(this, B_NEXT, "", OFFSET_H, this.commandNext());
        this.add(this.bN);
        this.bB = new ButtonTile(this, B_BOOK, "", OFFSET_V, this.commandBook());
        this.add(this.bB);
        if (dtContainer.getMode().hasOSlots()) {
            this.bHS = new ButtonTile(this, B_HEAD_S, "", OFFSET_V, this.commandHeadS());
            this.add(this.bHS);
            this.bHD = new ButtonTile(this, B_HEAD_D, "", OFFSET_V, this.commandHeadD());
            this.add(this.bHD);
        }
    }

    protected Button.OnPress commandStart() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.START, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandCancel() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.CANCEL, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandToggleAuto() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.TOGGLE_AUTO, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandNext() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.BROWSE_RECIPE, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandHeadS() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.HEAD_S, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandHeadD() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.HEAD_D, ((ContainerDT)this.f_97732_).getPosition()));
    }

    protected Button.OnPress commandBook() {
        return pressable -> {};
    }

    protected boolean m_6774_(int x, int y, int w, int h, double p_97772_, double p_97773_) {
        boolean hovering = super.m_6774_(x, y, w, h, p_97772_, p_97773_);
        this.hoveringSlot = hovering ? ((ContainerDT)((Object)this.m_6262_())).slotByXYMap.get(Pair.of((Object)x, (Object)y)) : null;
        return hovering;
    }

    public int getSlotColor(int index) {
        Slot slot = this.hoveringSlot;
        if (slot != null && slot.f_40218_ == ((ContainerDT)((Object)this.m_6262_())).getDTContainer().getInventoryV()) {
            return 0;
        }
        return super.getSlotColor(index);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton)) {
            int pointX = (int)mouseX;
            int pointY = (int)mouseY;
            if (((ContainerDT)((Object)this.m_6262_())).getDTContainer().getMode().hasISlots() && SCREEN_L_SIDE.isPointIn(pointX, pointY, guiLeftIn, guiTopIn)) {
                return false;
            }
            return !((ContainerDT)((Object)this.m_6262_())).getDTContainer().getMode().hasOSlots() || !SCREEN_R_SIDE.isPointIn(pointX, pointY, guiLeftIn, guiTopIn);
        }
        return false;
    }

    @Override
    protected void doDrawBackground(PoseStack ms, int mouseX, int mouseY) {
        this.doRenderBackgroundBacklit(ms);
        DTContainer dtContainer = ((ContainerDT)this.f_97732_).getDTContainer();
        SCREEN_BASE.renderBG(this, ms);
        if (dtContainer.getMode().hasISlots()) {
            SCREEN_L_SIDE.renderBG(this, ms);
        }
        if (dtContainer.getMode().hasOSlots()) {
            SCREEN_R_SIDE.renderBG(this, ms);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ITEM_SLOT.renderBG(this, ms);
        if (dtContainer.getMode().hasWSlots()) {
            DISK_SLOT.renderBG(this, ms);
            BOOK_SLOT.renderBG(this, ms);
            if (dtContainer.getMode().hasFuelFlame() || dtContainer.getMode().hasFuelBlaze()) {
                FUEL_SLOT.renderBG(this, ms);
            }
        }
        if (dtContainer.getMode().hasWSlots()) {
            WORK.renderBG(this, ms);
        }
        for (Slot slot : ((ContainerDT)this.f_97732_).f_38839_) {
            if (slot.f_40218_ == dtContainer.getInventoryV() && dtContainer.isRecipeDisabled()) {
                SLOT_DISABLED.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
            }
            if (slot == ((ContainerDT)this.f_97732_).getItemSlot() && slot.m_7993_().m_41619_()) {
                W_MARK_I0.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
            }
            if (slot.f_40218_ != dtContainer.getInventoryW()) continue;
            if (slot == ((ContainerDT)this.f_97732_).getDiskSlot() && slot.m_7993_().m_41619_()) {
                W_MARK_W0.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
            }
            if (slot == ((ContainerDT)this.f_97732_).getBookSlot() && slot.m_7993_().m_41619_()) {
                W_MARK_W1.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
            }
            if (slot == ((ContainerDT)this.f_97732_).getVialSlot() && slot.m_6659_()) {
                VIAL_SLOT.renderBG(this, ms);
                if (slot.m_7993_().m_41619_()) {
                    W_MARK_W2.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
                }
            }
            if (slot == ((ContainerDT)this.f_97732_).getBondSlot() && slot.m_6659_()) {
                BOND_SLOT.renderBG(this, ms);
                if (slot.m_7993_().m_41619_()) {
                    W_MARK_W5.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
                }
            }
            if (slot != ((ContainerDT)this.f_97732_).getFuelSlot() || !slot.m_7993_().m_41619_()) continue;
            if (dtContainer.getMode().hasFuelFlame()) {
                W_MARK_W3.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
            }
            if (!dtContainer.getMode().hasFuelBlaze()) continue;
            W_MARK_W4.renderBG(this, ms, slot.f_40220_, slot.f_40221_);
        }
        if (dtContainer.isRecipeXpInflation() && ((ContainerDT)this.f_97732_).getVialSlot().m_6659_()) {
            SPIRAL_BOND.renderBG(this, ms);
            SPIRAL_VIAL.renderBG(this, ms);
        }
        if (dtContainer.isRecipeXpDeflation() && ((ContainerDT)this.f_97732_).getBondSlot().m_6659_()) {
            SPIRAL_BOND.renderBG(this, ms);
        }
        PROGRESS_BASE.renderBG(this, ms);
        if (dtContainer.getMode().hasWSlots()) {
            if (dtContainer.getMode().hasFuelFlame()) {
                FUEL_BASE.renderBG(this, ms);
                THERMOMETER_BASE.renderBG(this, ms);
                FIRE_BASE.renderBG(this, ms);
            }
            if (dtContainer.getMode().hasFuelBlaze()) {
                FUEL_BASE.renderBG(this, ms);
                SMOG_BASE.renderBG(this, ms);
            }
        }
    }

    @Override
    protected void doDrawForeground(PoseStack ms, int mouseX, int mouseY) {
        int count;
        super.doDrawForeground(ms, mouseX, mouseY);
        DTContainer dtContainer = ((ContainerDT)this.f_97732_).getDTContainer();
        if (dtContainer.getStateProgress() > 0) {
            PROGRESS.renderFGPartHL((Screen)this, ms, dtContainer.getStateProgress(), dtContainer.getStateProgressMax() + 1);
        }
        if (dtContainer.getMode().hasWSlots()) {
            if (dtContainer.getMode().hasFuelFlame()) {
                if (dtContainer.getStateTemperature() > 0) {
                    THERMOMETER_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateTemperature(), dtContainer.getStateTemperatureMax());
                }
                if (dtContainer.getStateBurn() > 0) {
                    FIRE_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateBurn(), dtContainer.getStateBurnMax() + 1);
                }
            }
            if (dtContainer.getMode().hasFuelBlaze()) {
                if (dtContainer.getStateBurn() > 0) {
                    SMOG_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateBurn(), dtContainer.getStateBurnMax() + 1);
                }
                if (dtContainer.getStateFuel() > 0) {
                    FUEL_PART.renderFGPartHL((Screen)this, ms, dtContainer.getStateFuel(), dtContainer.getStateFuelMax() + 1);
                }
            }
        }
        if (dtContainer.isRecipeNestedContent()) {
            this.doDrawRightAlignedString(ms, "Nc", 114, 58, 0xA8A8A8);
        } else {
            if (dtContainer.isRecipeRequireXp()) {
                this.doDrawRightAlignedString(ms, "Xp", 114, 58, 0xA80000);
            }
            if (dtContainer.isRecipeProduceXp()) {
                this.doDrawRightAlignedString(ms, "Xp", 114, 58, 43008);
            }
        }
        SlotDT itemSlot = ((ContainerDT)this.f_97732_).getItemSlot();
        if (!itemSlot.m_7993_().m_41619_() && dtContainer.getRecipeItemInput() > 0 && (count = itemSlot.m_7993_().m_41613_()) < dtContainer.getRecipeItemInput()) {
            this.doDrawCenteredString(ms, count + "/" + dtContainer.getRecipeItemInput(), itemSlot.f_40220_ + 8, itemSlot.f_40221_ - 9, 0xA80000);
        }
    }

    @Override
    protected void doUpdateControls() {
        DTContainer dtContainer = ((ContainerDT)this.f_97732_).getDTContainer();
        ((ContainerDT)((Object)this.m_6262_())).getBondSlot().setActive(dtContainer.getVialStack().m_41619_());
        ((ContainerDT)((Object)this.m_6262_())).getVialSlot().setActive(dtContainer.getBondStack().m_41619_());
        boolean canControl = !dtContainer.isStateStartedAutomatically();
        this.setVisibility(this.bS, !canControl || !dtContainer.isStateStarted(), canControl && dtContainer.isStartEnabled());
        this.setVisibility(this.bC, canControl && dtContainer.isStateStarted(), canControl);
        this.setVisibility(this.bA, dtContainer.getMode().hasAutomation(), dtContainer.isStartAutomationEnabled());
        this.setPressed(this.bA, dtContainer.isStateStartedAutomatically());
        this.setVisibility(this.bN, dtContainer.isRecipeAmbiguous() && dtContainer.isRecipeAvailable() && !((ContainerDT)this.f_97732_).getDTContainer().getInventoryV().m_8020_(0).m_41619_(), dtContainer.isRecipeAmbiguous() && canControl && !dtContainer.isStateStarted());
        this.setVisibility(this.bB, false, false);
    }

    @Override
    public boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.isKeyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 73 && (modifiers & 2) == 2) {
            DTContainer dtContainer = ((ContainerDT)this.f_97732_).getDTContainer();
            ModDT.LOGGER.info("Container state: ii={}, id={}, ib={}, iv={}, ra={}, rb={}, rd={}, rx={}, xi={}, xd={}, bc={}, bm={}, fc={}, fm={}, tc={}, tm={}, pc={}, pm={}, ss={}, rs={}", new Object[]{dtContainer.getRecipeItemInput(), dtContainer.getRecipeDiskInput(), dtContainer.getRecipeBookInput(), dtContainer.getRecipeVialInput(), dtContainer.isRecipeAvailable(), dtContainer.isRecipeAmbiguous(), dtContainer.isRecipeDisabled(), dtContainer.isRecipeRequireXp(), dtContainer.isRecipeXpInflation(), dtContainer.isRecipeXpDeflation(), dtContainer.getStateBurn(), dtContainer.getStateBurnMax(), dtContainer.getStateFuel(), dtContainer.getStateFuelMax(), dtContainer.getStateTemperature(), dtContainer.getStateTemperatureMax(), dtContainer.getStateProgress(), dtContainer.getStateProgressMax(), dtContainer.getState(), dtContainer.getRecipeState()});
            return true;
        }
        return false;
    }
}

