/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.cursegame.minecraft.dt.item.ItemBase;
import org.cursegame.minecraft.dt.registry.ModTags;
import org.cursegame.minecraft.dt.registry.ModTriggers;

public class ItemDisk
extends TieredItem
implements ItemBase {
    private final String name;
    private final Tiers dust;
    private final Tiers base;
    public static TextColor C_BASE = TextColor.m_131266_((int)0x7F7F7F);
    public static TextColor C_TEXT = TextColor.m_131266_((int)0xA8A8A8);
    public static TextColor C_DATA = TextColor.m_131266_((int)5526780);
    public static final ItemDisk DUMMY = new ItemDisk("dummy", Tiers.WOOD, Tiers.WOOD){

        @Override
        public float getSpeedFactor(ItemStack stack) {
            return 1.0f;
        }
    };

    public ItemDisk(String name, Tiers dust, Tiers base) {
        super((Tier)base, ItemBase.getBuilder().m_41503_(base.m_6609_() / 5));
        this.name = name;
        this.dust = dust;
        this.base = base;
    }

    public String m_5671_(ItemStack stack) {
        return "corail_dt.item.disk_" + this.dust.ordinal();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        TranslatableComponent textBase = new TranslatableComponent("corail_dt.item.base_" + this.base.ordinal());
        textBase.m_6270_(Style.f_131099_.m_131148_(C_BASE));
        tooltip.add((Component)textBase);
        TranslatableComponent textData = new TranslatableComponent("corail_dt.item.data");
        textData.m_6270_(Style.f_131099_.m_131148_(C_TEXT));
        tooltip.add((Component)textData);
        TranslatableComponent textP1 = new TranslatableComponent("corail_dt.item.data.p1", new Object[]{stack.m_41776_()});
        textP1.m_6270_(Style.f_131099_.m_131148_(C_DATA));
        tooltip.add((Component)textP1);
        TranslatableComponent textP2 = new TranslatableComponent("corail_dt.item.data.p2", new Object[]{this.dust.m_6604_()});
        textP2.m_6270_(Style.f_131099_.m_131148_(C_DATA));
        tooltip.add((Component)textP2);
        TranslatableComponent textP3 = new TranslatableComponent("corail_dt.item.data.p3", new Object[]{String.format("%.1f", Float.valueOf(this.getSpeedFactor(stack)))});
        textP3.m_6270_(Style.f_131099_.m_131148_(C_DATA));
        tooltip.add((Component)textP3);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        this.onCraftedBy(stack, (ServerPlayer)player);
    }

    public void onCraftedBy(ItemStack stack, ServerPlayer player) {
        if (stack.m_150922_(ModTags.Items.disk_0)) {
            ModTriggers.BUILD_DISK_0.trigger(player);
        }
        if (stack.m_150922_(ModTags.Items.disk_1)) {
            ModTriggers.BUILD_DISK_1.trigger(player);
        }
        if (stack.m_150922_(ModTags.Items.disk_2)) {
            ModTriggers.BUILD_DISK_2.trigger(player);
        }
        if (stack.m_150922_(ModTags.Items.disk_3)) {
            ModTriggers.BUILD_DISK_3.trigger(player);
        }
        if (stack.m_150922_(ModTags.Items.disk_4)) {
            ModTriggers.BUILD_DISK_4.trigger(player);
        }
        if (stack.m_150922_(ModTags.Items.disk_5)) {
            ModTriggers.BUILD_DISK_5.trigger(player);
        }
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.m_44831_((ItemStack)book).entrySet().stream().anyMatch(p -> this.canApplyAtEnchantingTable(stack, (Enchantment)p.getKey()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44962_ || enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44985_;
    }

    public float getSpeedFactor(ItemStack stack) {
        float factor = this.dust.m_6624_();
        int boostLevel = EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(Enchantments.f_44984_, 0);
        if (boostLevel > 0) {
            factor += (float)(boostLevel * boostLevel + 1);
        }
        return factor;
    }

    public boolean canGrind(ItemStack diskStack, ItemStack itemStack) {
        BlockState block = ItemDisk.getBlockFromItem(itemStack).m_49966_();
        if (block.m_60834_()) {
            int boostLevel = EnchantmentHelper.m_44831_((ItemStack)diskStack).getOrDefault(Enchantments.f_44985_, 0);
            if (boostLevel > 0) {
                return false;
            }
            if (block.m_60620_((Tag)Tags.Blocks.NEEDS_NETHERITE_TOOL)) {
                return this.dust.m_6604_() >= Tiers.NETHERITE.m_6604_();
            }
            if (block.m_60620_((Tag)BlockTags.f_144284_)) {
                return this.dust.m_6604_() >= Tiers.DIAMOND.m_6604_();
            }
            if (block.m_60620_((Tag)BlockTags.f_144285_)) {
                return this.dust.m_6604_() >= Tiers.IRON.m_6604_();
            }
            if (block.m_60620_((Tag)BlockTags.f_144286_)) {
                return this.dust.m_6604_() >= Tiers.STONE.m_6604_();
            }
            if (block.m_60620_((Tag)Tags.Blocks.NEEDS_GOLD_TOOL)) {
                return this.dust.m_6604_() >= Tiers.GOLD.m_6604_();
            }
            if (block.m_60620_((Tag)Tags.Blocks.NEEDS_WOOD_TOOL)) {
                return this.dust.m_6604_() >= Tiers.WOOD.m_6604_();
            }
        }
        return true;
    }

    public static int getGrindTime(ItemStack itemStack) {
        return Math.round(ItemDisk.getBlockFromItem(itemStack).m_155943_() * 20.0f);
    }

    private static Block getBlockFromItem(ItemStack itemStack) {
        Block block = Blocks.f_50041_;
        if (itemStack.m_41720_() instanceof BlockItem) {
            block = ((BlockItem)itemStack.m_41720_()).m_40614_();
        }
        if (itemStack.m_41720_() instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)itemStack.m_41720_();
            if (tieredItem.m_43314_() == Tiers.WOOD) {
                block = Blocks.f_50011_;
            }
            if (tieredItem.m_43314_() == Tiers.STONE) {
                block = Blocks.f_50069_;
            }
            if (tieredItem.m_43314_() == Tiers.IRON) {
                block = Blocks.f_50075_;
            }
            if (tieredItem.m_43314_() == Tiers.DIAMOND) {
                block = Blocks.f_50090_;
            }
            if (tieredItem.m_43314_() == Tiers.GOLD) {
                block = Blocks.f_50074_;
            }
            if (tieredItem.m_43314_() == Tiers.NETHERITE) {
                block = Blocks.f_50721_;
            }
        }
        if (itemStack.m_41720_() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)itemStack.m_41720_();
            if (armorItem.m_40401_() == ArmorMaterials.LEATHER) {
                block = Blocks.f_50041_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.GOLD) {
                block = Blocks.f_50074_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.CHAIN) {
                block = Blocks.f_50183_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.IRON) {
                block = Blocks.f_50075_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.TURTLE) {
                block = Blocks.f_50075_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.DIAMOND) {
                block = Blocks.f_50090_;
            }
            if (armorItem.m_40401_() == ArmorMaterials.NETHERITE) {
                block = Blocks.f_50721_;
            }
        }
        return block;
    }
}

