/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.cursegame.minecraft.dt.block.BlockCrystalTable;
import org.cursegame.minecraft.dt.item.ItemBase;
import org.cursegame.minecraft.dt.registry.ModTriggers;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTable;

public class ItemVial
extends Item
implements ItemBase {
    private final int id;
    public static TextColor C_TEXT = TextColor.m_131266_((int)0xA8A8A8);
    public static TextColor C_DATA = TextColor.m_131266_((int)43008);

    public ItemVial(int id) {
        super(ItemBase.getBuilder().m_41487_(64 >> id));
        this.id = id;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        this.onCraftedBy(stack, (ServerPlayer)player);
    }

    public void onCraftedBy(ItemStack stack, ServerPlayer player) {
        switch (this.id) {
            case 0: {
                ModTriggers.BUILD_VIAL_0.trigger(player);
                break;
            }
            case 1: {
                ModTriggers.BUILD_VIAL_1.trigger(player);
                break;
            }
            case 2: {
                ModTriggers.BUILD_VIAL_2.trigger(player);
                break;
            }
            case 3: {
                ModTriggers.BUILD_VIAL_3.trigger(player);
                break;
            }
            case 4: {
                ModTriggers.BUILD_VIAL_4.trigger(player);
            }
        }
    }

    public String m_5524_() {
        return "corail_dt.item.vial_" + this.id;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult parentResult = super.m_6225_(context);
        if (parentResult.m_19077_()) {
            return parentResult;
        }
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(context.m_8083_());
        if (blockState.m_60734_() instanceof BlockCrystalTable) {
            TileEntityCrystalTable tileEntityCrystal = (TileEntityCrystalTable)level.m_7702_(context.m_8083_());
            if (!level.f_46443_ && tileEntityCrystal.addCharge(ItemVial.charge(context.m_43722_(), (ServerPlayer)context.m_43723_(), 7.0f)) == 0.0f) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(ItemStack stack) {
        return ItemVial.getItemCharge(stack) >= ItemVial.getItemMaxCharge(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        float chargeAmount = ItemVial.getItemCharge(stack) / (float)ItemVial.getChargeMax(this.id);
        String state = chargeAmount == 0.0f ? "s0" : ((double)chargeAmount < 0.1 ? "s1" : ((double)chargeAmount < 0.5 ? "s2" : ((double)chargeAmount < 0.9 ? "s3" : ((double)chargeAmount < 1.0 ? "s4" : "s5"))));
        TranslatableComponent textP4 = new TranslatableComponent("corail_dt.item.data." + state);
        textP4.m_6270_(Style.f_131099_.m_131148_(C_DATA));
        tooltip.add((Component)textP4);
    }

    public static int getChargeMax(int id) {
        int multiplier = 1;
        switch (id) {
            case 4: {
                multiplier *= 5;
            }
            case 3: {
                multiplier *= 5;
            }
            case 2: {
                multiplier *= 5;
            }
            case 1: {
                multiplier *= 5;
            }
            case 0: {
                multiplier *= 5;
            }
        }
        return 7 * multiplier;
    }

    public static int absorb(ItemStack itemStack, ServerPlayer player, int amount) {
        float result = -ItemVial.charge(itemStack, player, -amount);
        return (int)result;
    }

    public static float charge(ItemStack itemStack, @Nullable ServerPlayer player, float amount) {
        float result;
        if (amount == 0.0f) {
            return amount;
        }
        ItemVial item = (ItemVial)itemStack.m_41720_();
        float itemCharge = ItemVial.getItemCharge(itemStack);
        float itemChargeMax = ItemVial.getItemMaxCharge(itemStack);
        float charge = itemCharge;
        if (amount < 0.0f) {
            result = amount;
            if (itemCharge < itemChargeMax) {
                consume = itemChargeMax - itemCharge;
                if (consume > -result) {
                    consume = -result;
                }
                result += consume;
                if (player != null) {
                    if (consume > 0.0f) {
                        ModTriggers.FILL_VIAL.trigger(player);
                    }
                    if (item.id == 4 && (charge += consume) == itemChargeMax) {
                        ModTriggers.FILL_VIAL_4.trigger(player);
                    }
                }
            }
        } else {
            result = 0.0f;
            if (itemCharge > 0.0f) {
                consume = Math.min(charge, amount);
                result += consume;
                charge -= consume;
            }
        }
        if (charge != itemCharge) {
            ItemStack s = null;
            if (itemStack.m_41613_() > 1) {
                s = itemStack.m_41620_(itemStack.m_41613_() - 1);
            }
            ItemVial.setItemCharge(itemStack, charge);
            if (s != null && player != null) {
                player.m_36356_(s);
            }
        }
        return result;
    }

    private static float round(float chargeValue) {
        return (float)Math.round(chargeValue * 100.0f) / 100.0f;
    }

    public static float getItemCharge(ItemStack itemStack) {
        CompoundTag charge;
        if (itemStack.m_41720_() instanceof ItemVial && (charge = itemStack.m_41737_("Charge")) != null) {
            float value = ItemVial.round(charge.m_128457_("Value"));
            if (value > 0.0f) {
                return value;
            }
            itemStack.m_41749_("Charge");
        }
        return 0.0f;
    }

    public static void setItemCharge(ItemStack itemStack, float value) {
        if (itemStack.m_41720_() instanceof ItemVial) {
            if (value > 0.0f) {
                CompoundTag charge = itemStack.m_41698_("Charge");
                charge.m_128350_("Value", ItemVial.round(value));
                charge.m_128356_("Stamp", System.currentTimeMillis());
            } else {
                itemStack.m_41749_("Charge");
            }
        }
    }

    public static float getItemMaxCharge(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ItemVial) {
            ItemVial itemCrystal = (ItemVial)itemStack.m_41720_();
            return ItemVial.getChargeMax(itemCrystal.id);
        }
        return 0.0f;
    }

    public static float getFullnessPropertyOverride(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, int i) {
        float chargeMax = ItemVial.getItemMaxCharge(itemStack);
        return (double)(ItemVial.getItemCharge(itemStack) / (chargeMax + 1.0f)) < 0.1 ? 0.0f : 1.0f;
    }
}

