/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.tileentity.DTController;
import org.cursegame.minecraft.dt.tileentity.DTControllerProvider;

public class ServerMessageDT {
    private final Action action;
    private final BlockPos pos;

    public ServerMessageDT(Action action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    static ServerMessageDT fromBytes(FriendlyByteBuf buf) {
        return new ServerMessageDT(Action.values()[buf.readShort()], buf.m_130135_());
    }

    static void toBytes(ServerMessageDT msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.action.ordinal());
        buf.m_130064_(msg.pos);
    }

    public static enum Action {
        START,
        CANCEL,
        TOGGLE_AUTO,
        BROWSE_RECIPE,
        HEAD_S,
        HEAD_D;

    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerMessageDT message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    BlockEntity tileEntity = player.f_19853_.m_7702_(message.pos);
                    if (tileEntity instanceof DTControllerProvider) {
                        DTController playerController = ((DTControllerProvider)tileEntity).getController(player);
                        if (playerController != null) {
                            switch (message.action) {
                                case START: {
                                    playerController.commandStarted();
                                    break;
                                }
                                case CANCEL: {
                                    playerController.commandCancelled();
                                    break;
                                }
                                case TOGGLE_AUTO: {
                                    playerController.commandStartedPermanently();
                                    break;
                                }
                                case BROWSE_RECIPE: {
                                    playerController.commandBrowse();
                                    break;
                                }
                                case HEAD_S: {
                                    if (!(player.f_36096_ instanceof ContainerDT)) break;
                                    ((ContainerDT)player.f_36096_).commandHeadS((Player)player);
                                    break;
                                }
                                case HEAD_D: {
                                    if (!(player.f_36096_ instanceof ContainerDT)) break;
                                    ((ContainerDT)player.f_36096_).commandHeadD((Player)player);
                                }
                            }
                        } else {
                            ModDT.LOGGER.warn("Illegal access to tile entity by {} at {}", (Object)player, (Object)message.pos);
                        }
                    } else {
                        ModDT.LOGGER.warn("Tile entity at {} isn't a player controllable", (Object)message.pos);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

