/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;
import org.cursegame.minecraft.dt.registry.ModItems;

public class RecipeProvider {
    private static void loadRegisteredRecipes(Collection<Recipe<?>> candidates, final BiConsumer<Recipe<?>, ReversedRecipe> consumer) {
        for (final Recipe<?> candidate : candidates) {
            ItemStack recipeItem;
            if (candidate instanceof ShapedRecipe && candidate.m_5598_()) {
                ModDT.LOGGER.debug("   skip dynamic recipe {}", (Object)candidate.m_6423_());
                continue;
            }
            NonNullList ingredients = candidate.m_7527_();
            if (candidate instanceof UpgradeRecipe) {
                RecipeProvider.populateIngredients((List<Ingredient>)ingredients, (UpgradeRecipe)candidate);
            }
            if ((recipeItem = candidate.m_8043_()).m_41619_() || ingredients.isEmpty()) continue;
            LinkedHashMap groups = new LinkedHashMap();
            ingredients.stream().filter(i -> i != Ingredient.f_43901_).forEach(i -> groups.compute(new Group(i.m_43908_()), (items, count) -> count == null ? 1 : count + 1));
            new Variator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(LinkedList<Map.Entry<Group, Integer>> entries, LinkedList<ItemStack> variant) {
                    if (entries.isEmpty()) {
                        if (!variant.isEmpty()) {
                            ReversedRecipe r = new ReversedRecipe(recipeItem, variant);
                            if (!candidate.m_5598_()) {
                                r.setSourceId(candidate.m_6423_());
                            }
                            if (candidate instanceof AbstractCookingRecipe) {
                                if (variant.stream().anyMatch(s -> s.m_41720_().m_41465_())) {
                                    return;
                                }
                                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)candidate;
                                r.setExperience(cookingRecipe.m_43750_());
                            }
                            consumer.accept(candidate, r);
                        }
                    } else {
                        Map.Entry<Group, Integer> tail = entries.pollFirst();
                        try {
                            for (ItemStack item : tail.getKey().items) {
                                ItemStack itemStack = new ItemStack((ItemLike)item.m_41720_(), tail.getValue().intValue());
                                variant.addLast(itemStack);
                                try {
                                    this.accept(entries, variant);
                                }
                                finally {
                                    variant.removeLast();
                                }
                            }
                        }
                        finally {
                            entries.addFirst(tail);
                        }
                    }
                }
            }.accept(new LinkedList<Map.Entry<Group, Integer>>(groups.entrySet()), new LinkedList<ItemStack>());
        }
    }

    public static void loadRegisteredRecipes(Collection<Recipe<?>> candidates, List<ReversedRecipe> target, RecipeType<?> ... excludes) {
        LinkedHashMap recipeTypeIndex = new LinkedHashMap();
        BiConsumer<RecipeType, ReversedRecipe.Id> recipeTypeIndexCollector = (t, r) -> recipeTypeIndex.computeIfAbsent(t, k -> new HashSet()).add(r);
        ArrayList result = new ArrayList();
        RecipeProvider.loadRegisteredRecipes(candidates, (i, r) -> {
            recipeTypeIndexCollector.accept(i.m_6671_(), r.getId());
            result.add(r);
        });
        result.forEach(r -> {
            for (RecipeType exclude : excludes) {
                if (!recipeTypeIndex.getOrDefault(exclude, Collections.emptySet()).contains(r.getId())) continue;
                return;
            }
            target.add((ReversedRecipe)r);
        });
    }

    public static void deleteDuplicates(List<ReversedRecipe> registeredRecipes) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        registeredRecipes.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).computeIfAbsent(r.getId(), id -> new ArrayList()).add(r));
        registeredRecipes.clear();
        index.forEach((i, m) -> m.forEach((id, vs) -> vs.stream().sorted(Comparator.comparing(ReversedRecipe::ration)).findFirst().ifPresent(registeredRecipes::add)));
    }

    public static void disable0level(List<ReversedRecipe> target) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        target.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).put(r.getId(), r));
        index.forEach((i, m) -> m.forEach((id, r) -> {
            if (!r.isRecipeDisabled() && id.getOut().contains(i)) {
                ModDT.LOGGER.debug("L0: disabled {}->{} due to input exists in the output", (Object)id.getIn(), id.getOut());
                r.setRecipeDisabled(true);
                return;
            }
            if (!r.isRecipeDisabled()) {
                for (Item o : id.getOut()) {
                    ReversedRecipe.Id fd = new ReversedRecipe.Id(o, Collections.singleton(i));
                    if (!index.getOrDefault(o, Collections.emptyMap()).containsKey(fd)) continue;
                    ModDT.LOGGER.debug("L0: disabled {}->{} due to forward recipe found {}->{}", (Object)id.getIn(), id.getOut(), (Object)fd.getIn(), fd.getOut());
                    r.setRecipeDisabled(true);
                    return;
                }
            }
        }));
    }

    public static void disable1level(List<ReversedRecipe> target) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        target.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).put(r.getId(), r));
        index.forEach((i, m) -> m.forEach((id, r) -> {
            if (!r.isRecipeDisabled()) {
                for (int oIndex = 0; oIndex < id.getOut().size(); ++oIndex) {
                    Item oItem = id.getOut(oIndex);
                    for (ReversedRecipe pr : index.getOrDefault(oItem, Collections.emptyMap()).values()) {
                        if (pr.getSourceId().m_135827_() != r.getSourceId().m_135827_()) continue;
                        ReversedRecipe.Id pd = pr.getId();
                        for (ReversedRecipe sr : m.values()) {
                            Item sItem;
                            ReversedRecipe.Id sd;
                            if (sr.getSourceId().m_135827_() != r.getSourceId().m_135827_() || (sd = sr.getId()) == id || (sItem = sd.getOut(oIndex)) == null || !pd.getOut().contains(sItem)) continue;
                            ModDT.LOGGER.debug("L1: disabled {}->{} due to {}->{} where {} in siblings with index {}", (Object)id.getIn(), id.getOut(), (Object)pd.getIn(), pd.getOut(), (Object)sItem, (Object)oIndex);
                            r.setRecipeDisabled(true);
                            return;
                        }
                    }
                }
            }
        }));
    }

    public static void disableDefiant(List<ReversedRecipe> target) {
        HashSet disableOutput = Sets.newHashSet((Object[])new Item[]{Items.f_42532_, Items.f_41909_, Items.f_42787_, Items.f_42028_, Items.f_42575_, Items.f_42046_, Items.f_41911_, Items.f_41868_, Items.f_42534_, Items.f_41939_, Items.f_41940_, Items.f_41941_, Items.f_41942_, Items.f_41943_, Items.f_41945_, Items.f_41947_, Items.f_41944_, Items.f_41946_, Items.f_41948_, Items.f_41949_, Items.f_41950_, Items.f_41951_, Items.f_42206_, Items.f_42207_, Items.f_42208_, Items.f_42209_});
        Set dyes = Stream.of(DyeColor.values()).map(DyeItem::m_41082_).collect(Collectors.toSet());
        target.forEach(r -> {
            if (r.getOut().size() == 1 && disableOutput.contains(r.getId().getOut(0))) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to in the defiant list", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
            if (dyes.contains(r.getId().getIn()) && !dyes.containsAll(r.getId().getOut())) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to dye produce non dye item", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
            if (Tags.Items.SEEDS.m_8110_((Object)r.getId().getIn())) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to seed", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
        });
    }

    public static void addSystemSet(List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_0, 9), new ItemStack((ItemLike)Items.f_42647_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_1, 9), new ItemStack((ItemLike)Items.f_42594_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_2, 9), new ItemStack((ItemLike)Items.f_42416_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_3, 9), new ItemStack((ItemLike)Items.f_42415_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_4, 9), new ItemStack((ItemLike)Items.f_42417_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)ModItems.DUST_5, 9), new ItemStack((ItemLike)Items.f_42418_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42013_), new ItemStack((ItemLike)Items.f_42594_), EntityType.f_20523_));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42017_), new ItemStack((ItemLike)Items.f_42021_), EntityType.f_20523_));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42016_), new ItemStack((ItemLike)Items.f_42020_), EntityType.f_20523_));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42015_), new ItemStack((ItemLike)Items.f_42019_), EntityType.f_20523_));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42012_), new ItemStack((ItemLike)Items.f_41905_), EntityType.f_20523_));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42014_), new ItemStack((ItemLike)Items.f_42018_), EntityType.f_20523_));
    }

    public static void addCustomSet(List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42718_), new ItemStack((ItemLike)Items.f_42399_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42589_), new ItemStack((ItemLike)Items.f_42590_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42736_), new ItemStack((ItemLike)Items.f_42590_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42739_), new ItemStack((ItemLike)Items.f_42590_)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Blocks.f_50680_), new ItemStack((ItemLike)Items.f_41905_, 4), new ItemStack((ItemLike)Items.f_41912_), new ItemStack((ItemLike)Items.f_42398_, 3)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Blocks.f_50323_), new ItemStack((ItemLike)Items.f_41913_, 2), new ItemStack((ItemLike)Items.f_42416_, 4)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Blocks.f_50324_), new ItemStack((ItemLike)Items.f_41913_, 1), new ItemStack((ItemLike)Items.f_42416_, 4)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42467_), new ItemStack((ItemLike)Items.f_42026_, 4)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42466_), new ItemStack((ItemLike)Items.f_42026_, 7)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42464_), new ItemStack((ItemLike)Items.f_42026_, 4)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42026_, 8)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42651_), new ItemStack((ItemLike)Items.f_42416_, 7)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42652_), new ItemStack((ItemLike)Items.f_42417_, 7)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42653_), new ItemStack((ItemLike)Items.f_42415_, 7)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42450_), new ItemStack((ItemLike)Items.f_42454_, 5), new ItemStack((ItemLike)Items.f_42416_, 3)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42747_), new ItemStack((ItemLike)Items.f_42436_), new ItemStack((ItemLike)Items.f_42587_, 5), new ItemStack((ItemLike)Items.f_42616_, 2)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42615_), new ItemStack((ItemLike)Items.f_42614_)));
    }

    public static void addGrinds(Collection<Recipe<?>> candidates, List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)ModItems.DUST_2, 9)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)ModItems.DUST_3, 9)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)ModItems.DUST_4, 9)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42418_), new ItemStack((ItemLike)ModItems.DUST_5, 9)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42454_), new ItemStack((ItemLike)ModItems.LEATHER_STRIP, 9)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42109_, 2), new ItemStack((ItemLike)ModItems.DUST_2, 9), new ItemStack((ItemLike)Items.f_42398_, 2)));
        target.add(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42026_), new ItemStack((ItemLike)ModItems.DUST_2, 11)));
        RecipeProvider.forTagItems("forge:stone", item -> target.add(new ReversedRecipe(new ItemStack((ItemLike)item), new ItemStack((ItemLike)ModItems.DUST_1, 9))));
        RecipeProvider.forTagItems("forge:cobblestone", item -> target.add(new ReversedRecipe(new ItemStack((ItemLike)item), new ItemStack((ItemLike)ModItems.DUST_1, 9))));
        RecipeProvider.forTagItems("minecraft:planks", item -> target.add(new ReversedRecipe(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42398_, 2))));
        RecipeProvider.forTagItems("minecraft:logs", item -> target.add(new ReversedRecipe(new ItemStack((ItemLike)item), new ItemStack((ItemLike)Items.f_42398_, 8))));
        target.sort(ReversedRecipe.ORDER_NATURAL);
        ModDT.LOGGER.debug("Grind recipes:");
        for (ReversedRecipe t : target) {
            ModDT.LOGGER.debug("  {}", (Object)t);
        }
    }

    public static void forTagItems(String tag, Consumer<Item> c) {
        ResourceLocation resourcelocation = new ResourceLocation(tag);
        Tag<Item> iTag = RecipeProvider.getTag(resourcelocation);
        if (iTag == null) {
            ModDT.LOGGER.warn("No tag registered: {}", (Object)tag);
        } else {
            iTag.m_6497_().forEach(c);
        }
    }

    public static Tag<Item> getTag(ResourceLocation resourcelocation) {
        return ItemTags.m_13193_().m_13404_(resourcelocation);
    }

    private static void populateIngredients(List<Ingredient> ingredients, UpgradeRecipe recipe) {
        FriendlyByteBuf friendlyBB = new FriendlyByteBuf(Unpooled.buffer());
        RecipeSerializer.f_44096_.m_6178_(friendlyBB, (Recipe)recipe);
        Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)friendlyBB);
        Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)friendlyBB);
        ingredients.add(base);
        ingredients.add(addition);
        friendlyBB.clear();
    }

    private static class Group {
        private final ItemStack[] items;

        public Group(ItemStack[] items) {
            int tagLimit = (Integer)Configuration.getInstance().server.tagLimit.get();
            this.items = (ItemStack[])Stream.of(items).limit(tagLimit > 0 ? (long)tagLimit : (long)items.length).toArray(ItemStack[]::new);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            for (ItemStack item : this.items) {
                result = 31 * result + item.m_41720_().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            Group other = (Group)o;
            if (this.items.length != other.items.length) {
                return false;
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].m_41720_() == other.items[i].m_41720_()) continue;
                return false;
            }
            return true;
        }
    }

    static interface Variator {
        public void accept(LinkedList<Map.Entry<Group, Integer>> var1, LinkedList<ItemStack> var2);
    }
}

