/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.commons.lang3.time.StopWatch;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.capability.Slots;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.item.ItemDisk;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.recipe.RecipeProvider;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeHolder;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverride;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverrides;
import org.cursegame.minecraft.dt.registry.ModItems;
import org.cursegame.minecraft.dt.registry.ModTags;

public class RecipeService {
    public static final int ORB_XP = 7;
    private static RecipeService instance;
    private RecipeManager recipeManager;
    private List<ReversedRecipe> grinds = NonNullList.m_122779_();
    private Map<Item, Set<ReversedRecipe>> recipeIndex = new LinkedHashMap<Item, Set<ReversedRecipe>>();
    private List<ReversedRecipe> recipes = NonNullList.m_122779_();

    public static RecipeService getInstance() {
        if (instance == null) {
            instance = new RecipeService();
        }
        return instance;
    }

    private RecipeService() {
    }

    public RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            throw new IllegalStateException("Recipe manager isn't initialized yet");
        }
        return this.recipeManager;
    }

    public void initialize(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        this.loadRecipes();
        this.loadGrinds();
    }

    private void loadGrinds() {
        RecipeProvider.addGrinds(this.getRecipeManager().m_44051_(), this.grinds);
    }

    public List<ReversedRecipe> getRegisteredRecipes() {
        return this.recipes;
    }

    private void loadRecipes() {
        StopWatch sw = StopWatch.createStarted();
        RecipeProvider.addSystemSet(this.recipes);
        RecipeProvider.addCustomSet(this.recipes);
        RecipeProvider.loadRegisteredRecipes(this.getRecipeManager().m_44051_(), this.recipes, RecipeType.f_44109_);
        RecipeProvider.deleteDuplicates(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe collecting {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disableDefiant(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering defiant {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disable0level(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering level 0 {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disable1level(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering level 1 {}ms", (Object)sw.getSplitTime());
        ReversedRecipeOverrides recipeOverrides = Configuration.getInstance().loadOverrides();
        HashSet toHide = new HashSet();
        HashSet toShow = new HashSet();
        HashMap toSwap = new HashMap();
        recipeOverrides.getOverrides().forEach(o -> {
            switch (o.getAction()) {
                case HIDE: {
                    toHide.add(o.getRecipe().getId());
                    break;
                }
                case SHOW: {
                    toShow.add(o.getRecipe().getId());
                    break;
                }
                case SWAP: {
                    toSwap.put(o.getRecipe().getId(), o.getUpdate());
                    break;
                }
            }
        });
        if (Stream.of(new ReversedRecipe(new ItemStack((ItemLike)Items.f_42542_), new ItemStack((ItemLike)Items.f_42593_), new ItemStack((ItemLike)Items.f_42518_))).mapToInt(r -> {
            ReversedRecipe s = (ReversedRecipe)toSwap.get(r.getId());
            if (s == null) {
                toSwap.put(r.getId(), r);
                recipeOverrides.getOverrides().add(new ReversedRecipeOverride(ReversedRecipeOverride.Action.SWAP, (ReversedRecipe)r, r.copy().setExperience(35.0f)));
                return 1;
            }
            return 0;
        }).sum() > 0) {
            Configuration.getInstance().saveOverrides();
        }
        for (ReversedRecipe r2 : this.recipes) {
            ReversedRecipe s;
            if (toHide.contains(r2.getId()) && !r2.isRecipeDisabled()) {
                ModDT.LOGGER.info("Hide recipe {}->{} due to config override", (Object)r2.getId().getIn(), r2.getId().getOut());
                r2.setRecipeDisabled(true);
            }
            if (toShow.contains(r2.getId()) && r2.isRecipeDisabled()) {
                ModDT.LOGGER.info("Show recipe {}->{} due to config override", (Object)r2.getId().getIn(), r2.getId().getOut());
                r2.setRecipeDisabled(false);
            }
            if ((s = (ReversedRecipe)toSwap.get(r2.getId())) == null) continue;
            r2.setExperience(s.getExperience());
        }
        ModDT.LOGGER.info("Loaded {} deconstruction schemas, {}ms", (Object)this.recipes.size(), (Object)sw.getTime());
        this.recipes.forEach(r -> this.recipeIndex.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashSet()).add(r));
    }

    private ReversedRecipe getGrindRecipe(Item item) {
        return this.grinds.stream().filter(r -> r.getIn().m_41720_() == item).findFirst().orElse(null);
    }

    public static NonNullList<ReversedRecipe> getRecipesForSearch(Map<Item, ReversedRecipeHolder> recipes, String searchText) {
        return recipes.values().stream().flatMap(rh -> rh.getItems().stream()).filter(recipe -> searchText.isEmpty() || recipe.getIn().m_41611_().getString().toLowerCase().contains(searchText)).sorted(ReversedRecipe.ORDER_NATURAL).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    public Result estimate(Input input, Level world) {
        Map enchantments;
        CompoundTag data;
        Result result = new Result();
        ReversedRecipe currentRecipe = null;
        ReversedRecipeHolder recipeHolder = input.recipes.get(input.itemStack.m_41720_());
        if (recipeHolder != null) {
            currentRecipe = recipeHolder.getCurrentRecipe();
        }
        if (currentRecipe == null && input.itemStack.m_41720_() == Items.f_42738_) {
            currentRecipe = new ReversedRecipe(new ItemStack((ItemLike)Items.f_42738_, 8), new ItemStack((ItemLike)Items.f_42412_, 8));
        }
        if (currentRecipe == null && input.itemStack.m_41720_() == Items.f_42573_) {
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)input.itemStack, (Level)world);
            currentRecipe = mapData != null ? new ReversedRecipe(new ItemStack((ItemLike)Items.f_42573_), new ItemStack((ItemLike)Items.f_42676_), new ItemStack((ItemLike)Items.f_42516_, (int)mapData.f_77890_)) : new ReversedRecipe(new ItemStack((ItemLike)Items.f_42573_), new ItemStack((ItemLike)Items.f_42676_));
        }
        if (currentRecipe == null && input.itemStack.m_41720_() == Items.f_42688_) {
            ArrayList<ItemStack> stacksOut = new ArrayList<ItemStack>();
            stacksOut.add(new ItemStack((ItemLike)Items.f_42403_));
            stacksOut.add(new ItemStack((ItemLike)Items.f_42516_));
            CompoundTag tagFireworks = input.itemStack.m_41737_("Fireworks");
            if (tagFireworks != null) {
                ListTag tagExplosions = tagFireworks.m_128437_("Explosions", 10);
                tagExplosions.stream().map(CompoundTag.class::cast).forEach(c -> {
                    ItemStack starStack = new ItemStack((ItemLike)Items.f_42689_);
                    CompoundTag starStackTag = new CompoundTag();
                    starStackTag.m_128365_("Explosion", (Tag)c);
                    starStack.m_41751_(starStackTag);
                    stacksOut.add(starStack);
                });
            }
            currentRecipe = new ReversedRecipe(new ItemStack((ItemLike)Items.f_42688_, 3), stacksOut);
        }
        if (currentRecipe != null) {
            Block bannerBlock;
            CompoundTag tag;
            CompoundTag compoundTag;
            DyeableArmorItem dyeableArmorItem;
            if (input.itemStack.m_41720_() instanceof DyeableArmorItem && (dyeableArmorItem = (DyeableArmorItem)input.itemStack.m_41720_()).m_41113_(input.itemStack)) {
                int color = dyeableArmorItem.m_41121_(input.itemStack);
                for (ListTag value : DyeColor.values()) {
                    int k;
                    int j;
                    int i = Math.round(value.m_41068_()[0] * 255.0f);
                    int dyeColor = (i << 16) + ((j = Math.round(value.m_41068_()[1] * 255.0f)) << 8) + (k = Math.round(value.m_41068_()[2] * 255.0f));
                    if (color != dyeColor) continue;
                    result.items.add(new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)value)));
                    break;
                }
            }
            if (input.itemStack.m_41720_() instanceof BannerItem && (compoundTag = input.itemStack.m_41737_("BlockEntityTag")) != null && compoundTag.m_128441_("Patterns")) {
                ListTag patterns = compoundTag.m_128437_("Patterns", 10);
                for (int i = 0; i < patterns.size() && i < 6; ++i) {
                    DyeItem dyeItem = DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)patterns.m_128728_(i).m_128451_("Color")));
                    if (dyeItem == null) continue;
                    result.items.add(new ItemStack((ItemLike)dyeItem));
                }
            }
            if (input.itemStack.m_41720_() instanceof ShieldItem && (tag = input.itemStack.m_41737_("BlockEntityTag")) != null && (bannerBlock = BannerBlock.m_49014_((DyeColor)DyeColor.m_41053_((int)tag.m_128451_("Base")))) != null) {
                ItemStack bannerItem = new ItemStack((ItemLike)bannerBlock);
                if (tag.m_128441_("Patterns")) {
                    bannerItem.m_41698_("BlockEntityTag").m_128365_("Patterns", (Tag)tag.m_128437_("Patterns", 10).m_6426_());
                }
                result.items.add(bannerItem);
            }
        }
        if (currentRecipe == null && input.itemStack.m_41720_() == Items.f_42612_) {
            currentRecipe = new ReversedRecipe(new ItemStack((ItemLike)Items.f_42612_), new ItemStack((ItemLike)Items.f_42590_));
            result.xp = 700;
        }
        if (input.itemStack.m_150922_(ModTags.Items.vials)) {
            float charge = ItemVial.getItemCharge(input.itemStack);
            if (charge > 0.0f || currentRecipe == null) {
                currentRecipe = new ReversedRecipe(new ItemStack((ItemLike)input.itemStack.m_41720_()), new ItemStack((ItemLike)input.itemStack.m_41720_()));
            }
            result.xp = (int)(100.0f * ItemVial.getItemCharge(input.itemStack));
        }
        if (currentRecipe != null) {
            result.recipeAvailable = true;
            result.recipeAmbiguous = recipeHolder != null && recipeHolder.getItems().size() > 1;
            result.recipeDisabled = currentRecipe.isRecipeDisabled();
            result.entityType = currentRecipe.getEntityType();
        }
        if (currentRecipe != null && (data = input.itemStack.m_41783_()) != null) {
            boolean listDetected = false;
            block4: for (String key : data.m_128431_()) {
                Tag value = data.m_128423_(key);
                if (!(value instanceof ListTag)) continue;
                ListTag listTag = (ListTag)value;
                for (Tag listItem : listTag) {
                    listDetected = true;
                    if (!(listItem instanceof CompoundTag)) continue;
                    CompoundTag compoundTag = (CompoundTag)listItem;
                    try {
                        ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag);
                        if (itemStack2.m_41619_()) continue;
                        result.content.add(itemStack2);
                    }
                    catch (Throwable t) {
                        continue block4;
                    }
                }
            }
            if (listDetected && !result.content.isEmpty()) {
                ModDT.LOGGER.debug("Nested items found (to be thrown out): {}", result.content);
            }
        }
        ModDT.LOGGER.debug("Analysed item {} tag {}", (Object)input.itemStack, (Object)input.itemStack.m_41783_());
        if (currentRecipe != null) {
            ModDT.LOGGER.debug("    recipe {} {}", (Object)currentRecipe.getSourceId(), (Object)currentRecipe);
        }
        if (currentRecipe != null) {
            boolean isDamagedStack;
            boolean bl = isDamagedStack = input.itemStack.m_41776_() > 0 && input.itemStack.m_41773_() > 0;
            if (isDamagedStack) {
                if (input.itemStack.m_41613_() != 1) {
                    throw new IllegalStateException();
                }
                this.processPartial(result, currentRecipe, 1.0f - 1.0f * (float)input.itemStack.m_41773_() / (float)input.itemStack.m_41776_());
                ++result.itemConsumed;
            } else {
                if (input.itemStack.m_41613_() < currentRecipe.getIn().m_41613_()) {
                    this.processPartial(result, currentRecipe, 1.0f * (float)input.itemStack.m_41613_() / (float)currentRecipe.getIn().m_41613_());
                } else {
                    result.items.addAll(currentRecipe.getOut());
                }
                result.itemConsumed += currentRecipe.getIn().m_41613_();
            }
            float experience = currentRecipe.getExperience();
            if (experience > 0.0f) {
                result.bondConsumed = (int)(100.0f * experience);
                if (input.itemStack.m_41720_() == ModItems.ESSENCE) {
                    result.bondConsumed = 700 - result.bondConsumed;
                }
            }
        }
        if (!(enchantments = EnchantmentHelper.m_44831_((ItemStack)input.itemStack)).isEmpty()) {
            int bookCount = input.bookStack.m_41613_();
            if (input.itemStack.m_41720_() == Items.f_42690_) {
                if (enchantments.size() < 2 || bookCount == 0) {
                    ItemStack bookItem = new ItemStack((ItemLike)Items.f_42517_);
                    result.items.add(bookItem);
                    result.xp += RecipeService.getEnchantmentXp(enchantments);
                } else {
                    --result.bookConsumed;
                    ++bookCount;
                    LinkedList q = new LinkedList(enchantments.entrySet());
                    block6: while (q.size() > 0) {
                        ItemStack currentBook = null;
                        while (q.size() > 0) {
                            Map.Entry entry = (Map.Entry)q.poll();
                            if (currentBook == null && bookCount > 0) {
                                currentBook = new ItemStack((ItemLike)Items.f_42690_);
                                result.items.add(currentBook);
                                ++result.bookConsumed;
                                --bookCount;
                            }
                            if (currentBook != null) {
                                EnchantedBookItem.m_41153_((ItemStack)currentBook, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                            }
                            if (bookCount <= 0) continue;
                            continue block6;
                        }
                    }
                }
                ++result.itemConsumed;
            } else {
                if (bookCount > 0) {
                    ItemStack currentBook = new ItemStack((ItemLike)Items.f_42690_);
                    for (Map.Entry entry : enchantments.entrySet()) {
                        EnchantedBookItem.m_41153_((ItemStack)currentBook, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    }
                    result.items.add(currentBook);
                    ++result.bookConsumed;
                    --bookCount;
                } else {
                    result.xp += RecipeService.getEnchantmentXp(enchantments);
                }
                if (currentRecipe == null) {
                    ItemStack itemStack3 = input.itemStack.m_41777_();
                    EnchantmentHelper.m_44865_(Collections.emptyMap(), (ItemStack)itemStack3);
                    result.items.add(itemStack3);
                    ++result.itemConsumed;
                }
            }
        }
        if (result.xp > 0 && !input.bondStack.m_41619_()) {
            float itemCharge = ItemVial.getItemCharge(input.bondStack);
            float itemMaxCharge = ItemVial.getItemMaxCharge(input.bondStack);
            int capacity = (int)(100.0f * (itemMaxCharge - itemCharge));
            if (result.xp <= capacity) {
                capacity = result.xp;
            }
            result.xp -= capacity;
            result.bondConsumed -= capacity;
        }
        if (result.xp > 0 && input.vialStack.m_41720_() == Items.f_42590_ && input.itemStack.m_41720_() != Items.f_42612_) {
            int bulbCount = input.vialStack.m_41613_();
            int orbXp = 700;
            ItemStack bulbItem = new ItemStack((ItemLike)Items.f_42612_, 0);
            while (bulbCount > 0 && result.xp >= 700) {
                bulbItem.m_41769_(1);
                --bulbCount;
                result.xp -= 700;
            }
            if (!bulbItem.m_41619_()) {
                result.items.add(bulbItem);
                result.vialConsumed += bulbItem.m_41613_();
            }
        }
        if (result.xp > 0 && (result.vialConsumed != 0 || result.bondConsumed != 0)) {
            result.items.forEach(itemStack -> {
                float itemMaxCharge;
                if (itemStack.m_41613_() == 1 && (itemMaxCharge = ItemVial.getItemMaxCharge(itemStack)) > 0.0f) {
                    int capacity = (int)(100.0f * (itemMaxCharge - ItemVial.getItemCharge(itemStack)));
                    if (result.xp <= capacity) {
                        capacity = result.xp;
                    }
                    result.xp -= capacity;
                    ItemVial.charge(itemStack, null, (float)(-capacity) / 100.0f);
                }
            });
        }
        if (currentRecipe != null) {
            CompoundTag tag;
            ArrayList<MobEffectInstance> itemStackEffects = PotionUtils.m_43547_((ItemStack)input.itemStack);
            if (itemStackEffects.isEmpty() && (tag = input.itemStack.m_41783_()) != null) {
                ListTag listTag = tag.m_128437_("Effects", 10);
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag effectTag = listTag.m_128728_(i);
                    MobEffect effect = MobEffect.m_19453_((int)effectTag.m_128445_("EffectId"));
                    if (effect == null) continue;
                    itemStackEffects.add(new MobEffectInstance(effect, effectTag.m_128451_("EffectDuration")));
                }
            }
            if (itemStackEffects.size() > 0 && input.itemStack.m_41613_() >= currentRecipe.getIn().m_41613_() && Slots.VIAL_POTION.test(input.vialStack)) {
                LinkedHashSet<MobEffect> effects = new LinkedHashSet<MobEffect>();
                HashMap<MobEffect, Object> stackEffects = new HashMap<MobEffect, Object>();
                for (Object effect : PotionUtils.m_43547_((ItemStack)input.vialStack)) {
                    effects.add(effect.m_19544_());
                    stackEffects.put(effect.m_19544_(), effect);
                }
                HashMap<MobEffect, MobEffectInstance> arrowEffects = new HashMap<MobEffect, MobEffectInstance>();
                for (MobEffectInstance effect : itemStackEffects) {
                    effects.add(effect.m_19544_());
                    arrowEffects.put(effect.m_19544_(), effect);
                }
                ItemStack itemStack4 = new ItemStack((ItemLike)input.vialStack.m_41720_());
                itemStackEffects = new ArrayList<MobEffectInstance>();
                for (MobEffect effect : effects) {
                    int a;
                    int d;
                    MobEffectInstance l = (MobEffectInstance)stackEffects.get(effect);
                    MobEffectInstance r = (MobEffectInstance)arrowEffects.get(effect);
                    if (l == null) {
                        d = PotionUtils.m_43579_((ItemStack)input.vialStack) == Potions.f_43602_ ? r.m_19557_() : r.m_19557_() / 2;
                        a = r.m_19564_();
                    } else if (r == null) {
                        d = l.m_19557_() / 2;
                        a = l.m_19564_();
                    } else {
                        float s = Math.max(l.m_19557_(), r.m_19557_());
                        float v = Math.min(l.m_19557_(), r.m_19557_());
                        s += v * v / (s + v);
                        d = (int)s;
                        a = Math.min(l.m_19564_(), r.m_19564_());
                    }
                    itemStackEffects.add(new MobEffectInstance(effect, d, a));
                }
                Potion potion = PotionUtils.m_43579_((ItemStack)input.itemStack);
                if (potion != Potions.f_43598_ && itemStackEffects.containsAll(potion.m_43488_())) {
                    PotionUtils.m_43549_((ItemStack)itemStack4, (Potion)potion);
                    itemStackEffects.removeAll(potion.m_43488_());
                }
                PotionUtils.m_43552_((ItemStack)itemStack4, itemStackEffects);
                result.items.add(itemStack4);
                ++result.vialConsumed;
            }
        }
        if (input.diskStack.m_41720_() != ItemDisk.DUMMY) {
            ++result.diskConsumed;
        }
        return result;
    }

    private void processPartial(Result result, ReversedRecipe recipe, float damage) {
        HashMap output = new HashMap();
        recipe.getOut().forEach(s -> {
            if (s.m_41763_()) {
                ItemStack itemStack = new ItemStack((ItemLike)s.m_41720_());
                itemStack.m_41721_(itemStack.m_41776_() - (int)((float)itemStack.m_41776_() * damage));
                output.put(s.m_41720_(), itemStack);
            } else {
                this.evaluate(output, IntStream.range(0, s.m_41613_()).boxed().map(i -> s.m_41720_()).collect(Collectors.toList()), damage);
            }
        });
        result.items.addAll(output.values());
    }

    private float evaluate(Map<Item, ItemStack> output, List<Item> line, float part) {
        for (int i = 0; i < line.size(); ++i) {
            float f = part * (float)line.size();
            if (i < (int)f) {
                output.computeIfAbsent(line.get(i), item -> new ItemStack((ItemLike)item, 0)).m_41769_(1);
                continue;
            }
            ReversedRecipe recipe = this.getGrindRecipe(line.get(i));
            if (recipe == null) continue;
            this.evaluate(output, recipe.toFlatOut(), (f - (float)((int)f)) / (float)recipe.getIn().m_41613_());
            break;
        }
        return part;
    }

    private List<ReversedRecipe> loadUserDefinedRecipes(ServerPlayer player) {
        CompoundTag preferredRecipes = player.getPersistentData().m_128469_("dt:preferred_recipes");
        ModDT.LOGGER.debug("loadUserDefinedRecipes {}", (Object)preferredRecipes);
        return preferredRecipes.m_128431_().stream().map(arg_0 -> ((CompoundTag)preferredRecipes).m_128469_(arg_0)).map(ReversedRecipe::asNBT).collect(Collectors.toList());
    }

    public void saveUserDefinedRecipe(ServerPlayer player, ReversedRecipe recipe) {
        CompoundTag preferredRecipes = player.getPersistentData().m_128469_("dt:preferred_recipes");
        preferredRecipes.m_128365_(recipe.getIn().m_41720_().getRegistryName().toString(), (Tag)ReversedRecipe.toNBT(recipe));
        ModDT.LOGGER.debug("saveUserDefinedRecipe {}", (Object)preferredRecipes);
        player.getPersistentData().m_128365_("dt:preferred_recipes", (Tag)preferredRecipes);
    }

    public void updateRecipeFromPlayerRecipeBook(ServerPlayer player, Map<Item, ReversedRecipeHolder> recipes) {
        ModDT.LOGGER.debug("Collecting recipes for {} ...", (Object)player.m_7755_().getString());
        StopWatch stopWatch = StopWatch.createStarted();
        this.updateRecipeFromRecipeBook(player, recipes);
        stopWatch.stop();
        ModDT.LOGGER.debug("Collecting done in {}ms", (Object)stopWatch.getTime());
    }

    public void updateRecipeFromRecipeBook(ServerPlayer player, Map<Item, ReversedRecipeHolder> recipes) {
        recipes.clear();
        boolean moderator = player.m_7500_();
        ServerRecipeBook recipeBook = player.m_8952_();
        Predicate<ReversedRecipe> userRecipePredicate = r -> !r.isRecipeDisabled() && (r.isCustomSource() || recipeBook.m_12711_(r.getSourceId()));
        this.recipeIndex.forEach((i, s) -> {
            ReversedRecipeHolder h = new ReversedRecipeHolder((NonNullList<ReversedRecipe>)NonNullList.m_122779_(), -1);
            for (ReversedRecipe r : s) {
                if (!moderator && !userRecipePredicate.test(r)) continue;
                h.addItem(r);
            }
            if (h.getItems().size() > 0) {
                recipes.put((Item)i, h);
            }
        });
        this.loadUserDefinedRecipes(player).forEach(recipe -> recipes.computeIfPresent(recipe.getIn().m_41720_(), (k, h) -> {
            int index = h.getItems().indexOf(recipe);
            if (index != -1) {
                h.setIndex(index);
            }
            return h;
        }));
    }

    public void browseRecipe(ServerPlayer player, ReversedRecipeHolder recipeHolder) {
        recipeHolder.addIndex();
        this.saveUserDefinedRecipe(player, recipeHolder.getCurrentRecipe());
    }

    public void toggleRecipeVisibility(ReversedRecipe recipe) {
        recipe.setRecipeDisabled(!recipe.isRecipeDisabled());
        ReversedRecipeOverrides recipeOverrides = Configuration.getInstance().loadOverrides();
        recipeOverrides.getOverrides().removeIf(o -> (o.getAction() == ReversedRecipeOverride.Action.HIDE || o.getAction() == ReversedRecipeOverride.Action.SHOW) && o.getRecipe().getId().equals(recipe.getId()));
        recipeOverrides.getOverrides().add(new ReversedRecipeOverride(recipe.isRecipeDisabled() ? ReversedRecipeOverride.Action.HIDE : ReversedRecipeOverride.Action.SHOW, recipe, null));
        Configuration.getInstance().saveOverrides();
    }

    public static int getEnchantmentXp(Map<Enchantment, Integer> enchantments) {
        float l = 0.0f;
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            Integer level = entry.getValue();
            l = (float)((double)l + (double)(enchantment.m_6183_(level.intValue()) + enchantment.m_6175_(level.intValue())) / 2.0);
        }
        return (int)(100.0f * l);
    }

    public static class Result {
        private final List<ItemStack> items = NonNullList.m_122779_();
        private final List<ItemStack> content = NonNullList.m_122779_();
        private int itemConsumed;
        private int diskConsumed;
        private int bookConsumed;
        private int vialConsumed;
        private int bondConsumed;
        private int xp;
        private boolean recipeAvailable;
        private boolean recipeAmbiguous;
        private boolean recipeDisabled;
        private EntityType<?> entityType;

        public List<ItemStack> getItems() {
            return this.items;
        }

        public List<ItemStack> getContent() {
            return this.content;
        }

        public int getItemConsumed() {
            return this.itemConsumed;
        }

        public int getDiskConsumed() {
            return this.diskConsumed;
        }

        public int getBookConsumed() {
            return this.bookConsumed;
        }

        public int getVialConsumed() {
            return this.vialConsumed;
        }

        public int getBondConsumed() {
            return this.bondConsumed;
        }

        public int getXp() {
            return this.xp;
        }

        public boolean isRecipeAvailable() {
            return this.recipeAvailable;
        }

        public boolean isRecipeAmbiguous() {
            return this.recipeAmbiguous;
        }

        public boolean isRecipeDisabled() {
            return this.recipeDisabled;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }
    }

    public static class Input {
        private final Map<Item, ReversedRecipeHolder> recipes;
        private final ItemStack itemStack;
        private final ItemStack diskStack;
        private final ItemStack bookStack;
        private final ItemStack vialStack;
        private final ItemStack bondStack;

        public Input(Map<Item, ReversedRecipeHolder> recipes, ItemStack itemStack, ItemStack diskStack, ItemStack bookStack, ItemStack vialStack, ItemStack bondStack) {
            this.recipes = recipes;
            this.itemStack = itemStack;
            this.diskStack = diskStack;
            this.bookStack = bookStack;
            this.vialStack = vialStack;
            this.bondStack = bondStack;
        }
    }
}

