/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;

public class ReversedRecipeHolder {
    private int index;
    private final NonNullList<ReversedRecipe> items;

    public ReversedRecipeHolder(NonNullList<ReversedRecipe> items, int index) {
        this.items = items;
        this.index = index;
    }

    public List<ReversedRecipe> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public ReversedRecipe getCurrentRecipe() {
        if (this.items.isEmpty()) {
            return null;
        }
        if (this.index < 0 || this.index >= this.items.size()) {
            this.index = 0;
        }
        return (ReversedRecipe)this.items.get(this.index);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void addIndex() {
        if (this.items.isEmpty()) {
            this.index = -1;
        } else {
            ++this.index;
            if (this.index == this.items.size()) {
                this.index = 0;
            }
        }
    }

    public boolean addItem(ReversedRecipe r) {
        if (this.items.contains((Object)r)) {
            ModDT.LOGGER.warn("recipe overlaps {}", (Object)r.getSourceId());
            return false;
        }
        return this.items.add((Object)r);
    }
}

