/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.NonNullList;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverride;

public class ReversedRecipeOverrides {
    private static final int version = 1;
    private List<ReversedRecipeOverride> overrides;

    public ReversedRecipeOverrides(List<ReversedRecipeOverride> overrides) {
        this.overrides = overrides;
    }

    public List<ReversedRecipeOverride> getOverrides() {
        return this.overrides;
    }

    public static ReversedRecipeOverrides asJson(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        ReversedRecipeOverrides recipeOverrides = new ReversedRecipeOverrides((List<ReversedRecipeOverride>)NonNullList.m_122779_());
        if (jsonObject.size() > 0) {
            if (!jsonObject.has("version")) {
                ModDT.LOGGER.warn("Unable read override due to schema is unknown");
                return recipeOverrides;
            }
            int version = jsonObject.get("version").getAsInt();
            if (version != 1) {
                ModDT.LOGGER.warn("Unable read override due to version mismatch: expected {}, actual {}", (Object)1, (Object)version);
                return recipeOverrides;
            }
            JsonArray jsonArray = jsonObject.getAsJsonArray("overrides");
            for (JsonElement jsonElement : jsonArray) {
                try {
                    recipeOverrides.overrides.add(ReversedRecipeOverride.asJson(jsonElement));
                }
                catch (RuntimeException e) {
                    ModDT.LOGGER.error("Unable read json element: {}", (Object)jsonElement, (Object)e);
                }
            }
        }
        return recipeOverrides;
    }

    public static JsonElement toJson(ReversedRecipeOverrides recipeOverrides) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", (Number)1);
        jsonObject.add("overrides", (JsonElement)recipeOverrides.overrides.stream().map(ReversedRecipeOverride::toJson).collect(JsonArray::new, JsonArray::add, (l, r) -> {}));
        return jsonObject;
    }

    public String toString() {
        return ReversedRecipeOverrides.toJson(this).toString();
    }
}

