/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.registry;

import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.registry.ModTileEntityTypes;

public class ModEvents {
    @SubscribeEvent
    public static void handleXpReceived(PlayerXpEvent.XpChange event) {
        Stream.of(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND).map(arg_0 -> ((Player)event.getPlayer()).m_6844_(arg_0)).filter(s -> s.m_41720_() instanceof ItemVial).forEach(s -> event.setAmount(ItemVial.absorb(s, (ServerPlayer)event.getPlayer(), event.getAmount())));
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getWorld() instanceof Level) {
            Level level = (Level)event.getWorld();
            level.m_141902_(event.getPos(), ModTileEntityTypes.CRYSTAL_TABLE).ifPresent(crystalTable -> {
                int silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)event.getPlayer().m_21205_());
                if (silkLevel > 0) {
                    return;
                }
                crystalTable.spawnOrbs(level);
            });
        }
    }
}

