/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.capability.Slots;
import org.cursegame.minecraft.dt.item.ItemDisk;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.recipe.RecipeService;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeHolder;
import org.cursegame.minecraft.dt.registry.ModSounds;
import org.cursegame.minecraft.dt.registry.ModTriggers;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.tileentity.DTController;
import org.cursegame.minecraft.dt.util.I18N;
import org.cursegame.minecraft.dt.util.Utils;

public abstract class DTContainerBase
implements DTContainer,
DTController {
    private static final float DEFAULT_ENGINE_SPEED_FACTOR = 1.0f;
    private static final float DEFAULT_LOSE_CHANCE = 1.5625f;
    private final DTContainer.Mode mode;
    private int state;
    private int recipeState;
    private boolean dirty;
    private final Utils.Content inventoryI = new Utils.Content(29, slot -> {
        Level world;
        if (slot == 0) {
            this.requestUpdateRecipe();
        }
        if ((world = this.getWorld()) != null && !world.f_46443_) {
            this.dirty = true;
        }
    }){

        public boolean m_7013_(int slot, ItemStack stack) {
            return DTContainerBase.this.getMode().hasISlots() || slot <= 0;
        }
    };
    private final Utils.Content inventoryW = new Utils.Content(10, slot -> {
        Level world = this.getWorld();
        if (world != null && !world.f_46443_) {
            this.requestUpdateRecipe();
            this.dirty = true;
        }
    }){

        public boolean m_7013_(int slot, ItemStack stack) {
            if (!DTContainerBase.this.getMode().hasWSlots()) {
                return false;
            }
            int index = 0;
            if (slot == index++) {
                return Slots.DISK.test(stack);
            }
            if (slot == index++) {
                return Slots.BOOK.test(stack);
            }
            if (slot == index++) {
                return (Slots.VIAL_EMPTY.test(stack) || DTContainerBase.this.mode.hasFuelBlaze() && Slots.VIAL_POTION.test(stack)) && this.m_8020_(4).m_41619_();
            }
            if (slot == index++) {
                if (DTContainerBase.this.mode.hasFuelFlame() && Slots.FUEL_FLAME.test(stack)) {
                    return true;
                }
                return DTContainerBase.this.mode.hasFuelBlaze() && Slots.FUEL_BLAZE.test(stack);
            }
            if (slot == index++) {
                return Slots.BOND.test(stack) && this.m_8020_(2).m_41619_();
            }
            return Slots.DISK.test(stack) || DTContainerBase.this.mode.hasFuelBlaze() && Slots.VIAL_POTION.test(stack);
        }
    };
    private final Utils.Content inventoryO = new Utils.Content(27, slot -> {
        Level world = this.getWorld();
        if (world != null && !world.f_46443_) {
            this.dirty = true;
        }
    }){

        public boolean m_7013_(int slot, ItemStack stack) {
            return DTContainerBase.this.getMode().hasOSlots();
        }
    };
    private final Utils.Content inventoryV = new Utils.Content(9);
    protected int progressTimeTotal;
    protected int progressTime;
    protected int progressTimeDelta;
    private long progressStaleLimit = 1600L;
    private long progressStaleTimestamp;
    private boolean progressStaleCondition;
    private long supplyItemSlotTime;
    private long supplyDiskSlotTime;
    private long supplyVialSlotTime;
    private long playSoundTimestamp;
    private boolean requireRecipeUpdate = false;
    private transient Item previousItem;
    private transient int previousItemCount;
    private final Map<Item, ReversedRecipeHolder> recipes = new LinkedHashMap<Item, ReversedRecipeHolder>();
    private int recipesPlayerId;
    private byte blockState = (byte)-1;
    protected int fuelBurnTime;
    protected int fuelBurnTimeTotal;
    protected long fuelWentDownTimestamp;
    protected long fuelWentDownLimit = 5000L;
    private Int2IntMap fuelCapacities;
    protected int temperature;
    protected final int temperatureMax = 1024;
    protected final int quant = 32;
    protected long temperatureDTimestamp;
    private List<BlockPos> surrounding;
    protected int fuelBlazeWarmTime;
    protected int fuelBlazeWarmTimeTotal = 100;
    protected long fuelBlazeWentDownTimestamp;
    protected long fuelBlazeWentDownLimit = 2500L;
    protected int fuelLoad;
    protected int fuelRest;
    protected boolean intention;
    protected boolean intentionAuto;
    protected boolean intentionPower;

    @Override
    public DTContainer.Mode getMode() {
        return this.mode;
    }

    public DTContainerBase(DTContainer.Mode mode) {
        this.mode = mode;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean setState(int state) {
        boolean result = this.state != state;
        this.state = state;
        return result;
    }

    @Override
    public int getRecipeState() {
        return this.recipeState;
    }

    @Override
    public boolean setRecipeState(int recipeState) {
        boolean result = this.recipeState != recipeState;
        this.recipeState = recipeState;
        return result;
    }

    @Override
    public ContainerData newTrackedData() {
        return new TrackedData();
    }

    @Override
    public abstract Level getWorld();

    @Override
    public abstract BlockPos getPos();

    public void clean(Runnable r) {
        if (this.dirty) {
            this.dirty = false;
            r.run();
        }
    }

    public Utils.Content getInventoryI() {
        return this.inventoryI;
    }

    public Utils.Content getInventoryW() {
        return this.inventoryW;
    }

    public Utils.Content getInventoryO() {
        return this.inventoryO;
    }

    public Utils.Content getInventoryV() {
        return this.inventoryV;
    }

    private void progressCooldown(ItemStack itemStack, ItemStack diskStack) {
        this.progressCooldownStartIfNeeded(itemStack);
        if (this.progressTime > 0) {
            this.playSoundProgress();
            this.progressTime -= Math.max(1, this.progressTimeDelta);
            if (this.progressTime < 0) {
                this.progressTime = 0;
            }
        }
        if (this.progressTimeTotal > 0) {
            this.setStateStarted(true);
            this.setStateProgress(this.getStateProgressMax() * (this.progressTimeTotal - this.progressTime) / this.progressTimeTotal);
        } else {
            this.setStateStarted(false);
            this.setStateProgress(0);
        }
    }

    private void progressCooldownStartIfNeeded(ItemStack itemStack) {
        if (this.progressTimeTotal != 0) {
            return;
        }
        if (itemStack.m_41619_()) {
            return;
        }
        this.progressTimeTotal = this.progressTime = Math.max(1, ItemDisk.getGrindTime(itemStack)) * 10;
    }

    protected void progressReset() {
        if (this.progressTimeTotal != 0) {
            ModDT.LOGGER.debug("Process has been reset");
        }
        this.progressTime = 0;
        this.progressTimeTotal = 0;
        if (this.progressStaleTimestamp != 0L) {
            ModDT.LOGGER.debug("Stale process has been reset");
        }
        this.progressStaleTimestamp = 0L;
        this.progressStaleCondition = false;
        this.setStateStarted(false);
        this.setStateProgress(0);
    }

    private void progressComplete(ItemStack itemStack) {
        boolean success;
        if (this.progressTimeTotal == 0) {
            return;
        }
        if (this.progressTime != 0) {
            return;
        }
        if (this.progressStaleTimestamp > 0L) {
            if (this.progressStaleTimestamp < System.currentTimeMillis() - this.progressStaleLimit) {
                ModDT.LOGGER.debug("Stale process resolution time gone");
                if (Utils.canInsert((Container)this.getInventoryO(), this.getInventoryI().m_8020_(0))) {
                    Utils.insert((Container)this.getInventoryO(), this.getInventoryI().m_7407_(0, this.getInventoryI().m_8020_(0).m_41741_()));
                } else {
                    this.progressReset();
                    this.intentionAuto = false;
                }
            }
            if (this.progressStaleCondition) {
                this.progressStaleCondition = false;
            } else {
                return;
            }
        }
        ModDT.LOGGER.debug("Attempt to process: outcome - {}", (Object)((success = this.deconstruct()) ? "OK" : "FAILURE"));
        if (success) {
            this.progressReset();
            this.playSoundSuccess();
        } else {
            ModDT.LOGGER.debug("Stale process detected");
            this.progressStaleTimestamp = System.currentTimeMillis();
            this.progressStaleCondition = false;
        }
    }

    public boolean deconstruct() {
        boolean success;
        block23: {
            boolean canProceed;
            RecipeService.Result result;
            ItemStack bondStack;
            ItemStack vealStack;
            ItemStack bookStack;
            ItemStack diskStack;
            ItemStack itemStack;
            ServerPlayer player;
            block26: {
                block25: {
                    block24: {
                        success = false;
                        player = this.getPlayerIn();
                        itemStack = this.getItemStack();
                        diskStack = this.getDiskStack();
                        bookStack = this.getBookStack();
                        vealStack = this.getVialStack();
                        bondStack = this.getBondStack();
                        if (itemStack.m_41619_() || diskStack.m_41619_() || (result = RecipeService.getInstance().estimate(new RecipeService.Input(this.recipes, itemStack, diskStack, bookStack, vealStack, bondStack), this.getWorld())).getItemConsumed() == 0 || result.isRecipeAvailable() && result.isRecipeDisabled()) break block23;
                        if (!this.getMode().hasOSlots()) break block24;
                        if (Utils.canInsert((Container)this.getInventoryO(), result.getItems())) break block25;
                        this.getPlayer().ifPresent(x$0 -> I18N.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendTo((Player)x$0, new Object[0]));
                        break block23;
                    }
                    if (player == null) break block23;
                    if (Utils.canInsert((Container)player.m_150109_(), result.getItems(), 0, 36)) break block25;
                    I18N.MESSAGE_NOT_ENOUGH_OUTPUT_SLOTS.sendTo((Player)player, new Object[0]);
                    break block23;
                }
                if (result.isRecipeAvailable() && itemStack.m_41613_() < result.getItemConsumed() && (this.intentionAuto || this.intentionPower)) break block23;
                if (result.getBondConsumed() == 0) break block26;
                float charge = ItemVial.getItemCharge(bondStack);
                if (result.getBondConsumed() > 0 && !(charge > 0.0f)) break block23;
            }
            if (canProceed = ((ItemDisk)diskStack.m_41720_()).canGrind(diskStack, itemStack)) {
                boolean loss = false;
                float chance = this.getLoseChance();
                chance /= (float)(EnchantmentHelper.m_44831_((ItemStack)diskStack).getOrDefault(Enchantments.f_44987_, 0) + 1);
                if (Math.random() * 100.0 < (double)chance) {
                    loss = true;
                }
                if (!loss) {
                    result.getItems().forEach(s -> {
                        ItemStack stack = s.m_41777_();
                        if (this.getMode().hasOSlots()) {
                            Utils.insert((Container)this.getInventoryO(), stack);
                        } else {
                            Utils.insert((Container)player.m_150109_(), stack, 0, 36);
                        }
                    });
                } else {
                    this.playSoundFailure();
                    this.getPlayer().ifPresent(p -> {
                        ModTriggers.DT_3.trigger((ServerPlayer)p);
                        I18N.MESSAGE_LOSS.sendTo((Player)p, new Object[0]);
                    });
                }
            } else {
                this.getPlayer().ifPresent(p -> I18N.MESSAGE_TOOL_LEVEL_TOO_LOW.sendTo((Player)p, itemStack.m_41611_().getString()));
            }
            if (canProceed) {
                if (result.getItemConsumed() > 0) {
                    itemStack.m_41774_(result.getItemConsumed());
                    if (itemStack.m_41619_()) {
                        this.setItemStack(ItemStack.f_41583_);
                    }
                }
                if (result.getBookConsumed() > 0) {
                    bookStack.m_41774_(result.getBookConsumed());
                    if (bookStack.m_41619_()) {
                        this.setBookStack(ItemStack.f_41583_);
                    }
                }
                if (result.getVialConsumed() > 0) {
                    vealStack.m_41774_(result.getVialConsumed());
                    if (vealStack.m_41619_()) {
                        this.setVialStack(ItemStack.f_41583_);
                    }
                }
                if (result.getBondConsumed() != 0) {
                    ItemVial.charge(bondStack, player, (float)result.getBondConsumed() / 100.0f);
                }
                if (result.getXp() > 0) {
                    this.spawnXp(result.getXp());
                }
                if (result.getEntityType() != null) {
                    this.spawnEntity(result.getEntityType());
                }
            }
            if (result.getDiskConsumed() > 0 && diskStack.m_41629_(1, Utils.random, player)) {
                this.setDiskStack(ItemStack.f_41583_);
                this.playSound(SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, 0.8f + Utils.random.nextFloat() * 0.4f);
                this.getPlayer().ifPresent(p -> {
                    ModTriggers.DT_2.trigger((ServerPlayer)p);
                    I18N.MESSAGE_TOOL_BROKEN.sendTo((Player)p, new Object[0]);
                });
            }
            if (canProceed) {
                result.getContent().forEach(this::spawnItem);
            }
            success = canProceed;
        }
        if (success) {
            if (this.getDiskStack().m_41720_() != ItemDisk.DUMMY) {
                this.getPlayer().ifPresent(ModTriggers.DT_1::trigger);
            }
            this.requestUpdateRecipe();
        }
        return success;
    }

    protected abstract void spawnXp(int var1);

    protected void spawnEntity(EntityType<?> entityType) {
        Level world = this.getWorld();
        BlockPos pos = this.getPos();
        Entity entity = entityType.m_20615_(world);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
        entity.m_20334_(0.0, world.f_46441_.nextDouble() * 2.0, 0.0);
        world.m_7967_(entity);
        if (this.fuelBurnTime > 0) {
            entity.m_20254_(8);
        }
    }

    protected abstract void spawnItem(ItemStack var1);

    private void supplyItemSlot() {
        long supplyItemSlotDelay = 500L;
        if (this.supplyItemSlotTime > System.currentTimeMillis() - 500L) {
            return;
        }
        this.supplyItemSlotTime = System.currentTimeMillis();
        ItemStack itemStack = this.getItemStack();
        if (itemStack.m_41619_()) {
            for (int s = 1; s < this.getInventoryI().m_6643_(); ++s) {
                ItemStack slotItemStack = this.getInventoryI().m_8020_(s);
                if (slotItemStack.m_41619_()) continue;
                this.getInventoryI().m_6836_(0, this.getInventoryI().m_8016_(s));
                this.requestUpdateRecipe();
                break;
            }
            return;
        }
        if (this.hasEnergySupply() && itemStack.m_41613_() < itemStack.m_41741_()) {
            for (int s = 1; s < this.getInventoryI().m_6643_(); ++s) {
                ItemStack slotItemStack = this.getInventoryI().m_8020_(s);
                if (slotItemStack.m_41619_() || slotItemStack.m_41720_() != itemStack.m_41720_() || !ItemStack.m_150942_((ItemStack)slotItemStack, (ItemStack)itemStack)) continue;
                itemStack.m_41769_(1);
                slotItemStack.m_41774_(1);
                this.getInventoryI().m_6596_();
                break;
            }
        }
    }

    private void supplyDiskSlot() {
        long supplyDiskSlotDelay = 500L;
        if (this.supplyDiskSlotTime > System.currentTimeMillis() - 500L) {
            return;
        }
        this.supplyDiskSlotTime = System.currentTimeMillis();
        ItemStack diskStack = this.getDiskStack();
        if (diskStack.m_41619_()) {
            for (int s = 5; s < this.getInventoryW().m_6643_(); ++s) {
                ItemStack slotItemStack = this.getInventoryW().m_8020_(s);
                if (!this.getInventoryW().m_7013_(0, slotItemStack)) continue;
                this.getInventoryW().m_6836_(0, this.getInventoryW().m_8016_(s));
                this.requestUpdateRecipe();
                break;
            }
        }
        if (diskStack.m_41619_()) {
            // empty if block
        }
    }

    private void supplyVialSlot() {
        long supplyVialSlotDelay = 500L;
        if (this.supplyVialSlotTime > System.currentTimeMillis() - 500L) {
            return;
        }
        this.supplyVialSlotTime = System.currentTimeMillis();
        ItemStack vialStack = this.getVialStack();
        if (vialStack.m_41619_()) {
            for (int s = 5; s < this.getInventoryW().m_6643_(); ++s) {
                ItemStack slotItemStack = this.getInventoryW().m_8020_(s);
                if (!this.getInventoryW().m_7013_(2, slotItemStack)) continue;
                this.getInventoryW().m_6836_(2, this.getInventoryW().m_8016_(s));
                this.requestUpdateRecipe();
                break;
            }
        }
    }

    protected void checkIntentionAuto() {
        this.setStateStartedAutomatically(this.intentionAuto || this.intentionPower);
    }

    protected void checkIntentionPower() {
        this.intentionPower = this.getWorld().m_46753_(this.getPos());
        this.setStateStartedAutomatically(this.intentionAuto || this.intentionPower);
    }

    protected void playSoundProgress() {
        if (this.playSoundTimestamp > System.currentTimeMillis() - 1000L) {
            return;
        }
        this.playSoundTimestamp = System.currentTimeMillis();
        this.playSound(ModSounds.DT_PROGRESS, SoundSource.BLOCKS, 0.5f, this.getWorld().f_46441_.nextFloat() * 0.4f + 0.6f);
    }

    protected void playSoundSuccess() {
        this.playSound(ModSounds.DT_SUCCESS, SoundSource.BLOCKS, 0.75f, this.getWorld().f_46441_.nextFloat() * 0.4f + 0.6f);
    }

    protected void playSoundFailure() {
        this.playSound(SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, this.getWorld().f_46441_.nextFloat() * 0.4f + 0.6f);
    }

    protected void playSound(SoundEvent soundEvent, SoundSource soundSource, float v, float p) {
        this.getWorld().m_5594_(null, this.getPos(), soundEvent, soundSource, v, p);
    }

    public void tick() {
        ItemStack diskStack;
        this.supplyItemSlot();
        this.supplyDiskSlot();
        this.supplyVialSlot();
        this.updateRecipe();
        this.checkIntentionPower();
        this.checkIntentionAuto();
        this.checkTemperature();
        this.checkEnergy();
        if (this.progressTimeTotal == 0) {
            if (this.intentionAuto || this.intentionPower) {
                this.intention = true;
            }
            if (this.intention) {
                this.intention = false;
            } else {
                return;
            }
        }
        if ((diskStack = this.getDiskStack()).m_41619_()) {
            this.progressReset();
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (itemStack.m_41619_()) {
            this.progressReset();
            return;
        }
        this.supplyFuelSlot();
        this.progressCooldown(itemStack, diskStack);
        this.progressComplete(itemStack);
    }

    @Override
    public void requestUpdateRecipe() {
        this.requireRecipeUpdate = true;
    }

    public void updateRecipe() {
        if (!this.requireRecipeUpdate) {
            return;
        }
        this.requireRecipeUpdate = false;
        RecipeService.Result result = RecipeService.getInstance().estimate(new RecipeService.Input(this.recipes, this.getItemStack(), this.getDiskStack(), this.getBookStack(), this.getVialStack(), this.getBondStack()), this.getWorld());
        Iterator itemIterator = Stream.concat(result.getItems().stream(), result.getContent().stream()).iterator();
        for (int slotId = 0; slotId < this.getInventoryV().m_6643_(); ++slotId) {
            this.getInventoryV().m_6836_(slotId, ItemStack.f_41583_);
            if (!itemIterator.hasNext()) continue;
            ItemStack itemStack = (ItemStack)itemIterator.next();
            this.getInventoryV().m_6836_(slotId, itemStack);
        }
        this.setRecipeItemInput(result.getItemConsumed());
        this.setRecipeDiskInput(result.getDiskConsumed());
        this.setRecipeBookInput(result.getBookConsumed());
        this.setRecipeVialInput(result.getVialConsumed());
        this.setRecipeAvailable(result.isRecipeAvailable());
        this.setRecipeAmbiguous(result.isRecipeAmbiguous());
        this.setRecipeDisabled(result.isRecipeDisabled());
        boolean xpNotEnough = result.getBondConsumed() > 0 && ItemVial.getItemCharge(this.getBondStack()) == 0.0f;
        this.setRecipeRequireXp(xpNotEnough);
        this.setRecipeProduceXp(result.getXp() > 0);
        this.setRecipeXpInflation(result.getVialConsumed() > 0 && !this.getVialStack().m_41619_());
        this.setRecipeXpDeflation(result.getBondConsumed() > 0 && !this.getBondStack().m_41619_() || result.getBondConsumed() < 0 && !this.getBondStack().m_41619_());
        this.setRecipeNestedContent(result.getContent().size() > 0);
        ItemDisk itemDisk = null;
        if (this.getDiskStack().m_41720_() instanceof ItemDisk) {
            itemDisk = (ItemDisk)this.getDiskStack().m_41720_();
        }
        this.progressTimeDelta = 1;
        if (itemDisk != null) {
            float f = itemDisk.getSpeedFactor(this.getDiskStack());
            if (itemDisk.canGrind(this.getDiskStack(), this.getItemStack())) {
                f *= 3.0f;
            }
            this.progressTimeDelta = (int)Math.max((float)this.progressTimeDelta, f *= this.getEngineSpeedFactor());
        }
        ModDT.LOGGER.debug("Recipe updated: ii={}, id={}, ib={}, iv={}, ib={}, xp={}, ra={}, rb={}, rd={}, ss={}, rs={}, cd={}", new Object[]{result.getItemConsumed(), result.getDiskConsumed(), result.getBookConsumed(), result.getVialConsumed(), result.getBondConsumed(), result.getXp(), result.isRecipeAvailable(), result.isRecipeAmbiguous(), result.isRecipeDisabled(), this.state, this.recipeState, this.progressTimeDelta});
        if (this.previousItem != this.getItemStack().m_41720_()) {
            this.progressReset();
        } else if (result.isRecipeAvailable() && this.previousItemCount < result.getItemConsumed() && this.previousItemCount < this.getItemStack().m_41613_()) {
            this.progressStaleCondition = true;
        }
        this.previousItem = this.getItemStack().m_41720_();
        this.previousItemCount = this.getItemStack().m_41613_();
        this.setStartEnabled(true);
        if (result.getItemConsumed() == 0 || result.getDiskConsumed() > 0 && this.getDiskStack().m_41619_() || result.isRecipeDisabled() || xpNotEnough) {
            this.setStartEnabled(false);
        }
    }

    public ReversedRecipeHolder getRecipeHolder(ItemStack itemStack) {
        return this.recipes.get(itemStack.m_41720_());
    }

    public void updateRecipeFromPlayerRecipeBook(ServerPlayer player) {
        this.recipes.clear();
        if (this.recipesPlayerId != player.m_142049_()) {
            this.progressReset();
            this.intentionAuto = false;
            this.intentionPower = false;
        }
        this.recipesPlayerId = player.m_142049_();
        RecipeService.getInstance().updateRecipeFromPlayerRecipeBook(player, this.recipes);
    }

    protected abstract ServerPlayer getPlayerIn();

    protected abstract Optional<ServerPlayer> getPlayer();

    protected void checkTemperature() {
        if (this.getMode().hasFuelFlame()) {
            this.checkFlameTemperature();
        }
    }

    protected float getEngineSpeedFactor() {
        if (this.getMode().hasFuelFlame()) {
            return this.getEnergyFlameSpeedFactor();
        }
        if (this.getMode().hasFuelBlaze()) {
            return this.getEnergyBlazeSpeedFactor();
        }
        return 1.0f;
    }

    protected float getLoseChance() {
        int boostLevel = EnchantmentHelper.m_44831_((ItemStack)this.getDiskStack()).getOrDefault(Enchantments.f_44985_, 0);
        if (boostLevel > 0) {
            return 0.0f;
        }
        if (this.getMode().hasFuelFlame()) {
            return this.getLoseFlameChance();
        }
        if (this.getMode().hasFuelBlaze()) {
            return this.getLoseBlazeChance();
        }
        return 1.5625f;
    }

    protected void checkEnergy() {
        if (this.getMode().hasFuelFlame()) {
            this.checkEnergyFlame();
        }
        if (this.getMode().hasFuelBlaze()) {
            this.checkEnergyBlaze();
        }
    }

    protected boolean hasEnergySupply() {
        if (this.getMode().hasFuelFlame()) {
            return this.hasEnergyFlameSupply();
        }
        if (this.getMode().hasFuelBlaze()) {
            return this.hasEnergyBlazeSupply();
        }
        return false;
    }

    protected void supplyFuelSlot() {
        if (this.getMode().hasFuelFlame()) {
            this.supplyFlameFuelSlot();
        }
        if (this.getMode().hasFuelBlaze()) {
            this.supplyBlazeFuelSlot();
        }
    }

    private void updateBlockStateIfNeeded() {
        byte newState = 0;
        if (this.hasEnergySupply()) {
            newState = 1;
        }
        if (this.blockState != newState) {
            this.blockState = newState;
            Level world = this.getWorld();
            BlockPos pos = this.getPos();
            world.m_7731_(pos, this.updateBlockStateEnabled(world.m_8055_(pos), this.blockState == 1), 3);
            ModDT.LOGGER.debug("Block state updated at {}", (Object)pos);
        }
    }

    protected BlockState updateBlockStateEnabled(BlockState state, boolean enabled) {
        return state;
    }

    private float getEnergyFlameSpeedFactor() {
        if (this.fuelBurnTime > 0) {
            return 2.0f;
        }
        return 1.0f;
    }

    private float getLoseFlameChance() {
        float loseChance = 1.5625f;
        return (loseChance *= this.getEngineSpeedFactor()) + this.getThermalFactor();
    }

    private boolean hasEnergyFlameSupply() {
        return this.fuelBurnTime > 0;
    }

    private void checkEnergyFlame() {
        boolean hasMoreFuel;
        this.updateBlockStateIfNeeded();
        if (this.fuelBurnTime > 0) {
            --this.fuelBurnTime;
        }
        boolean bl = hasMoreFuel = this.getFlameFuelCapacity(this.getFuelStack()) != 0;
        if (this.fuelBurnTime == 0) {
            if (!hasMoreFuel) {
                this.intentionAuto = false;
                this.intentionPower = false;
                this.setStateStartedAutomatically(false);
            }
            if (this.fuelWentDownTimestamp == 0L) {
                if (this.intentionAuto) {
                    this.fuelWentDownTimestamp = System.currentTimeMillis();
                }
            } else if (!this.intentionAuto) {
                this.fuelWentDownTimestamp = 0L;
            }
            if (this.intentionAuto && this.fuelWentDownTimestamp > 0L && this.fuelWentDownTimestamp < System.currentTimeMillis() - this.fuelWentDownLimit) {
                this.intentionAuto = false;
            }
        } else {
            this.fuelWentDownTimestamp = 0L;
        }
        this.setStartAutomationEnabled(this.fuelBurnTime > 0 || hasMoreFuel);
        this.setStateBurn(this.fuelBurnTimeTotal > 0 ? this.getStateBurnMax() * this.fuelBurnTime / this.fuelBurnTimeTotal : 0);
    }

    protected void supplyFlameFuelSlot() {
        if (this.fuelBurnTime == 0) {
            ItemStack fuelStack = this.getFuelStack();
            this.fuelBurnTimeTotal = this.fuelBurnTime = this.getFlameFuelCapacity(fuelStack);
            if (this.fuelBurnTime > 0) {
                ItemStack fuelContainer = null;
                if (!fuelStack.m_41619_()) {
                    if (fuelStack.hasContainerItem()) {
                        fuelContainer = fuelStack.getContainerItem();
                    }
                    fuelStack.m_41774_(1);
                }
                if (fuelContainer != null && !fuelContainer.m_41619_()) {
                    if (Utils.canInsert((Container)this.getInventoryO(), fuelContainer)) {
                        this.getInventoryO().m_19173_(fuelContainer);
                    } else {
                        this.setFuelStack(fuelContainer);
                    }
                }
            }
        }
    }

    private int getFlameFuelCapacity(ItemStack stack) {
        if (this.fuelCapacities == null) {
            this.fuelCapacities = new Int2IntOpenHashMap();
        }
        return this.fuelCapacities.computeIfAbsent(Item.m_41393_((Item)stack.m_41720_()), i -> ForgeHooks.getBurnTime((ItemStack)stack, null));
    }

    protected void checkFlameTemperature() {
        ++this.temperatureDTimestamp;
        if (this.temperatureDTimestamp % 2L == 0L) {
            if (this.fuelBurnTime > 0) {
                ++this.temperature;
            }
            if (this.progressTimeTotal != 0) {
                ++this.temperature;
            }
        }
        if (this.temperatureDTimestamp % 6L == 0L && this.temperature > 0) {
            for (BlockPos p : new BlockPos[]{this.getPos().m_142127_(), this.getPos().m_142126_(), this.getPos().m_142128_(), this.getPos().m_142125_(), this.getPos().m_7494_(), this.getPos().m_7495_()}) {
                BlockState blockState = this.getWorld().m_8055_(p);
                if (blockState.m_60734_() == Blocks.f_50125_ || blockState.m_60734_() == Blocks.f_50127_ || blockState.m_60734_() == Blocks.f_50126_ || blockState.m_60734_() == Blocks.f_50568_ || blockState.m_60734_() == Blocks.f_50449_ || blockState.m_60734_() == Blocks.f_50354_) {
                    this.temperature -= 4;
                }
                if (blockState.m_60734_() == Blocks.f_49990_) {
                    this.temperature -= 3;
                }
                if (blockState.m_60734_() == Blocks.f_50016_) {
                    this.temperature -= 2;
                    continue;
                }
                if (blockState.m_60734_() == Blocks.f_49991_) {
                    ++this.temperature;
                    continue;
                }
                if (blockState.m_60815_()) continue;
                --this.temperature;
            }
        }
        if (this.temperatureDTimestamp % 10L == 0L) {
            ServerPlayer player = this.getPlayer().orElse(null);
            if (player == null) {
                this.progressReset();
                return;
            }
            if (this.progressTimeTotal != 0) {
                if (this.temperature >= 32 && this.checkHeatEmission()) {
                    this.temperature -= 32;
                }
                if (this.temperature > 1023) {
                    ModTriggers.DT_4.trigger(player);
                    BlockPos pos = this.getPos().m_142022_(0.5, 0.5, 0.5);
                    this.getWorld().m_46511_((Entity)player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0f, Explosion.BlockInteraction.BREAK);
                }
            }
        }
        if (this.temperature < 0) {
            this.temperature = 0;
        }
        if (this.temperature > 1023) {
            this.temperature = 1023;
        }
        this.setStateTemperature(this.getStateTemperatureMax() * this.temperature / 1024);
    }

    private boolean checkHeatEmission() {
        float chance = this.getThermalFactor();
        if (chance < this.getWorld().f_46441_.nextFloat()) {
            return false;
        }
        Level world = this.getWorld();
        if (this.surrounding == null) {
            this.surrounding = new ArrayList<BlockPos>();
            BlockPos position = this.getPos();
            for (int z = 0; z < 3; ++z) {
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        this.surrounding.add(position.m_142082_(x - 1, y - 1, z - 1));
                    }
                }
            }
        }
        List candidates = this.surrounding.stream().filter(p -> BaseFireBlock.m_49255_((Level)world, (BlockPos)p, (Direction)Direction.UP)).collect(Collectors.toList());
        Collections.shuffle(candidates);
        ModDT.LOGGER.debug("Check heat emission for {} candidates", (Object)candidates.size());
        BlockPos firePosition = candidates.stream().findFirst().orElse(null);
        if (firePosition != null) {
            world.m_5594_(null, firePosition, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, Utils.random.nextFloat() * 0.4f + 0.8f);
            BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)firePosition);
            world.m_7731_(firePosition, fireState, 11);
            return true;
        }
        return false;
    }

    private float getThermalFactor() {
        float threshold = 0.1f;
        return (float)Math.pow(threshold / (threshold + 1.0f - 1.0f * (float)this.temperature / 1024.0f), 3.0);
    }

    private float getEnergyBlazeSpeedFactor() {
        if (this.fuelRest > 0) {
            return 3.0f;
        }
        return 1.0f;
    }

    protected float getLoseBlazeChance() {
        float loseChance = 1.5625f;
        return loseChance /= 2.0f;
    }

    protected boolean hasEnergyBlazeSupply() {
        return this.fuelBlazeWarmTime > 0;
    }

    protected void checkEnergyBlaze() {
        this.updateBlockStateIfNeeded();
        if (this.progressTimeTotal != 0) {
            if (this.fuelRest > 0) {
                this.fuelBlazeWarmTime = this.fuelBlazeWarmTimeTotal;
            }
        } else if (this.fuelBlazeWarmTime > 0) {
            --this.fuelBlazeWarmTime;
        }
        if (this.fuelBlazeWarmTime == 0) {
            if (this.fuelBlazeWentDownTimestamp == 0L) {
                if (this.intentionAuto) {
                    this.fuelBlazeWentDownTimestamp = System.currentTimeMillis();
                }
            } else if (!this.intentionAuto) {
                this.fuelBlazeWentDownTimestamp = 0L;
            }
            if (this.intentionAuto && this.fuelBlazeWentDownTimestamp > 0L && this.fuelBlazeWentDownTimestamp < System.currentTimeMillis() - this.fuelBlazeWentDownLimit) {
                this.intentionAuto = false;
            }
        } else {
            this.fuelBlazeWentDownTimestamp = 0L;
        }
        this.setStateBurn(this.getStateBurnMax() * this.fuelBlazeWarmTime / this.fuelBlazeWarmTimeTotal);
        boolean hasMoreFuel = false;
        if (this.fuelRest > 0) {
            if (this.progressTimeTotal != 0) {
                --this.fuelRest;
            }
        } else {
            boolean bl = hasMoreFuel = this.getBlazeFuelCapacity(this.getFuelStack()) != 0;
            if (!hasMoreFuel) {
                this.intentionAuto = false;
                this.intentionPower = false;
                this.setStateStartedAutomatically(false);
            }
        }
        boolean hasPowerSupply = this.fuelRest > 0 || hasMoreFuel;
        this.setStartAutomationEnabled(hasPowerSupply);
        if (this.fuelLoad > 0) {
            this.setStateFuel(this.getStateFuelMax() * this.fuelRest / this.fuelLoad);
        } else {
            this.setStateFuel(0);
        }
    }

    private void supplyBlazeFuelSlot() {
        if (this.fuelRest == 0) {
            ItemStack fuelStack = this.getFuelStack();
            this.fuelLoad = this.fuelRest = this.getBlazeFuelCapacity(fuelStack);
            if (this.fuelRest > 0 && !fuelStack.m_41619_()) {
                fuelStack.m_41774_(1);
            }
        }
    }

    private int getBlazeFuelCapacity(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42593_) {
            return 1200;
        }
        return 0;
    }

    @Override
    public void commandStarted() {
        this.intention = true;
        ModDT.LOGGER.debug("Intention - start manually");
    }

    @Override
    public void commandCancelled() {
        this.intention = false;
        this.intentionAuto = false;
        this.progressReset();
        ModDT.LOGGER.debug("Intention - stop");
    }

    @Override
    public void commandStartedPermanently() {
        this.intentionAuto = !this.intentionAuto;
        ModDT.LOGGER.debug("Intention - turn automatic mode {}", (Object)(this.intentionAuto ? "on" : "off"));
    }

    @Override
    public void commandBrowse() {
        ReversedRecipeHolder recipeHolder;
        ItemStack stack = this.getItemStack();
        if (!stack.m_41619_() && (recipeHolder = this.getRecipeHolder(stack)) != null) {
            ServerPlayer player = this.getPlayerIn();
            if (player == null) {
                throw new IllegalStateException();
            }
            RecipeService.getInstance().browseRecipe(player, recipeHolder);
            this.requestUpdateRecipe();
        }
    }

    public class TrackedData
    implements ContainerData {
        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return Utils.getValue(DTContainerBase.this.getState(), 0, 16);
                }
                case 1: {
                    return Utils.getValue(DTContainerBase.this.getState(), 16, 16);
                }
                case 2: {
                    return Utils.getValue(DTContainerBase.this.getRecipeState(), 0, 16);
                }
                case 3: {
                    return Utils.getValue(DTContainerBase.this.getRecipeState(), 16, 16);
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    DTContainerBase.this.setState(Utils.setValue(DTContainerBase.this.getState(), 0, 16, value));
                    break;
                }
                case 1: {
                    DTContainerBase.this.setState(Utils.setValue(DTContainerBase.this.getState(), 16, 16, value));
                    break;
                }
                case 2: {
                    DTContainerBase.this.setRecipeState(Utils.setValue(DTContainerBase.this.getRecipeState(), 0, 16, value));
                    break;
                }
                case 3: {
                    DTContainerBase.this.setRecipeState(Utils.setValue(DTContainerBase.this.getRecipeState(), 16, 16, value));
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }
}

