/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.block.BlockCrystalTable;
import org.cursegame.minecraft.dt.registry.ModTileEntityTypes;
import org.cursegame.minecraft.dt.tileentity.TileEntity;

public class TileEntityCrystalTable
extends TileEntity {
    private float charge;
    private LinkedList<ExperienceOrb> entities = new LinkedList();
    private static final int MAX_ORB_COUNT = 512;
    private final int orbXp = 7;
    private static Random random = new Random(31100L);
    private static double velocity = 0.02;
    private static double acceleration = 0.002;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private double zMin;
    private double zMax;
    private double cX;
    private double cY;
    private double cZ;
    private double lX;
    private double lY;
    private double lZ;

    public TileEntityCrystalTable(BlockPos blockPos, BlockState blockState) {
        super(ModTileEntityTypes.CRYSTAL_TABLE, blockPos, blockState);
    }

    public float getCharge() {
        return this.charge;
    }

    public float setCharge(float charge) {
        this.charge = charge;
        return charge;
    }

    public float addCharge(float charge) {
        this.charge += charge;
        return charge;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadSharedTag(tag);
    }

    private void loadSharedTag(CompoundTag tag) {
        if (tag.m_128441_("Charge")) {
            this.charge = tag.m_128469_("Charge").m_128457_("Value");
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        this.saveSharedTag(tag);
        return tag;
    }

    protected void saveSharedTag(CompoundTag tag) {
        if (this.charge > 0.0f) {
            CompoundTag compoundTag = tag.m_128469_("Charge");
            compoundTag.m_128350_("Value", this.charge);
            tag.m_128365_("Charge", (Tag)compoundTag);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.saveSharedTag(updateTag);
        return updateTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.loadSharedTag(pkt.m_131708_());
    }

    @Override
    public Component getDefaultName() {
        return new TranslatableComponent("corail_dt.block.crystal_table");
    }

    public List<? extends Entity> getCachedEntities() {
        return this.entities;
    }

    public void tickServer() {
        int orbCount;
        if (this.entities.size() < 15 && (orbCount = this.getOrbCount(this.charge)) > this.entities.size()) {
            BlockState blockState;
            ExperienceOrb experienceOrb = new ExperienceOrb(EntityType.f_20570_, this.f_58857_);
            experienceOrb.m_20334_(this.random(0.5), this.random(0.5), this.random(0.5));
            experienceOrb.m_6034_((double)this.f_58858_.m_123341_() + 0.5 + this.random(0.5), (double)this.f_58858_.m_123342_() + 0.5 + this.random(0.5), (double)this.f_58858_.m_123343_() + 0.5 + this.random(0.5));
            experienceOrb.f_20770_ = 7;
            this.entities.add(experienceOrb);
            int ll = this.entities.size();
            if (ll > 15) {
                ll = 15;
            }
            if ((Integer)(blockState = this.m_58900_()).m_61143_((Property)BlockCrystalTable.LEVEL) != ll) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockCrystalTable.LEVEL, (Comparable)Integer.valueOf(ll)), 3);
            }
        }
    }

    public void spawnOrbs(Level level) {
        int sample = (int)this.charge / 512;
        int min = 7;
        if (sample < min) {
            sample = min;
        }
        int top = sample - min;
        double power = Math.log(1.0f + this.charge / 7.0f) / 5.0;
        while (this.charge > 0.0f) {
            ExperienceOrb experienceOrbEntity = new ExperienceOrb(EntityType.f_20570_, level);
            experienceOrbEntity.m_20334_(this.random(power), this.random(power), this.random(power));
            experienceOrbEntity.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
            int xp = min + random.nextInt(top + 1);
            if ((float)xp > this.charge) {
                xp = (int)this.charge;
                this.charge = 0.0f;
            } else {
                this.charge -= (float)xp;
            }
            experienceOrbEntity.f_20770_ = xp;
            level.m_7967_((Entity)experienceOrbEntity);
        }
    }

    private int getOrbCount(float charge) {
        return (int)(charge / 7.0f);
    }

    private double random(double max) {
        return ((double)random.nextFloat() - 0.5) * max;
    }

    protected void readShape(BlockState state) {
        VoxelShape shape = BlockCrystalTable.SHELL;
        AABB aabb = shape.m_83215_().m_82406_(0.05);
        this.xMin = aabb.f_82288_;
        this.yMin = aabb.f_82289_;
        this.zMin = aabb.f_82290_;
        this.xMax = aabb.f_82291_;
        this.yMax = aabb.f_82292_;
        this.zMax = aabb.f_82293_;
        this.lX = this.xMax - this.xMin;
        this.lY = this.yMax - this.yMin;
        this.lZ = this.zMax - this.zMin;
        this.cX = (this.xMin + this.xMax) / 2.0;
        this.cY = (this.yMin + this.yMax) / 2.0;
        this.cZ = (this.zMin + this.zMax) / 2.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        int orbCount;
        if (this.lX == 0.0 || this.lY == 0.0 || this.lZ == 0.0) {
            this.readShape(this.m_58900_());
        }
        if (this.entities.size() < 512 && (orbCount = this.getOrbCount(this.charge)) > this.entities.size()) {
            ExperienceOrb e2 = new ExperienceOrb(EntityType.f_20570_, this.f_58857_);
            e2.f_19854_ = this.cX + this.random(this.lX);
            e2.f_19855_ = this.cY + this.random(this.lY);
            e2.f_19856_ = this.cZ + this.random(this.lZ);
            e2.f_19790_ = this.random(velocity);
            e2.f_19791_ = this.random(velocity);
            e2.f_19792_ = this.random(velocity);
            this.entities.add(e2);
        }
        this.entities.forEach(e -> {
            --e.f_19797_;
            double px = e.f_19854_;
            double py = e.f_19855_;
            double pz = e.f_19856_;
            double vx = e.f_19790_;
            double vy = e.f_19791_;
            double vz = e.f_19792_;
            if ((double)random.nextFloat() < 0.01) {
                if (Math.abs(vx += this.random(acceleration)) > velocity / 1.1) {
                    vx /= 1.1;
                }
                if (Math.abs(vy += this.random(acceleration)) > velocity / 1.1) {
                    vy /= 1.1;
                }
                if (Math.abs(vz += this.random(acceleration)) > velocity / 1.1) {
                    vz /= 1.1;
                }
            }
            px += vx;
            py += vy;
            pz += vz;
            if (px < this.xMin) {
                px = this.xMin;
                vx *= -1.0;
            }
            if (px > this.xMax) {
                px = this.xMax;
                vx *= -1.0;
            }
            if (py < this.yMin) {
                py = this.yMin;
                vy *= -1.0;
            }
            if (py > this.yMax) {
                py = this.yMax;
                vy *= -1.0;
            }
            if (pz < this.zMin) {
                pz = this.zMin;
                vz *= -1.0;
            }
            if (pz > this.zMax) {
                pz = this.zMax;
                vz *= -1.0;
            }
            e.f_19854_ = px;
            e.f_19855_ = py;
            e.f_19856_ = pz;
            e.f_19790_ = vx;
            e.f_19791_ = vy;
            e.f_19792_ = vz;
        });
    }
}

