/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.util.Supplier;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.block.BlockDTBase;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.tileentity.DTContainerBase;
import org.cursegame.minecraft.dt.tileentity.DTContainerProvider;
import org.cursegame.minecraft.dt.tileentity.DTController;
import org.cursegame.minecraft.dt.tileentity.DTControllerProvider;
import org.cursegame.minecraft.dt.util.I18N;

public abstract class TileEntityDTBase
extends BaseContainerBlockEntity
implements DTContainerProvider,
DTControllerProvider {
    private final DTContainerBase dtContainer = this.createContainer();
    private int playerIn;
    private int lastPlayerIn;
    private int xpToSpawn;
    private final LazyOptional<IItemHandlerModifiable> iCapability = LazyOptional.of(() -> new InvWrapper((Container)this.dtContainer.getInventoryI()));
    private final LazyOptional<IItemHandlerModifiable> oCapability = LazyOptional.of(() -> new InvWrapper((Container)this.dtContainer.getInventoryO()));
    private final LazyOptional<IItemHandlerModifiable> wCapability = LazyOptional.of(() -> new InvWrapper((Container)this.dtContainer.getInventoryW()));
    private static final int inventoryVersion = 1;

    public static void pushItemsTick(Level level, BlockPos blockPos, BlockState blockState, TileEntityDTBase tileEntity) {
        tileEntity.tick();
    }

    protected TileEntityDTBase(BlockEntityType<?> typeIn, BlockPos blockPos, BlockState blockState) {
        super(typeIn, blockPos, blockState);
    }

    protected abstract DTContainerBase createContainer();

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new ContainerDT(id, playerInventory, this.dtContainer);
    }

    private ServerPlayer getPlayer(int playerId) {
        if (playerId == 0) {
            return null;
        }
        for (Player player : this.f_58857_.m_6907_()) {
            if (player.m_142049_() != playerId) continue;
            return (ServerPlayer)player;
        }
        return null;
    }

    private Optional<ServerPlayer> getPlayerIfExist(Integer ... playerIds) {
        return Stream.of(playerIds).map(this::getPlayer).filter(Objects::nonNull).findFirst();
    }

    public void m_5856_(Player player) {
    }

    public boolean m_6542_(Player player) {
        if (this.f_58859_) {
            return false;
        }
        if (this.playerIn != 0 && this.playerIn != player.m_142049_()) {
            I18N.MESSAGE_ENGAGED.sendTo(player, this.m_5446_(), this.getPlayerIfExist(this.playerIn).map(p -> p.m_5446_().getString()).orElse("[hidden]]"));
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        if (player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0) {
            I18N.MESSAGE_TOO_FAR.sendTo(player, new Object[0]);
            return false;
        }
        return true;
    }

    public void m_5785_(Player player) {
        int entityId = player.m_142049_();
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = this::getId;
        supplierArray[1] = () -> ((Player)player).m_142049_();
        ModDT.LOGGER.debug("Instance {} disarmed by {}", supplierArray);
        if (this.playerIn == entityId) {
            this.playerIn = 0;
        }
    }

    @Override
    public DTContainerBase getContainer(Player player) {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.f_58857_.f_46443_) {
            return this.dtContainer;
        }
        if (this.playerIn != 0 && this.playerIn != player.m_142049_() && !player.m_7500_()) {
            I18N.MESSAGE_ENGAGED.sendTo(player, this.m_5446_(), this.getPlayerIfExist(this.playerIn).map(p -> p.m_5446_().getString()).orElse("[hidden]]"));
            return null;
        }
        if (this.playerIn != player.m_142049_()) {
            this.dtContainer.updateRecipeFromPlayerRecipeBook((ServerPlayer)player);
            this.dtContainer.requestUpdateRecipe();
            this.m_6596_();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = this::getId;
            supplierArray[1] = () -> ((Player)player).m_142049_();
            ModDT.LOGGER.debug("Instance {} engaged by {}", supplierArray);
        }
        this.lastPlayerIn = this.playerIn = player.m_142049_();
        return this.dtContainer;
    }

    public void m_7651_() {
        super.m_7651_();
        ModDT.LOGGER.debug("Instance {} destroyed", new Supplier[]{this::getId});
    }

    @Override
    public DTController getController(ServerPlayer player) {
        if (this.playerIn != player.m_142049_()) {
            return null;
        }
        return this.dtContainer;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return this.oCapability.cast();
            }
            Direction front = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockDTBase.FACING);
            if (side == Direction.UP || side == front.m_122427_()) {
                return this.iCapability.cast();
            }
            if (side == front.m_122424_() || side == front.m_122428_()) {
                return this.wCapability.cast();
            }
        }
        return LazyOptional.empty();
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128405_("version", 1);
        compound.m_128365_("input", (Tag)this.dtContainer.getInventoryI().save());
        if (this.dtContainer.getMode().hasOSlots()) {
            compound.m_128365_("output", (Tag)this.dtContainer.getInventoryO().save());
        }
        if (this.dtContainer.getMode().hasWSlots()) {
            compound.m_128365_("working", (Tag)this.dtContainer.getInventoryW().save());
        }
        if (this.dtContainer.getMode().hasFuelFlame()) {
            compound.m_128405_("temperature", this.dtContainer.temperature);
            compound.m_128405_("burnTime", this.dtContainer.fuelBurnTime);
            compound.m_128405_("burnTimeTotal", this.dtContainer.fuelBurnTimeTotal);
        }
        if (this.dtContainer.getMode().hasFuelBlaze()) {
            compound.m_128405_("fuelLoad", this.dtContainer.fuelLoad);
            compound.m_128405_("fuelRest", this.dtContainer.fuelRest);
        }
        compound.m_128405_("xp", this.xpToSpawn);
        return compound;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        int version = nbt.m_128451_("version");
        this.dtContainer.getInventoryI().load(nbt.m_128437_("input", 10));
        if (this.dtContainer.getMode().hasOSlots()) {
            this.dtContainer.getInventoryO().load(nbt.m_128437_("output", 10));
        }
        if (this.dtContainer.getMode().hasWSlots()) {
            this.dtContainer.getInventoryW().load(nbt.m_128437_("working", 10));
        }
        if (this.dtContainer.getMode().hasFuelFlame()) {
            this.dtContainer.temperature = nbt.m_128451_("temperature");
            this.dtContainer.fuelBurnTime = nbt.m_128451_("burnTime");
            this.dtContainer.fuelBurnTimeTotal = nbt.m_128451_("burnTimeTotal");
        }
        if (this.dtContainer.getMode().hasFuelBlaze()) {
            this.dtContainer.fuelLoad = nbt.m_128451_("fuelLoad");
            this.dtContainer.fuelRest = nbt.m_128451_("fuelRest");
        }
        this.xpToSpawn = nbt.m_128451_("xp");
    }

    public void dropContents(Level level, BlockPos blockPos) {
        Stream.of(this.dtContainer.getInventoryI(), this.dtContainer.getInventoryW(), this.dtContainer.getInventoryO()).flatMap(c -> c.m_19195_().stream()).forEach(this.dtContainer::spawnItem);
    }

    public void tick() {
        if (this.f_58859_) {
            return;
        }
        this.spawnXp();
        this.dtContainer.tick();
    }

    private void spawnXp() {
        int mendingLevel;
        ItemStack itemStack;
        if (this.f_58857_.m_46467_() % 2L != 0L) {
            return;
        }
        if (this.xpToSpawn > 0 && (itemStack = this.dtContainer.getDiskStack()).m_41768_() && (mendingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)this.dtContainer.getDiskStack())) > 0) {
            int repairs = Math.min((int)((float)Math.min(this.xpToSpawn, 7) * itemStack.getXpRepairRatio()), itemStack.m_41773_());
            itemStack.m_41721_(itemStack.m_41773_() - repairs);
            this.xpToSpawn -= (int)((float)repairs / itemStack.getXpRepairRatio());
        }
        while (this.f_58857_.f_46441_.nextDouble() < 0.66 && this.xpToSpawn != 0) {
            int xp = Math.min(this.xpToSpawn, (1 + this.f_58857_.f_46441_.nextInt(10)) * 7);
            ExperienceOrb experienceOrb = new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, xp);
            experienceOrb.m_20334_(this.f_58857_.f_46441_.nextDouble() * 0.2 - 0.1, this.f_58857_.f_46441_.nextDouble() * 3.0, this.f_58857_.f_46441_.nextDouble() * 0.2 - 0.1);
            this.f_58857_.m_7967_((Entity)experienceOrb);
            this.xpToSpawn -= xp;
            if (!((double)this.xpToSpawn < 1.0)) continue;
            this.xpToSpawn = 0;
        }
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return true;
    }

    private FlatContainer withFlatContainer(int index) {
        if (index < this.dtContainer.getInventoryW().m_6643_()) {
            return new FlatContainer((Container)this.dtContainer.getInventoryW(), index);
        }
        if ((index -= this.dtContainer.getInventoryW().m_6643_()) < this.dtContainer.getInventoryI().m_6643_()) {
            return new FlatContainer((Container)this.dtContainer.getInventoryI(), index);
        }
        if ((index -= this.dtContainer.getInventoryI().m_6643_()) < this.dtContainer.getInventoryO().m_6643_()) {
            return new FlatContainer((Container)this.dtContainer.getInventoryO(), index);
        }
        throw new IllegalArgumentException();
    }

    public ItemStack m_8020_(int slotIndex) {
        return this.withFlatContainer(slotIndex).call(Container::m_8020_);
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return this.withFlatContainer(slotIndex).call((c, s) -> c.m_7013_(s.intValue(), itemStack));
    }

    public ItemStack m_7407_(int slotIndex, int count) {
        return this.withFlatContainer(slotIndex).call((c, s) -> c.m_7407_(s.intValue(), count));
    }

    public ItemStack m_8016_(int slotIndex) {
        return this.withFlatContainer(slotIndex).call(Container::m_8016_);
    }

    public void m_6836_(int slotIndex, ItemStack itemStack) {
        this.withFlatContainer(slotIndex).run((c, s) -> c.m_6836_(s.intValue(), itemStack));
    }

    public void m_6211_() {
        ModDT.LOGGER.error((Object)new UnsupportedOperationException());
    }

    private record FlatContainer(Container container, Integer slotIndex) {
        <T> T call(BiFunction<Container, Integer, T> function) {
            return function.apply(this.container, this.slotIndex);
        }

        void run(BiConsumer<Container, Integer> consumer) {
            consumer.accept(this.container, this.slotIndex);
        }
    }

    protected class BaseDTContainer
    extends DTContainerBase {
        protected BaseDTContainer(DTContainer.Mode mode) {
            super(mode);
        }

        @Override
        public Level getWorld() {
            return TileEntityDTBase.this.f_58857_;
        }

        @Override
        public BlockPos getPos() {
            return TileEntityDTBase.this.f_58858_;
        }

        @Override
        protected void spawnXp(int xp) {
            TileEntityDTBase.this.xpToSpawn += xp / 100;
        }

        @Override
        protected void spawnItem(ItemStack itemStack) {
            BlockPos pos = TileEntityDTBase.this.f_58858_.m_7494_();
            ItemEntity itemEntity = new ItemEntity(TileEntityDTBase.this.f_58857_, (double)pos.m_123341_() + 0.2 + ((TileEntityDTBase)TileEntityDTBase.this).f_58857_.f_46441_.nextDouble() * 0.6, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.2 + ((TileEntityDTBase)TileEntityDTBase.this).f_58857_.f_46441_.nextDouble() * 0.6, itemStack);
            itemEntity.m_20256_(Vec3.f_82478_);
            TileEntityDTBase.this.f_58857_.m_7967_((Entity)itemEntity);
        }

        @Override
        public void disarm(Player player) {
            TileEntityDTBase.this.m_5785_(player);
        }

        @Override
        public boolean canInteract(Player player) {
            return TileEntityDTBase.this.m_6542_(player);
        }

        @Override
        protected ServerPlayer getPlayerIn() {
            return TileEntityDTBase.this.getPlayer(TileEntityDTBase.this.playerIn);
        }

        @Override
        protected Optional<ServerPlayer> getPlayer() {
            return TileEntityDTBase.this.getPlayerIfExist(TileEntityDTBase.this.playerIn, TileEntityDTBase.this.lastPlayerIn);
        }
    }
}

