/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChestBlaze;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDTWorkChestBlazeRenderer
implements BlockEntityRenderer<TileEntityDTWorkChestBlaze> {
    private static final RenderType END_SPACE = RenderType.m_173239_();
    private static final Random RANDOM = new Random(31100L);

    public TileEntityDTWorkChestBlazeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityDTWorkChestBlaze tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        this.renderCube(tileEntityIn, 0.99f, 0.15f, matrix4f, bufferIn.m_6299_(END_SPACE));
    }

    private void renderCube(TileEntityDTWorkChestBlaze tileEntityIn, float offset, float brightness, Matrix4f matrixIn, VertexConsumer builder) {
        float r = (RANDOM.nextFloat() * 0.5f + 0.1f) * brightness;
        float g = (RANDOM.nextFloat() * 0.5f + 0.4f) * brightness;
        float b = (RANDOM.nextFloat() * 0.5f + 0.5f) * brightness;
        this.renderFace(tileEntityIn, matrixIn, builder, 0.0f, 1.0f, offset, offset, 1.0f, 1.0f, 0.0f, 0.0f, r, g, b);
    }

    private void renderFace(TileEntityDTWorkChestBlaze tileEntityIn, Matrix4f matrix, VertexConsumer builder, float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float r, float g, float b) {
        builder.m_85982_(matrix, f0, f2, f4).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_85982_(matrix, f1, f2, f5).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_85982_(matrix, f1, f3, f6).m_85950_(r, g, b, 1.0f).m_5752_();
        builder.m_85982_(matrix, f0, f3, f7).m_85950_(r, g, b, 1.0f).m_5752_();
    }
}

