/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.util;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Utils {
    public static final Random random = new Random();

    public static boolean canInsert(Container container, ItemStack stack) {
        int count = stack.m_41613_();
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (container.m_7013_(i, stack) && (itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack))) {
                count -= itemStack.m_41741_() - itemStack.m_41613_();
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean canInsert(Container container, List<ItemStack> stacks) {
        return Utils.canInsert(container, stacks, 0, container.m_6643_());
    }

    public static boolean canInsert(Container container, List<ItemStack> stacks, int b, int e) {
        if (b > e) {
            throw new IllegalArgumentException();
        }
        int[] sizes = new int[stacks.size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = stacks.get(i).m_41613_();
        }
        int[] limit = new int[e - b];
        int[] spans = new int[e - b];
        for (int i = b; i < e; ++i) {
            ItemStack itemStack = container.m_8020_(i);
            limit[i] = itemStack.m_41741_() - itemStack.m_41613_();
            spans[i] = -1;
        }
        for (int s = 0; s < sizes.length; ++s) {
            ItemStack stack = stacks.get(s);
            for (int i = b; i < e && sizes[s] != 0; ++i) {
                ItemStack itemStack;
                if (!container.m_7013_(i, stack)) continue;
                ItemStack itemStack2 = itemStack = spans[i] < 0 ? container.m_8020_(i) : stacks.get(spans[i]);
                if (!itemStack.m_41619_() && !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
                if (sizes[s] < limit[i]) {
                    int n = i;
                    limit[n] = limit[n] - sizes[s];
                    sizes[s] = 0;
                } else {
                    int n = s;
                    sizes[n] = sizes[n] - limit[i];
                    limit[i] = 0;
                }
                spans[i] = s;
            }
        }
        for (int size : sizes) {
            if (size <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean insert(Container inventory, ItemStack stack) {
        return Utils.insert(inventory, stack, 0, inventory.m_6643_());
    }

    public static boolean insert(Container inventory, ItemStack stack, int s, int e) {
        ItemStack inventoryStack;
        int i;
        if (!stack.m_41619_()) {
            for (i = s; i < e; ++i) {
                inventoryStack = inventory.m_8020_(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)inventoryStack)) continue;
                int count = inventoryStack.m_41613_() + stack.m_41613_();
                if (count > stack.m_41741_()) {
                    if (inventoryStack.m_41613_() >= stack.m_41741_()) continue;
                    stack.m_41774_(stack.m_41741_() - inventoryStack.m_41613_());
                    inventoryStack.m_41764_(stack.m_41741_());
                    continue;
                }
                stack.m_41764_(0);
                inventoryStack.m_41764_(count);
                break;
            }
        }
        if (!stack.m_41619_()) {
            for (i = s; i < e; ++i) {
                inventoryStack = inventory.m_8020_(i);
                if (!inventoryStack.m_41619_() || !inventory.m_7013_(i, stack)) continue;
                inventory.m_6836_(i, stack.m_41620_(stack.m_41613_()));
                break;
            }
        }
        return stack.m_41619_();
    }

    private Utils() {
    }

    public static int setValue(int target, int pos, int len, int value) {
        int mask = (1 << len) - 1;
        return target & ~(mask << pos) | (value & mask) << pos;
    }

    public static int getValue(int target, int pos, int len) {
        int mask = (1 << len) - 1;
        return target >> pos & mask;
    }

    public static boolean getValue(int target, int pos) {
        return Utils.getValue(target, pos, 1) == 1;
    }

    public static int setValue(int target, int pos, boolean b) {
        return Utils.setValue(target, pos, 1, b ? 1 : 0);
    }

    @Nonnull
    public static <T> T nonNull() {
        return null;
    }

    public static ResourceLocation modResource(String path) {
        return new ResourceLocation("corail_dt", path);
    }

    public static Item modItem(String path) {
        return (Item)ForgeRegistries.ITEMS.getValue(Utils.modResource(path));
    }

    public static NamedTag<Item> modTag(String path) {
        return new NamedTag<Item>(Utils.modResource(path));
    }

    public static String toString(ItemStack itemStack) {
        ResourceLocation rl = itemStack.m_41720_().getRegistryName();
        return rl.toString() + ":" + itemStack.m_41613_();
    }

    public static ItemStack asString(String string) {
        Item item;
        String[] parts = string.split(":");
        if ((parts.length == 2 || parts.length == 3) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
            return new ItemStack((ItemLike)item, parts.length == 3 ? Integer.parseInt(parts[2]) : 1);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack merge(ItemStack t, ItemStack o) {
        if (t.m_41720_() != o.m_41720_()) {
            throw new IllegalArgumentException();
        }
        return new ItemStack((ItemLike)t.m_41720_(), t.m_41613_() + o.m_41613_());
    }

    public static class NamedTag<T>
    implements Tag.Named<T> {
        private final ResourceLocation resourceLocation;

        public NamedTag(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public boolean m_8110_(T element) {
            throw new UnsupportedOperationException();
        }

        public List<T> m_6497_() {
            throw new UnsupportedOperationException();
        }

        public ResourceLocation m_6979_() {
            return this.resourceLocation;
        }
    }

    public static class Content
    extends SimpleContainer {
        public Content(int size) {
            this(size, null);
        }

        public Content(int size, Consumer<Integer> update) {
            super(size);
            if (update != null) {
                this.m_19164_(i -> update.accept(0));
            }
        }

        public void load(ListTag nbt) {
            int i;
            NonNullList list = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            for (i = 0; i < nbt.size(); ++i) {
                CompoundTag itemStackTag = nbt.m_128728_(i);
                int j = itemStackTag.m_128445_("Slot") & 0xFF;
                if (j >= list.size()) continue;
                list.set(j, (Object)ItemStack.m_41712_((CompoundTag)itemStackTag));
            }
            for (i = 0; i < list.size(); ++i) {
                this.m_6836_(i, (ItemStack)list.get(i));
            }
        }

        public ListTag save() {
            ListTag nbt = new ListTag();
            for (int index = 0; index < this.m_6643_(); ++index) {
                ItemStack itemStack = this.m_8020_(index);
                if (itemStack.m_41619_()) continue;
                CompoundTag itemStackTag = itemStack.m_41739_(new CompoundTag());
                itemStackTag.m_128344_("Slot", (byte)index);
                nbt.add((Object)itemStackTag);
            }
            return nbt;
        }
    }
}

