/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.combine.CombineUpgrade;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBlockGrave
extends BlockItem {
    public static final int MAX_MODEL_TEXTURE = 1;

    public ItemBlockGrave(Block grave) {
        super(grave, new Item.Properties().m_41491_(ModTabs.mainTab).m_41487_(1).m_41486_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(StyleType.TOOLTIP_COMBINE, new Object[0]));
        tooltip.add((Component)Component.m_237115_((String)"tombstone.block.decorative_grave.desc").m_6270_(StyleType.TOOLTIP_DESC));
        String engravedName = EngravableHelper.getEngravedName(stack);
        if (!engravedName.isEmpty()) {
            tooltip.add((Component)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{Component.m_237113_((String)("\"" + engravedName + "\"")).m_6270_(StyleType.TOOLTIP_ITEM)}));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    public Component m_7626_(ItemStack stack) {
        Component displayName = super.m_7626_(stack);
        return (EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName) : displayName.m_6879_()).m_130948_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean m_142305_(ItemStack decorativeGrave, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.m_150651_(player) && added.m_150930_((Item)ModItems.grave_plate) && decorativeGrave.m_150930_((Item)this)) {
            String engravedName = EngravableHelper.getEngravedName(added);
            if (engravedName.isEmpty() || EngravableHelper.isEngraved(decorativeGrave)) {
                ItemStack plateStack = new ItemStack((ItemLike)ModItems.grave_plate);
                ItemStack graveStack = new ItemStack((ItemLike)decorativeGrave.m_41720_());
                MutableComponent displayName = Component.m_237113_((String)"[").m_7220_((Component)(engravedName.isEmpty() ? Component.m_237115_((String)plateStack.m_41778_()) : graveStack.m_41611_())).m_130946_("]").m_6270_(StyleType.TOOLTIP_ITEM);
                ModTombstone.PROXY.addToast(EngravableHelper.setEngravedName(plateStack, "named"), graveStack, (Component)(engravedName.isEmpty() ? LangKey.MESSAGE_NOT_ENGRAVED.getText(displayName) : LangKey.MESSAGE_ALREADY_ENGRAVED.getText(displayName)));
            } else if (!player.f_19853_.m_5776_() || player.m_7500_()) {
                EngravableHelper.setEngravedName(decorativeGrave, engravedName);
                added.m_41774_(1);
                if (!player.m_7500_()) {
                    ModTriggers.COMBINE_IN_INVENTORY.trigger((ServerPlayer)player);
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new TooltipCombineUpgrade(new CombineUpgrade(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "named"), !EngravableHelper.isEngraved(stack))));
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60796_((BlockGetter)context.m_43725_(), context.m_8083_().m_7495_()) && super.m_7429_(context, state);
    }

    public static ItemStack setModelTexture(ItemStack stack, int modelTexture) {
        if (stack.m_41720_() instanceof ItemBlockGrave) {
            NBTStackHelper.setInteger(stack, "model_texture", Mth.m_14045_((int)modelTexture, (int)0, (int)1));
        }
        return stack;
    }

    public static int getModelTexture(ItemStack stack) {
        return stack.m_41720_() instanceof ItemBlockGrave ? Mth.m_14045_((int)NBTStackHelper.getInteger(stack, "model_texture"), (int)0, (int)1) : 0;
    }

    public static ItemStack createDecorativeStack(GraveModel graveModel, int textureId) {
        return ItemBlockGrave.createDecorativeStack(graveModel, textureId, "");
    }

    public static ItemStack createDecorativeStack(GraveModel model, int textureId, String engravedName) {
        ItemStack stack = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)model)), textureId);
        return engravedName.isEmpty() ? stack : EngravableHelper.setEngravedName(stack, engravedName);
    }
}

