/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;

public class StayNearHome<T extends PathfinderMob>
extends RandomStrollGoal {
    private static final int INTERVAL_WALK_RANDOM = 120;
    private static final int INTERVAL_WALK_BACK = 10;
    private final T pathfinderMob;
    private final Function<T, GlobalPos> homeGetter;
    private final Consumer<T> homeReset;

    public StayNearHome(T pathfinderMob, Function<T, GlobalPos> homeGetter, Consumer<T> homeReset, double speedModifier) {
        super(pathfinderMob, speedModifier, 120, false);
        this.pathfinderMob = pathfinderMob;
        this.homeGetter = homeGetter;
        this.homeReset = homeReset;
    }

    public boolean m_8036_() {
        if (!EntityHelper.targetAnEnemy(this.pathfinderMob)) {
            GlobalPos home = this.homeGetter.apply(this.pathfinderMob);
            if (((PathfinderMob)this.pathfinderMob).f_19853_.m_46472_().equals((Object)home.m_122640_()) && Math.abs(this.pathfinderMob.m_20186_() - (double)home.m_122646_().m_123342_()) < 20.0) {
                if (home.m_122646_().m_203195_((Position)this.pathfinderMob.m_20182_(), 15.0)) {
                    return this.pathfinderMob.m_217043_().m_188503_(120) == 0 && this.walk(false);
                }
                return this.pathfinderMob.m_217043_().m_188503_(10) == 0 && this.walk(true);
            }
            if (this.pathfinderMob.m_20096_() && this.pathfinderMob.m_217043_().m_188503_(10) == 0) {
                Optional.ofNullable(Helper.getServer()).map(s -> s.m_129880_(home.m_122640_())).ifPresent(level -> CallbackHandler.addFastCallback(() -> {
                    BlockPos startPos = this.pathfinderMob.m_20183_();
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)startPos.m_123341_(), (double)startPos.m_123342_() + 0.5, (double)startPos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)home.m_122646_().m_123341_(), (double)home.m_122646_().m_123342_() + 0.5, (double)home.m_122646_().m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                    Location spawnPos = new SpawnHelper((ServerLevel)level, home.m_122646_()).findSpawnPlace();
                    if (!spawnPos.isOrigin()) {
                        Helper.teleport(this.pathfinderMob, spawnPos, level);
                    } else {
                        this.homeReset.accept(this.pathfinderMob);
                    }
                }));
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return !EntityHelper.targetAnEnemy(this.pathfinderMob) && !this.pathfinderMob.m_21573_().m_26571_();
    }

    protected boolean walk(boolean isBack) {
        Vec3 vec3;
        Vec3 vec32 = vec3 = isBack ? DefaultRandomPos.m_148412_(this.pathfinderMob, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)this.homeGetter.apply(this.pathfinderMob).m_122646_()), (double)1.5707963705062866) : DefaultRandomPos.m_148403_(this.pathfinderMob, (int)10, (int)7);
        if (vec3 != null) {
            this.f_25726_ = vec3.f_82479_;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_;
            this.f_25731_ = isBack;
            return true;
        }
        return false;
    }
}

