/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ProtectedGraveGuardianImpl;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.entity.Cloud;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PlayerStatusHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.PrayerMessage;
import ovh.corail.tombstone.network.SyncProtectionMessage;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDamages;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.spawner.CustomPhantomSpawner;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;
    private static final Field CAPABILITIES = ObfuscationReflectionHelper.findField(CapabilityProvider.class, (String)"capabilities");
    private static final String IS_DRINKING_POTION = "is_drinking_potion";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarting(ServerStartingEvent event) {
        TimeHelper.init();
        TameableType.init(event.getServer());
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityFirstAid.instance);
        }
        BackupService.get();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
        SupportStructures.clear();
        BackupService.stop();
    }

    @SubscribeEvent
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity())) {
            MinecraftServer server = Objects.requireNonNull(event.getEntity().m_20194_());
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ModTriggers.PASS_APRIL_FOOL.trigger(player);
            ModTriggers.CHRISTMAS.trigger(player);
            if (TimeHelper.isDateAroundHalloween()) {
                ModTriggers.HALLOWEEN.trigger(player);
            }
            EntityHelper.syncTBCapability(player, true);
            PacketHandler.sendToPlayer(new UpdateClientMessage(server.m_129783_().m_220360_(), server.m_6982_() ? server.m_6396_() : 0, TimeHelper.getSpecialEvent()), player);
            PacketHandler.sendToPlayer(CooldownHandler.INSTANCE.getCooldownPacket(player), player);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        Helper.initCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUseCommand(CommandEvent event) {
        if (event.isCanceled() && TombstoneCommand.is((ParseResults<CommandSourceStack>)event.getParseResults())) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server != null && event.phase == TickEvent.Phase.END) {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()).intValue()) {
                LAST_BACKUP = systemTime;
                CommandTBRecovery.saveAllPlayers(server, success -> ModTombstone.LOGGER.debug((success ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).asLog()));
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
            PlayerStatusHandler.clear();
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_204029_(FluidTags.f_13131_) && EffectHelper.isPotionActive((LivingEntity)event.getEntity(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.m_44934_((LivingEntity)event.getEntity()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            BlockState state = event.getLevel().m_8055_(blockPos);
            return ModBlocks.isAnyGrave(state.m_60734_()) || state.m_204336_(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeBreakBlock.get()).booleanValue() && EntityHelper.isValidServerPlayer(event.getPlayer()) && EffectHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            ServerLevel world = (ServerLevel)event.getLevel();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean valid = false;
            for (CustomSpawner spawner : world.f_8558_) {
                if (spawner instanceof PhantomSpawner && !(spawner instanceof CustomPhantomSpawner)) {
                    builder.add((Object)new CustomPhantomSpawner());
                    valid = true;
                    continue;
                }
                if (spawner instanceof VillageSiege && !(spawner instanceof CustomVillageSiege)) {
                    builder.add((Object)new CustomVillageSiege());
                    valid = true;
                    continue;
                }
                builder.add((Object)spawner);
            }
            if (valid) {
                world.f_8558_ = builder.build();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        boolean isPlayer;
        EntityDamageSource damageSource;
        DamageSource damageSource2;
        ServerPlayer player;
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && event.getEntity().m_6084_() && (player = (ServerPlayer)event.getEntity()).m_6117_() && player.m_21211_().m_41720_() instanceof ItemGraveMagic && EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.concentration) == 0) {
            EntityHelper.setGlobalItemCooldown((Player)player, player.m_21211_(), 40);
            player.m_5810_();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((Player)player, new Object[0]);
        }
        if (event.getEntity() == null || event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        MobEffectInstance boneShieldEffect = event.getEntity().m_21124_(ModEffects.bone_shield);
        if (boneShieldEffect != null && !event.getSource().m_19360_() && !event.getSource().m_19372_() && (damageSource2 = event.getSource()) instanceof EntityDamageSource && !((damageSource = (EntityDamageSource)damageSource2) instanceof IndirectEntityDamageSource)) {
            event.setCanceled(true);
            if (!damageSource.m_19403_()) {
                Optional.ofNullable(event.getSource().m_7639_()).filter(Entity::m_6084_).ifPresent(s -> {
                    float reflectedDamages = event.getAmount() * ((float)Mth.m_14045_((int)boneShieldEffect.f_19504_, (int)1, (int)10) / 10.0f);
                    if (reflectedDamages >= 1.0f) {
                        ModSounds.playSoundAllAround(SoundEvents.f_12511_, SoundSource.NEUTRAL, s.f_19853_, s.m_20183_(), 0.5f, (Helper.RANDOM.nextFloat() - Helper.RANDOM.nextFloat()) * 0.2f + 1.0f);
                        s.m_6469_(DamageSource.m_19335_((Entity)event.getEntity()), reflectedDamages);
                    }
                });
            }
            return;
        }
        if (EffectHelper.isUnstableIntangibilityActive(event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (DamageType.LIGHTNING.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntity(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (DamageType.COLD.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntity(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (isPlayer = EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
                if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue()) {
                    event.getEntity().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                        int knowledgeLevel = cap.getTotalPerkPoints();
                        if (knowledgeLevel > 0) {
                            event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                        }
                    });
                }
            } else {
                Entity entity;
                int alignmentLevel = event.getEntity().getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                if (alignmentLevel != 0 && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
                    boolean valid;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    boolean bl = EntityHelper.isUndead(livingEntity) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                    if (valid) {
                        float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                        if (amount < 0.5f) {
                            event.setCanceled(true);
                        } else {
                            event.setAmount(amount);
                        }
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape) && Helper.isValidPos(event.getEntity().f_19853_, event.getEntity().m_20183_())) {
                event.setCanceled(true);
                return;
            }
        }
        if (EntityHelper.isValidPlayer(event.getSource().m_7639_())) {
            Player player2 = (Player)event.getSource().m_7639_();
            if (!event.getEntity().equals((Object)player2)) {
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.ghostly_shape)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)player2);
                }
                if (EffectHelper.isPotionActive((LivingEntity)player2, ModEffects.diversion)) {
                    EffectHelper.clearEffect((LivingEntity)player2, ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntity() != null && event.getEntity().m_6084_() && event.getEntity().m_21223_() <= event.getAmount() && !event.getEntity().f_19853_.m_5776_()) {
            Location location = event.getEntity().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntity(), false);
                    return new Location(cap.getSafeLocation(event.getEntity()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                ServerLevel level;
                event.getEntity().m_21153_(event.getEntity().m_21233_());
                event.getEntity().f_19789_ = 0.0f;
                EffectHelper.clearBadEffects(event.getEntity());
                EffectHelper.addEffect(event.getEntity(), MobEffects.f_19605_, 600, 9, new boolean[0]);
                if (((Boolean)ConfigTombstone.village_siege.glowingCreatureTest.get()).booleanValue()) {
                    EffectHelper.addEffect(event.getEntity(), MobEffects.f_19619_, 600);
                }
                EffectHelper.addEffect(event.getEntity(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntity().m_20194_();
                ServerLevel serverLevel = level = server != null ? server.m_129880_(location.dim) : null;
                if (level != null && !(spawn = new SpawnHelper(level, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleport(event.getEntity(), spawn, level);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
                event.setCanceled(true);
                return;
            }
            if (EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
                if (EventHandler.handlePlayerDamage((ServerPlayer)event.getEntity(), event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (ModItems.familiar_receptacle.captureSoul(event.getEntity())) {
                event.setCanceled(true);
                event.getEntity().m_146870_();
            }
        }
    }

    public static boolean handlePlayerDamage(ServerPlayer player, DamageSource source) {
        ItemStack soul;
        if (ModItems.voodoo_poppet.preventDeath(player, source)) {
            return true;
        }
        ServerLevel targetWorld = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        boolean requirePrevention = (Boolean)ConfigTombstone.player_death.preventDeathOutsideWorldBorder.get() != false && Helper.isOutsideWorldBorders((Level)targetWorld, playerPos) || (Boolean)ConfigTombstone.player_death.preventDeathOutsideBuildHeight.get() != false && Helper.isOutsideBuildHeight((Level)targetWorld, playerPos);
        ItemStack itemStack = soul = !requirePrevention ? InventoryHelper.findFirstInInventory((Player)player, p -> p.m_150930_((Item)ModItems.soul_receptacle)) : ItemStack.f_41583_;
        if (requirePrevention || !soul.m_41619_()) {
            Location spawnPos = new SpawnHelper(targetWorld, Helper.getCloserValidPos((Level)targetWorld, playerPos)).findSpawnPlace();
            if (spawnPos.isOrigin() && Helper.isDimensionTypeEnd((Level)targetWorld)) {
                spawnPos = new SpawnHelper(targetWorld, new BlockPos(0, 70, 0)).findSpawnPlace();
            }
            if (spawnPos.isOrigin()) {
                assert (player.m_20194_() != null);
                Pair<ServerLevel, BlockPos> respawnPoint = CommandTBTeleport.getRespawnPoint(player.m_20194_(), player);
                spawnPos = new SpawnHelper((ServerLevel)respawnPoint.getLeft(), (BlockPos)respawnPoint.getRight()).findSpawnPlace();
            }
            if (!spawnPos.isOrigin()) {
                if (!requirePrevention) {
                    soul.m_41774_(1);
                }
                player.m_21153_(player.m_21233_());
                EffectHelper.clearBadEffects((LivingEntity)player);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19618_, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19605_, 1200, 9, new boolean[0]);
                EffectHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                (requirePrevention ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendMessage((Player)player, new Object[0]);
                Helper.teleport(player, spawnPos, targetWorld);
                player.f_19789_ = 0.0f;
                return true;
            }
        }
        if (((Boolean)ConfigTombstone.recovery.backupOnDeath.get()).booleanValue() && !player.m_5833_()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getText(player.m_7755_()).getString()));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (Helper.isAprilFoolsDaySnowball(event.getEntity(), event.getSource())) {
            EffectHelper.addEffect(event.getEntity(), MobEffects.f_19597_, 200);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(LivingEvent.LivingVisibilityEvent event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntity()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorLowPriority()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(LivingEvent.LivingVisibilityEvent event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntity()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorHighPriority()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttackTarget(LivingSetAttackTargetEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntity()) && event.getTarget() != null) {
            LivingEntity attacker = event.getEntity();
            if (EffectHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EffectHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
                NeutralMob angerable;
                UUID angerAt;
                ((Mob)attacker).f_21362_ = null;
                if (event.getTarget().equals((Object)attacker.f_20949_)) {
                    attacker.f_20949_ = new DummyTargetEntity(attacker.f_19853_);
                }
                if (attacker instanceof NeutralMob && (angerAt = (angerable = (NeutralMob)attacker).m_6120_()) != null && angerAt.equals(event.getTarget().m_20148_())) {
                    angerable.m_6925_(null);
                    angerable.m_7870_(0);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity()) && !event.getEntity().m_5833_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            EntityHelper.syncTBCapability(player, false);
            DeathHandler.INSTANCE.handleRespawn(player);
            NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((Player)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true).forEach(arg_0 -> ((ServerPlayer)player).m_7292_(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Collection originalEffects;
        if (!EntityHelper.isValidServerPlayer(event.getOriginal()) || !EntityHelper.isValidServerPlayer(event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerPlayer original = (ServerPlayer)event.getOriginal();
        try {
            ((CapabilityDispatcher)CAPABILITIES.get(original)).getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(originalCap -> player.getCapability(TBCapabilityProvider.TB_CAPABILITY).resolve().ifPresent(playerCap -> playerCap.deserializeNBT((Tag)((CompoundTag)originalCap.serializeNBT()))));
        }
        catch (Throwable e) {
            LangKey.MESSAGE_KNOWLEDGE_RESTORE_FAILED.sendMessage((Player)player, new Object[0]);
        }
        if (((Boolean)ConfigTombstone.compatibility.preserveEffectsOnReturnEndConquered.get()).booleanValue() && !event.isWasDeath() && original.m_9236_().m_46472_() == Level.f_46430_ && player.m_21220_().isEmpty() && !(originalEffects = original.m_21220_()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag(event.getEntity()), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            if (!event.isCanceled() && event.getEntity() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntity());
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + player.m_7755_() + " was canceled by another mod");
            }
        } else {
            boolean isBeyondTheGraveDamage = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE;
            int knowledgeLoss = (Integer)ConfigTombstone.player_death.knowledgeLoss.get() + (isBeyondTheGraveDamage ? 10 : 0);
            if (knowledgeLoss > 0) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.loseKnowledge(player, knowledgeLoss));
                if (isBeyondTheGraveDamage) {
                    ModTriggers.LOST_KNOWLEDGE.trigger(player);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if ((Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1 && EntityHelper.isValidPlayer((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public static void onDrops(LivingDropsEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntity())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (Helper.isRuleKeepInventory((Player)player)) {
            return;
        }
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.m_36316_().getName() + " was canceled by another mod");
            return;
        }
        DeathHandler.INSTANCE.handleLoot(player, event.getDrops(), event.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().m_41619_() || event.getRight().m_41619_()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).map(String::trim).orElse("");
        boolean bl = valid = event.getLeft().m_150930_((Item)ModItems.grave_plate) && event.getRight().m_204117_(Tags.Items.INGOTS_IRON) || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && event.getRight().m_150930_((Item)ModItems.grave_dust);
        if (valid) {
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().m_41777_(), newName));
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity()) && event.getLeft().m_150930_((Item)ModItems.grave_plate) && event.getRight().m_204117_(Tags.Items.INGOTS_IRON) && EngravableHelper.isEngraved(event.getOutput())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result;
        BlockState blockState;
        Block block;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer(event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND) {
            BlockEntity tile;
            boolean hasShadowStep;
            boolean requireNerfGhostlyShape = (Boolean)ConfigTombstone.player_death.nerfGhostlyShapeOpenChest.get() != false && EffectHelper.isPotionActive((LivingEntity)event.getEntity(), ModEffects.ghostly_shape);
            boolean bl = hasShadowStep = (Boolean)ConfigTombstone.enchantments.nerfShadowStepOpenChest.get() != false && EntityHelper.getShadowStepLevel(event.getEntity()) > 0;
            if ((requireNerfGhostlyShape || hasShadowStep) && (tile = event.getLevel().m_7702_(event.getPos())) != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
                if (requireNerfGhostlyShape) {
                    EffectHelper.clearEffect((LivingEntity)event.getEntity(), ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayer)event.getEntity());
                }
                if (hasShadowStep) {
                    EntityHelper.setShadowStepCooldown(event.getEntity());
                }
            }
        }
        if (ModBlocks.isPlayerGrave(block = (blockState = event.getLevel().m_8055_(event.getPos())).m_60734_())) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getLevel().m_5776_() && SpawnProtectionHandler.INSTANCE.isBlockProtected((ResourceKey<Level>)event.getLevel().m_46472_(), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
        if (!event.isCanceled() && EntityHelper.isValidPlayer(event.getEntity()) && ModBlocks.isDecorativeGrave(block) && event.getEntity().m_21206_().m_204117_(ModTags.Items.magic_books) && (result = blockState.m_60664_(event.getLevel(), event.getEntity(), event.getHand(), event.getHitVec())).m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            if (!event.getLevel().m_5776_()) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)event.getEntity(), event.getPos(), event.getEntity().m_21206_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null && event.getEntity().f_19853_.m_5776_() && TimeHelper.atInterval(event.getEntity().f_19853_, 20)) {
            Player player;
            if (((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() && EntityHelper.isValidPlayer((Entity)event.getEntity()) && EntityHelper.getShadowStepLevel(player = (Player)event.getEntity()) > 0) {
                ModTombstone.PROXY.produceShadowStep(event.getEntity());
            }
            if (((Boolean)ConfigTombstone.client.showShieldParticle.get()).booleanValue() && event.getEntity().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity()) && event.getTarget() != null) {
            Entity entity;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                PacketHandler.sendToPlayer(new SyncProtectionMessage(event.getTarget().m_19879_(), true), player);
            }
            if ((entity = event.getTarget()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                MobEffectInstance effectBoneShield = target.m_21124_(ModEffects.bone_shield);
                if (effectBoneShield != null) {
                    PacketHandler.sendToPlayer(new EffectMessage(target.m_19879_(), effectBoneShield), player);
                }
                CompoundTag tag = target.getPersistentData();
                MobEffectInstance effectPrayer = target.m_21124_(ModEffects.prayer);
                if (effectPrayer != null && tag.m_128425_("prayer", 11) && tag.m_128425_("pray_type", 2)) {
                    PacketHandler.sendToPlayer(new PrayerMessage(target.m_19879_(), tag.m_128342_("prayer"), tag.m_128448_("pray_type"), effectPrayer.f_19503_), player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().m_150930_(Items.f_42589_) && EntityHelper.isValidServerPlayer((Entity)event.getEntity()) && PotionUtils.m_43547_((ItemStack)event.getItem()).size() > 0) {
            event.getEntity().getPersistentData().m_128379_(IS_DRINKING_POTION, true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntity())) {
            EventHandler.resetDrinking(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntity())) {
            EventHandler.resetDrinking(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(MobEffectEvent.Added event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntity()) && EventHandler.isDrinking(event.getEntity()) && event.getEffectInstance().f_19503_ >= 1200 && !EffectHelper.isBadEffect(event.getEffectInstance().m_19544_())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)event.getEntity(), ModPerks.alchemist) * 0.1f;
            EffectHelper.modifyEffectDuration(event.getEffectInstance(), e -> Mth.m_14143_((float)((float)e.f_19503_ * bonus)));
        }
    }

    private static boolean isDrinking(LivingEntity entityLiving) {
        return entityLiving.getPersistentData().m_128425_(IS_DRINKING_POTION, 1);
    }

    private static void resetDrinking(LivingEntity entityLiving) {
        entityLiving.getPersistentData().m_128473_(IS_DRINKING_POTION);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(MobEffectEvent.Applicable event) {
        Optional.ofNullable(event.getEntity()).map(Entity::m_6095_).ifPresent(type -> {
            MobEffect effect = event.getEffectInstance().m_19544_();
            if (effect == ModEffects.ghostly_shape || effect == ModEffects.preservation || effect == ModEffects.true_sight || effect == ModEffects.bait) {
                event.setResult(EntityHelper.isValidPlayer((Entity)event.getEntity()) ? Event.Result.ALLOW : Event.Result.DENY);
            } else if (EffectHelper.isBadEffect(effect) && EffectHelper.isPotionActive(event.getEntity(), ModEffects.purification)) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider((NonNullSupplier<ITBCapability>)((NonNullSupplier)TBCapabilityDefault::new)));
        } else if (event.getObject() instanceof AbstractVillager || event.getObject() instanceof AbstractGolem) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(EntityHelper::getHomeLocation))));
        } else if (CompatibilityMinecolonies.instance.isCitizen((Entity)event.getObject())) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)() -> new ProtectedEntityImpl(CompatibilityMinecolonies.instance::getHomePos))));
        } else if (event.getObject() instanceof GraveGuardian) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider((NonNullSupplier<IProtectedEntity>)((NonNullSupplier)ProtectedGraveGuardianImpl::new)));
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_150930_(Items.f_151058_)) {
            event.addCapability(TBSoulConsumerProvider.RL, (ICapabilityProvider)new TBSoulConsumerProvider(ModItems.enchanted_bundle));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidServerPlayer(event.getEntity())) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = event.getEntity().m_20194_();
            if (server == null) {
                return;
            }
            EntityHelper.syncTBCapability(player, false);
            Optional.ofNullable(server.m_129880_(event.getFrom())).ifPresent(fromDim -> Optional.ofNullable(server.m_129880_(event.getTo())).ifPresent(toDim -> {
                long dif = TimeHelper.worldTicks((Level)toDim) - TimeHelper.worldTicks((Level)fromDim);
                if (dif != 0L) {
                    CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                    IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.m_150930_((Item)ModItems.lost_tablet)).forEach(stack -> ModItems.lost_tablet.setCooldown((Level)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((Level)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
                }
            }));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        ItemStack itemStack = heldStack = event.getEntity() != null ? event.getEntity().m_21120_(event.getHand()) : ItemStack.f_41583_;
        if (event.getHand() == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)ModItems.bone_needle) && event.getTarget() instanceof LivingEntity && heldStack.m_41647_(event.getEntity(), (LivingEntity)event.getTarget(), event.getHand()).m_19080_()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!EntityHelper.isValidPlayer(event.getEntity())) {
            return;
        }
        if (heldStack.m_150930_((Item)ModItems.gift) || heldStack.m_150930_((Item)ModItems.smoke_ball) || heldStack.m_150930_((Item)ModItems.dust_of_vanishing) || heldStack.m_150930_((Item)ModItems.dust_of_frost) || heldStack.m_41720_() instanceof ItemGraveMagic) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && heldStack.m_150930_((Item)ModItems.ankh_of_pray) && event.getTarget() instanceof LivingEntity && heldStack.m_41647_(event.getEntity(), (LivingEntity)event.getTarget(), event.getHand()).m_19080_()) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldStack = event.getEntity().m_21205_();
        if (heldStack.m_150930_((Item)ModItems.ankh_of_pray)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPhantomTime(PhantomSpawnerEvent.TimeForCheck event) {
        if (((Boolean)ConfigTombstone.general.knowledgeReducePhantomSpawn.get()).booleanValue()) {
            event.getPlayer().getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> event.modifyTimeForCheck((int)((float)event.getTimeForCheck() * (1.0f + (float)cap.getTotalPerkPoints() * 0.1f))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Cloud cloud;
        ItemStack stack;
        if (event.getProjectile() != null && EntityType.f_20477_ == event.getProjectile().m_6095_() && event.getProjectile() instanceof Snowball && (stack = ((Snowball)event.getProjectile()).m_7846_()).m_150930_((Item)ModItems.smoke_ball) && (cloud = (Cloud)ModEntities.cloud.m_20615_(event.getProjectile().f_19853_)) != null) {
            event.getProjectile().m_146870_();
            event.setCanceled(true);
            cloud.setColor(ModItems.smoke_ball.getColor(stack, 0));
            cloud.m_146884_(event.getProjectile().m_20182_());
            event.getProjectile().f_19853_.m_7967_((Entity)cloud);
            stack.m_41774_(1);
        }
    }
}

