/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public final class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final Set<Location> ALLOWED_REMOVALS = ConcurrentHashMap.newKeySet();
    private Predicate<Location> no_grave_locations = l -> false;
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayer player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerLevel currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.m_129880_(lastGrave.dim)) == null) continue;
            if (Helper.getPlayerGrave((Level)currentWorld, lastGrave.getPos()).isPresent()) {
                return lastGrave;
            }
            INSTANCE.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayer player, Location pos) {
        boolean removeAbsentWorld;
        ListTag list = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        boolean bl = removeAbsentWorld = list.size() > 100;
        assert (player.m_20194_() != null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Location loc = NBTStackHelper.getLocation((CompoundTag)it.next(), "location");
            if (!pos.equals(loc) && (!removeAbsentWorld || player.m_20194_().m_129880_(loc.dim) != null)) continue;
            it.remove();
        }
    }

    public List<Location> getGraveList(ServerPlayer player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListTag nbtList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.m_128728_(i), "location"));
        }
        return graveLocations;
    }

    private boolean isNoGraveLocation(Location location) {
        return this.no_grave_locations.test(location);
    }

    public void addPlayerDead(ServerPlayer player, DamageSource source) {
        int xpLoss;
        int toRemove;
        ServerPlayer killer;
        int timeSinceDeath = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) > 1) {
                ModTriggers.CHAIN_DEATH.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        persistentTag.m_128379_(IS_PLAYER_DEAD_NBT_BOOL, true);
        boolean hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTStackHelper.setEffectlist(persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.m_21220_().stream().filter(EffectHelper::isAllowedEffect));
        }
        int xpTotal = EntityHelper.getPlayerTotalXp((Player)player);
        if (!hasPreservation && xpTotal > 0 && Optional.ofNullable(player.m_20194_()).map(MinecraftServer::m_129799_).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((Player)player, source) && (killer = (ServerPlayer)source.m_7639_()) != null && (toRemove = Mth.m_14107_((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
            xpTotal -= toRemove;
            killer.m_6756_(toRemove);
            LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((Player)player, toRemove, player.m_7755_());
        }
        if ((xpLoss = ((Integer)SharedConfigTombstone.player_death.xpLoss.get()).intValue()) == -1) {
            xpTotal = 0;
        } else if (!hasPreservation && xpLoss > 0) {
            xpTotal = Mth.m_14107_((double)((double)(xpTotal * Mth.m_14045_((int)(100 + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.memento_mori) * 20 - (Integer)SharedConfigTombstone.player_death.xpLoss.get()), (int)0, (int)100)) / 100.0));
        }
        persistentTag.m_128405_("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.m_128405_("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.m_128350_("tb_experience_bar", ((Float)pair.getRight()).floatValue());
        persistentTag.m_128379_("tb_has_preservation", hasPreservation);
    }

    public void updateNoGraveLocations() {
        ArrayList<Predicate<Location>> list = new ArrayList<Predicate<Location>>();
        for (String s : (List)ConfigTombstone.player_death.noGraveLocation.get()) {
            int range;
            int z;
            int y;
            int x;
            if (s.isEmpty()) continue;
            String[] res = s.split(",");
            if (res.length == 1) {
                list.add(l -> l.isSameDimension(res[0].trim()));
                continue;
            }
            if (res.length != 5) continue;
            try {
                x = Integer.parseInt(res[0].trim());
                y = Integer.parseInt(res[1].trim());
                z = Integer.parseInt(res[2].trim());
                range = Integer.parseInt(res[4].trim());
            }
            catch (NumberFormatException e) {
                ModTombstone.LOGGER.warn("invalid number in noGraveLocations with provided string: " + s);
                continue;
            }
            list.add(l -> l.isSameDimension(res[3].trim()) && l.isInRange(x, y, z, range));
        }
        this.no_grave_locations = list.stream().reduce(Predicate::or).orElse(l -> false);
    }

    private void restoreSoulbounds(ServerPlayer player) {
        if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() && (Helper.isModLoad("erebus") || Helper.isModLoad("death_compass"))) {
            player.m_150109_().f_35974_.stream().filter(stack -> "death_compass".equals(RegistryHelper.getRegistryString(stack.m_41720_()))).forEach(stack -> stack.m_41774_(stack.m_41613_()));
        }
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        NBTStackHelper.getListOrEmpty(persistentTag, SOULBOUND_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).filter(stack -> !stack.m_41619_()).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack)));
        persistentTag.m_128473_(SOULBOUND_STACKS_NBT_LIST);
        NBTStackHelper.getListOrEmpty(persistentTag, KEY_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_).filter(stack -> !stack.m_41619_()).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack)));
        persistentTag.m_128473_(KEY_STACKS_NBT_LIST);
    }

    private void storeSoulboundsOnBody(ServerPlayer player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        ListTag keyStack = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), KEY_STACKS_NBT_LIST);
        keys.forEach(key -> keyStack.add((Object)key.serializeNBT()));
        keys.clear();
        ListTag stackList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), SOULBOUND_STACKS_NBT_LIST);
        soulbounds.forEach(soulbound -> stackList.add((Object)soulbound.serializeNBT()));
        soulbounds.clear();
    }

    public boolean canRemovePlayerGrave(Level world, BlockPos pos) {
        return this.ALLOWED_REMOVALS.contains(new Location(pos, world));
    }

    public void removeAndEmptyPlayerGrave(Level level, BlockPos pos) {
        pos = pos.m_7949_();
        Location locationId = new Location(pos, level);
        this.ALLOWED_REMOVALS.add(locationId);
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        this.ALLOWED_REMOVALS.remove(locationId);
    }

    public void handleRespawn(ServerPlayer player) {
        this.restoreSoulbounds(player);
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        if (persistentTag.m_128471_(IS_PLAYER_DEAD_NBT_BOOL)) {
            this.restorePlayer(player, persistentTag);
        }
        player.f_36095_.m_38946_();
    }

    private void restorePlayer(ServerPlayer player, CompoundTag persistentTag) {
        boolean hasPreservation;
        if (PlayerPreference.get(player).getAutoEquipRule().equiOnRespawn()) {
            InventoryHelper.autoequip((Player)player, new ItemStackHandler(player.m_150109_().f_35974_));
        }
        EffectHelper.addGhostlyShape((Player)player);
        persistentTag.m_128473_(IS_PLAYER_DEAD_NBT_BOOL);
        List<MobEffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.m_128473_(PRESERVED_EFFECTS_NBT_LIST);
        }
        if ((hasPreservation = persistentTag.m_128471_("tb_has_preservation")) || (Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1) {
            player.f_36079_ = persistentTag.m_128451_("tb_experience_total");
            player.f_36078_ = persistentTag.m_128451_("tb_experience_level");
            player.f_36080_ = persistentTag.m_128457_("tb_experience_bar");
            persistentTag.m_128473_("tb_has_preservation");
            player.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
    }

    public void handleLoot(ServerPlayer player, Collection<ItemEntity> loots, DamageSource damageSource) {
        ItemStack key;
        BlockState state;
        boolean hasGrave;
        Location lastGrave;
        Location spawnPos;
        boolean hasDrop;
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        DeathHandler.collectKeyAndSoulbound(loots.iterator(), keys, soulbounds);
        double range = ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue();
        List itemList = player.f_19853_.m_6443_(ItemEntity.class, Helper.createBounds(player.m_20183_(), range), e -> e != null && (e.m_32056_() == null || player.m_20148_().equals(e.m_32056_())));
        DeathHandler.collectKeyAndSoulbound(itemList.iterator(), keys, soulbounds);
        PlayerPreference playerPreference = PlayerPreference.get(player.m_20148_());
        DeathHandler deathHandler = INSTANCE;
        if (playerPreference.denyGraveOnDeath()) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        int countDrop = loots.size() + itemList.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            if (!hasDrop) {
                keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().ifPresent(k -> ModItems.grave_key.reenchantOnDeath((Player)player, (ItemStack)k));
                LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        MinecraftServer server = player.m_20194_();
        assert (server != null);
        ServerLevel level = player.m_9236_();
        BlockPos initPos = Helper.getCloserValidPos((Level)level, player.m_20183_());
        Location location = ((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue() ? level.m_6325_(SectionPos.m_123171_((int)initPos.m_123341_()), SectionPos.m_123171_((int)initPos.m_123343_())).m_62954_().values().stream().filter(t -> t.m_58903_().equals(ModBlocks.tile_grave)).map(BlockEntityPlayerGrave.class::cast).filter(t -> t.getOwnerName().equals(player.m_36316_().getName()) && InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).findFirst().map(t -> new Location(t.m_58899_(), (Level)level)).orElse(Location.ORIGIN) : (spawnPos = Location.ORIGIN);
        if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(server, player)).isOrigin() && lastGrave.isSameDimension((Level)level) && Helper.getDistanceSq((Vec3i)lastGrave.getPos(), (Vec3i)initPos) <= 400.0 && Helper.getPlayerGrave((Level)level, lastGrave.getPos()).filter(t -> InventoryHelper.hasEnoughSlots(t.getInventory(), countDrop)).isPresent()) {
            spawnPos = lastGrave;
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            Pair<ServerLevel, BlockPos> respawnPoint;
            Pair<Location, SpawnHelper.SpawnResult> res = new SpawnHelper(level, initPos).withPlayerPreference(playerPreference).findGravePlaceWithResult();
            spawnPos = (Location)res.getLeft();
            if (Helper.isDimensionTypeEnd((Level)level) && (spawnPos.isOrigin() || !SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) && !((Location)(res = new SpawnHelper(level, new BlockPos(0, 70, 0)).withPlayerPreference(playerPreference).findGravePlaceWithResult()).getLeft()).isOrigin() && SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) {
                spawnPos = (Location)res.getLeft();
            }
            if (spawnPos.isOrigin() && (spawnPos = new SpawnHelper((ServerLevel)(respawnPoint = CommandTBTeleport.getRespawnPoint(server, player)).getLeft(), (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
                deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTombstone.LOGGER.debug("There was nowhere to place the grave!");
                return;
            }
        }
        if (!hasGrave) {
            NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((Player)player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTStackHelper.setLocation(new CompoundTag(), "location", spawnPos));
            ModTombstone.LOGGER.debug("A new grave of the player " + player.m_36316_().getName() + " was created at position [x:" + spawnPos.x + ", y:" + spawnPos.y + ", z:" + spawnPos.z + ", dim:" + spawnPos.getDimString() + "]");
            Direction facing = player.m_6350_().m_122424_();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)((BlockState)graveBlock.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing)).m_61124_((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            level.m_46597_(spawnPos.getPos(), state);
        } else {
            state = level.m_8055_(spawnPos.getPos());
        }
        BlockEntityPlayerGrave grave = Helper.getPlayerGrave((Level)level, spawnPos.getPos()).orElse(null);
        if (grave == null) {
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            ModTombstone.LOGGER.debug((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        if (hasGrave) {
            grave.resetDeathTime();
        }
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.m_129799_() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((Player)player, damageSource));
        MutableComponent locked = Component.m_237113_((String)"[").m_7220_((Component)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).m_130946_((String)((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + SharedConfigTombstone.player_death.decayTime.get() + " min" : "")) : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).m_130946_("]").m_6270_(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        player.m_213846_((Component)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).m_130946_(" ").m_7220_((Component)locked));
        player.m_213846_((Component)Component.m_237113_((String)"[x: ").m_130946_(String.valueOf(spawnPos.x)).m_130946_(", y: ").m_130946_(String.valueOf(spawnPos.y)).m_130946_(", z: ").m_130946_(String.valueOf(spawnPos.z)).m_130946_("]").m_7220_((Component)Component.m_237113_((String)" in ").m_130946_(spawnPos.getDimString())));
        Location finalSpawnPos = spawnPos;
        ItemStack itemStack = key = hasGrave ? keys.stream().filter(k -> ModItems.grave_key.getTombPos((ItemStack)k).equals(finalSpawnPos)).findFirst().orElse(ItemStack.f_41583_) : ItemStack.f_41583_;
        if (key.m_41619_() && ModItems.grave_key.isEnabled()) {
            key = ModItems.grave_key.createWithInfo((Player)player, spawnPos);
            keys.add(0, key);
        }
        ModItems.grave_key.reenchantOnDeath((Player)player, key);
        deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
        grave.setOwner((Player)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        loots.forEach(e -> e.m_32045_(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.m_32055_().m_41777_(), (boolean)false)));
        itemList.forEach(e -> e.m_32045_(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.m_32055_().m_41777_(), (boolean)false)));
        grave.m_6596_();
        level.m_7260_(spawnPos.getPos(), Blocks.f_50016_.m_49966_(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (loots.size() <= itemHandler.getSlots()) {
            try {
                loots.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static void collectKeyAndSoulbound(Iterator<ItemEntity> it, List<ItemStack> keys, List<ItemStack> soulbounds) {
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = it.next();
            if (entityItem == null || (stack = entityItem.m_32055_()).m_41619_()) {
                it.remove();
                continue;
            }
            if (!EntityHelper.hasSoulbound(stack)) continue;
            if (stack.m_150930_((Item)ModItems.grave_key)) {
                keys.add(stack.m_41777_());
            } else {
                soulbounds.add(stack.m_41777_());
            }
            entityItem.m_32045_(ItemStack.f_41583_);
            it.remove();
        }
    }
}

