/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.IChanneling;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.PrayerMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer,
IChanneling {
    private Multimap<Attribute, AttributeModifier> attributes;

    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder().m_41499_(30).m_41486_());
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player != null) {
            if (!this.m_5812_(stack)) {
                int cd = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
                if (cd > 0) {
                    this.addInfo(tooltip, this.m_5524_() + ".use1", Component.m_237113_((String)("[" + TimeHelper.getTimeString(cd) + "]")).m_130948_(StyleType.TOOLTIP_DESC));
                }
            } else {
                this.addItemUse(tooltip, "2", new Object[0]);
            }
            if (CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS) <= 0) {
                this.addItemUse(tooltip, "3", new Object[0]);
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        return ctx.m_43723_() != null ? this.m_7203_(ctx.m_43725_(), ctx.m_43723_(), ctx.m_43724_()).m_19089_() : InteractionResult.FAIL;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (EntityHelper.isValidPlayer(player) && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_150930_((Item)this) && EntityHelper.noGlobalItemCooldown(player, this) && CooldownHandler.INSTANCE.noCooldown(player, CooldownType.NEXT_PRAY) && !EffectHelper.isPotionActive(target, ModEffects.prayer)) {
            if (target instanceof ZombieVillager) {
                return this.handleInteractEntity(player, target, 3, null);
            }
            int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignment < 0) {
                if (target instanceof Villager) {
                    return this.handleInteractEntity(player, target, 2, target.f_19853_.m_46791_() == Difficulty.PEACEFUL ? LangKey.MESSAGE_DIFFICULTY_PEACEFUL : null);
                }
            } else if (alignment > 0) {
                TameableType tameableType;
                if (alignment > 1 && (tameableType = TameableType.getType((Entity)target)) != null) {
                    return this.handleInteractEntity(player, target, 0, tameableType.getOwnerId((Entity)target) != null ? LangKey.MESSAGE_FAMILIAR_ALREADY_OWNED : null);
                }
                return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> this.handleInteractEntity(player, target, 1, protCap.isActive() ? LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED : null)).orElse(InteractionResult.SUCCESS);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleInteractEntity(Player player, LivingEntity target, int prayType, @Nullable LangKey failKey) {
        if (failKey != null) {
            if (!player.f_19853_.m_5776_()) {
                failKey.sendMessage(player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        } else {
            player.m_6672_(InteractionHand.MAIN_HAND);
            if (!player.f_19853_.m_5776_()) {
                EntityHelper.getPersistentTag(player).m_128405_("prayer", target.m_19879_());
                target.getPersistentData().m_128362_("prayer", player.m_20148_());
                target.getPersistentData().m_128376_("pray_type", (short)prayType);
                int duration = 200;
                EffectHelper.addEffect(target, ModEffects.prayer, 200);
                PacketHandler.sendToAllTrackingPlayersAndSelf(new PrayerMessage(target.m_19879_(), player.m_20148_(), prayType, 200), target);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int remainingTicks) {
        if (!level.m_5776_() && EntityHelper.isValidServerPlayer((Entity)entity)) {
            this.onStopCasting((ServerPlayer)entity);
        }
    }

    private void onStopCasting(ServerPlayer player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
        persistentTag.m_128473_("prayer");
        persistentTag.m_128473_("pray_type");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!EntityHelper.isValidPlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        if (hand != InteractionHand.MAIN_HAND || !heldStack.m_150930_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (EntityHelper.hasGlobalItemCooldown(player, this) || CooldownHandler.INSTANCE.hasCooldown(player, CooldownType.NEXT_PRAY)) {
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        ItemStack offhand = player.m_21206_();
        if (ModItems.familiar_receptacle.containSoul(offhand) && ModItems.familiar_receptacle.getDurability(offhand) != 0.0) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.f_19853_.m_5776_()) {
                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessage(player, StyleType.COLOR_OFF, new Object[0]);
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        player.m_6672_(InteractionHand.MAIN_HAND);
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    public ItemStack m_5922_(ItemStack stack, @Nullable Level level, LivingEntity entity) {
        ServerPlayer player;
        if (stack.m_150930_((Item)this) && EntityHelper.isValidServerPlayer((Entity)entity) && EntityHelper.noGlobalItemCooldown((Player)(player = (ServerPlayer)entity), this) && CooldownHandler.INSTANCE.noCooldown((Player)player, CooldownType.NEXT_PRAY)) {
            CompoundTag persistentTag = EntityHelper.getPersistentTag((Player)player);
            if (persistentTag.m_128425_("prayer", 3)) {
                LivingEntity living;
                Entity target = player.f_19853_.m_6815_(persistentTag.m_128451_("prayer"));
                this.onStopCasting(player);
                if (target instanceof LivingEntity && EffectHelper.isPotionActive(living = (LivingEntity)target, ModEffects.prayer)) {
                    living.m_21195_(ModEffects.prayer);
                    int alignment = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getAlignmentLevel).orElse(0);
                    if (PrayerHelper.exorcism(player, living, alignment) || PrayerHelper.zombify(player, living, alignment) || PrayerHelper.empathy(player, living, alignment) || PrayerHelper.protection(player, living, alignment)) {
                        return stack;
                    }
                }
                return stack;
            }
            PrayerHelper.onGrave(player, player.m_20183_());
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        this.onChanneling(stack, entity, timeLeft);
    }

    @Override
    public CastingType getCastingType(ItemStack stack) {
        return CastingType.PRAY;
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        Player player = ModTombstone.PROXY.getClientPlayer();
        if (player == null || EntityHelper.hasGlobalItemCooldown(player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown(player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown(player);
            int elapsedTime = maxTime - cooldownToPray;
            ItemCooldowns cd = player.m_36335_();
            cd.f_41516_ -= elapsedTime;
            cd.m_41524_((Item)this, maxTime);
            cd.f_41516_ += elapsedTime;
            return false;
        }
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return stack.m_150930_((Item)this);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return stack.m_150930_((Item)this);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public int m_6473_() {
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            if (this.attributes != null) {
                return this.attributes;
            }
            if (ForgeMod.REACH_DISTANCE.isPresent()) {
                this.attributes = ImmutableMultimap.builder().put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(UUID.fromString("a336c4e4-a0c4-4da9-ba45-4b7de7eb449d"), "Ankh range bonus", 10.0, AttributeModifier.Operation.ADDITION)).build();
                return this.attributes;
            }
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> {
            boolean hasReset = cap.resetPerks(player);
            if (hasReset) {
                ModTriggers.RESET_PERKS.trigger(player);
                return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]), 1);
            }
            int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.RESET_PERKS);
            if (cd > 0) {
                int min = cd / 1200;
                if (min > 0) {
                    cd -= min * 1200;
                }
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20));
            }
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
        }).orElse(ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0])));
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

