/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public record UpgradePerkServerMessage(SyncType syncType, Perk perk) {
    static UpgradePerkServerMessage fromBytes(FriendlyByteBuf buf) {
        return new UpgradePerkServerMessage(buf.readBoolean() ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, (Perk)PerkRegistry.get().getValue((int)buf.readShort()));
    }

    static void toBytes(UpgradePerkServerMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.syncType == SyncType.DOWNGRADE_PERK);
        buf.writeShort(PerkRegistry.get().getID((Object)msg.perk));
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }

    public static class Handler {
        static void handle(UpgradePerkServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayer player = ctx.getSender();
                    if (player != null) {
                        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                            int levelPerk = cap.getPerkLevel((Player)player, message.perk);
                            int totalPerkPoints = cap.getTotalPerkPoints();
                            if (message.syncType == SyncType.UPGRADE_PERK && levelPerk < Math.min(message.perk.getLevelMax(), EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints)) && totalPerkPoints - cap.getUsedPerkPoints((Player)player) >= message.perk.getCost(levelPerk + 1)) {
                                cap.setPerk(message.perk, levelPerk + 1);
                                ModTriggers.SELECTED_PERKS.trigger(player);
                                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk + 1), player);
                            } else if (message.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0 && player.m_7500_()) {
                                cap.setPerk(message.perk, levelPerk - 1);
                                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.SET_PERK, message.perk, levelPerk - 1), player);
                            }
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

