/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.BoundParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleRounding
extends BoundParticle {
    private static final EnumMap<Type, ResourceLocation> COMMON_TEXTURE = new EnumMap(Arrays.stream(Type.values()).collect(Collectors.toMap(Function.identity(), type -> type.rl)));
    private final Type type;
    private final int count;
    private final double height;
    @Nullable
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleRounding(ClientLevel level, LivingEntity entity, Type type) {
        this(level, entity, type, null);
    }

    public ParticleRounding(ClientLevel level, LivingEntity entity, Type type, @Nullable Predicate<LivingEntity> requireRemoval) {
        super(level, entity, entity.m_20205_());
        this.type = type;
        this.count = Mth.m_14167_((float)(entity.m_20205_() * ((float)Math.PI * 2)));
        this.height = type.heightProvider.apply(entity);
        this.requireRemoval = requireRemoval;
        if (this.type.rolling) {
            this.setRolling(0.31415927f);
        }
        this.setSolid(true);
    }

    @Override
    protected void addParticleDatas(List<BoundParticle.ParticleData> datas) {
        IntStream.range(0, this.count).forEach(part -> datas.add(new BoundParticle.ParticleData(this.type.size, (double)part / (double)this.count, this.height, this.type.rolling ? (part % 2 == 0 ? 0.0f : (float)Math.PI) : 0.0f)));
    }

    @Override
    protected boolean requireRemoval() {
        return this.requireRemoval != null ? Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true).booleanValue() : super.requireRemoval();
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE.get((Object)this.type);
    }

    @Override
    protected void onParticleDataUpdate(BoundParticle.ParticleData data, double ratio) {
        super.onParticleDataUpdate(data, ratio);
        if (this.type == Type.BONE) {
            ParticleBlinkingAura part = new ParticleBlinkingAura(this.f_107208_, data.pos.f_82479_, data.pos.f_82480_, data.pos.f_82481_, 1.0f, 0.8f, Helper.RANDOM.nextFloat() + 0.5f);
            part.m_107271_(0.15f);
            part.m_6569_(2.5f);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)part);
        }
    }

    public static enum Type {
        HEART(new ResourceLocation("minecraft", "textures/particle/heart.png"), 0.6f, false),
        SHIELD(new ResourceLocation("tombstone", "textures/item/pray_of_protection.png"), 1.0f, false, entity -> 0.3),
        BONE(new ResourceLocation("minecraft", "textures/item/bone.png"), 1.0f, true, entity -> 0.3),
        ANKH(new ResourceLocation("tombstone", "textures/item/ankh.png"), 1.0f, false);

        private final ResourceLocation rl;
        private final float size;
        private final boolean rolling;
        private final Function<LivingEntity, Double> heightProvider;

        private Type(ResourceLocation rl, float size, boolean rolling) {
            this(rl, size, rolling, entity -> (double)entity.m_20206_() / 4.0);
        }

        private Type(ResourceLocation rl, float size, boolean rolling, Function<LivingEntity, Double> heightProvider) {
            this.rl = rl;
            this.size = size;
            this.rolling = rolling;
            this.heightProvider = heightProvider;
        }

        public static Type byId(int id) {
            return Type.values()[Mth.m_14045_((int)id, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

