/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.config.TombstoneModConfig;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.loot.AsGiftFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.InOpenWaterCondition;
import ovh.corail.tombstone.loot.KnowledgeRewardFunction;
import ovh.corail.tombstone.loot.PreciseEnchantFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ClientModEvents;

@Mod(value="tombstone")
public final class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static LootItemConditionType OPEN_WATER;
    public static LootItemFunctionType DELAYED_NBT_LOOT;
    public static LootItemFunctionType PRECISE_ENCHANT;
    public static LootItemFunctionType AS_GIFT;
    public static LootItemFunctionType TRIGGER_CAT_MORNING;
    public static LootItemFunctionType KNOWLEDGE_REWARD;
    public static final EnchantmentCategory TYPE_TOMBSTONE_ALL;

    public ModTombstone() {
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::preInit);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::enqueueIMC);
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ScreenConfig::new));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
        if (SupportMods.CURIOS.isLoaded() && ((Boolean)ConfigTombstone.compatibility.curioBundleSupport.get()).booleanValue()) {
            CompatibilityCurio.instance.sendIMC();
        }
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new TombstoneModConfig(SharedConfigTombstone.CONFIG_SPEC, context.getActiveContainer()));
    }

    private void preInit(FMLCommonSetupEvent event) {
        PROXY.preInit();
        OPEN_WATER = (LootItemConditionType)Registry.m_122961_((Registry)Registry.f_122877_, (String)"tombstone:in_open_water", (Object)new LootItemConditionType((Serializer)InOpenWaterCondition.SERIALIZER));
        DELAYED_NBT_LOOT = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)DelayedNBTFunction.RL, (Object)new LootItemFunctionType((Serializer)DelayedNBTFunction.SERIALIZER));
        PRECISE_ENCHANT = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)PreciseEnchantFunction.RL, (Object)new LootItemFunctionType((Serializer)PreciseEnchantFunction.SERIALIZER));
        AS_GIFT = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)AsGiftFunction.RL, (Object)new LootItemFunctionType((Serializer)AsGiftFunction.SERIALIZER));
        TRIGGER_CAT_MORNING = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)TriggerCatMorningFunction.RL, (Object)new LootItemFunctionType((Serializer)TriggerCatMorningFunction.SERIALIZER));
        KNOWLEDGE_REWARD = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)KnowledgeRewardFunction.RL, (Object)new LootItemFunctionType((Serializer)KnowledgeRewardFunction.SERIALIZER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientModEvents::initModels);
    }

    static {
        TYPE_TOMBSTONE_ALL = EnchantmentCategory.create((String)"type_tombstone_all", p -> p != null && (p.m_6473_() > 0 || p.m_41459_() == 1));
    }
}

