/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.combine.CombineRecipe;
import ovh.corail.tombstone.compatibility.CombineRecipeCategory;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public final class IntegrationJEI
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = new ResourceLocation("tombstone", "jei_integration");
    private final RecipeType<CombineRecipe> recipeType = RecipeType.create((String)"tombstone", (String)"combine", CombineRecipe.class);

    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CombineRecipeCategory(this.recipeType, registry.getJeiHelpers().getGuiHelper())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ImmutableList.Builder combineBuilder = ImmutableList.builder();
        combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.impregnated_diamond}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), "minecraft:rabbit")}), () -> ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.impregnated_diamond), "minecraft:rabbit")));
        ModItems.grave_key.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.grave_dust.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.strange_scroll.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.strange_tablet.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModTags.Items.VOODOO_POPPET_INGREDIENT_BY_TYPE.forEach((key, value) -> combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.voodoo_poppet)}), Ingredient.m_204132_((TagKey)value), () -> ModItems.voodoo_poppet.addProtection(new ItemStack((ItemLike)ModItems.voodoo_poppet), (DamageType)((Object)key)))));
        ModBlocks.DECORATIVE_GRAVES.values().forEach(decorativeGrave -> {
            String name1 = Helper.getRandomThankName();
            combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{decorativeGrave}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), name1)}), () -> EngravableHelper.setEngravedName(new ItemStack((ItemLike)decorativeGrave), name1)));
            String name2 = Helper.getRandomThankName();
            ItemStack whiteGrave = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)decorativeGrave), 1);
            combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{whiteGrave}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), name2)}), () -> EngravableHelper.setEngravedName(whiteGrave.m_41777_(), name2)));
        });
        registration.addRecipes(this.recipeType, (List)combineBuilder.build());
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        builder.add((Object)factory.createAnvilRecipe(new ItemStack((ItemLike)ModItems.grave_plate), Helper.getStacks((TagKey<Item>)Tags.Items.INGOTS_IRON), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), Helper.getRandomThankName()))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.tablet_of_assistance), "enchant", true);
        builder.add((Object)factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.m_41777_(), Helper.getRandomThankName()))));
        registration.addRecipes(RecipeTypes.ANVIL, (List)builder.build());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.DECORATIVE_GRAVES.values()) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)block.m_5456_(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_assistance, (stack, ctx) -> ModItems.tablet_of_assistance.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_cupidity, (stack, ctx) -> ModItems.tablet_of_cupidity.isAncient((ItemStack)stack) ? "ancient" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
    }
}

