/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;

public final class EnchantmentPlagueBringer
extends WeaponEnchantment {
    public EnchantmentPlagueBringer() {
        super("plague_bringer", Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentPlagueBringer.get();
    }

    protected boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ((Boolean)SharedConfigTombstone.enchantments.allowPlagueBringerCombiningMagicSiphon.get() != false || ench != ModEnchantments.magic_siphon);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.plagueBringerEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int getLevelLimit() {
        return (Integer)SharedConfigTombstone.enchantments.maxLevelPlagueBringer.get();
    }

    @Override
    protected boolean testProc(LivingEntity attacker, LivingEntity target, int amplifier) {
        return Helper.RANDOM.nextInt(20) < amplifier;
    }

    @Override
    public void onProc(LivingEntity attacker, LivingEntity target, int amplifier) {
        MobEffectInstance effect = EffectHelper.getRandomEffect(TimeHelper.tickFromSecond((Integer)ConfigTombstone.enchantments.durationPlagueBringer.get()), true);
        if (effect != null) {
            boolean canAffectAttacker;
            target.m_7292_(effect);
            boolean bl = canAffectAttacker = (Boolean)ConfigTombstone.enchantments.nerfPlagueBringer.get() != false && (!EntityHelper.isValidPlayer((Entity)attacker) || !EntityHelper.isBadAlignment((Player)attacker));
            if (canAffectAttacker) {
                attacker.m_7292_(new MobEffectInstance(effect));
            }
        }
    }
}

