/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.ResetPerkMessage;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientEventHandler {
    public static final KeyMapping KEYBIND_KNOWLEDGE = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    public static final KeyMapping KEYBIND_CONFIG = new KeyMapping(LangKey.MESSAGE_CONFIG.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    public static final KeyMapping KEYBIND_COMPENDIUM = new KeyMapping(LangKey.MESSAGE_COMPENDIUM.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    private static boolean isFirstGuiGameOver = false;
    private static boolean requireRemovalVisibility = false;
    private static boolean requireRemovalNightVision = false;
    private static boolean hasWaterVision = false;
    private static OpeningGui openingGui = OpeningGui.NONE;
    private static CompendiumData.CompendiumLabel compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
    public static boolean hasTrueSight = false;
    private static long nextGhostTime = -1L;
    public static Pair<LivingEntity, PoseStack> renderInfo = null;
    public static String toDisplay;
    private static final SuggestionProvider<CommandSourceStack> LABEL_SUGGESTION;
    private static long LAST_PACKET;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            requireRemovalNightVision = false;
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MarkerHandler.instance.update(mc);
            toDisplay = null;
            hasTrueSight = EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.ghostly_shape) || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.true_sight);
            hasWaterVision = hasTrueSight || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.aquatic_life) && Minecraft.m_91087_().f_91063_.m_109153_().m_167685_() == FogType.WATER;
            boolean bl = requireRemovalNightVision = hasTrueSight && !EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, MobEffects.f_19611_);
            if (requireRemovalNightVision) {
                mc.f_91074_.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 1200, 0, true, false));
            }
        } else {
            TBScreen screen;
            if (requireRemovalNightVision) {
                requireRemovalNightVision = false;
                mc.f_91074_.m_6234_(MobEffects.f_19611_);
            }
            switch (openingGui) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case KNOWLEDGE: {
                    TBScreen tBScreen = mc.f_91074_.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> new ScreenKnowledge(mc.f_91074_, (ITBCapability)cap)).orElse(null);
                    break;
                }
                case CONFIG: {
                    TBScreen tBScreen = new ScreenConfig();
                    break;
                }
                case COMPENDIUM: {
                    TBScreen tBScreen = new ScreenCompendium(compendiumLabel);
                    break;
                }
                case NONE: {
                    TBScreen tBScreen = screen = null;
                }
            }
            if (screen == null) {
                if (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen) {
                    if (KEYBIND_COMPENDIUM.m_90859_()) {
                        openingGui = OpeningGui.COMPENDIUM;
                    } else if (KEYBIND_CONFIG.m_90859_()) {
                        openingGui = OpeningGui.CONFIG;
                    } else if (KEYBIND_KNOWLEDGE.m_90859_()) {
                        openingGui = OpeningGui.KNOWLEDGE;
                    }
                }
            } else {
                openingGui = OpeningGui.NONE;
                mc.m_91152_((Screen)screen);
            }
            if (((Boolean)ConfigTombstone.client.allowHalloweenGhost.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((Level)mc.f_91073_)) {
                    long time = TimeHelper.worldTicks((Level)mc.f_91073_);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((Player)mc.f_91074_, CooldownType.NEXT_PRAY)) {
                            Vec3 ghostVec = mc.f_91074_.m_20182_().m_82520_((Helper.RANDOM.nextDouble() - 0.5) * 18.0, 0.0, (Helper.RANDOM.nextDouble() - 0.5) * 18.0);
                            mc.f_91061_.m_107344_((Particle)new ParticleGhost(mc.f_91073_, ghostVec.f_82479_, ghostVec.f_82480_, ghostVec.f_82481_, 0.0, 0.0));
                        }
                        nextGhostTime = time + (long)Helper.RANDOM.nextInt(6000) + 60L;
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(ScreenEvent.Render.Pre event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.m_91087_().f_91074_).ifPresent(p -> p.m_6234_(MobEffects.f_19611_));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbgui").executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE))).then(OpeningGui.KNOWLEDGE.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE)))).then(OpeningGui.CONFIG.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.CONFIG)))).then(((LiteralArgumentBuilder)OpeningGui.COMPENDIUM.literal().executes(c -> ClientEventHandler.openingCompendium())).then(Commands.m_82129_((String)"label", (ArgumentType)StringArgumentType.word()).suggests(LABEL_SUGGESTION).executes(c -> ClientEventHandler.openingCompendium(StringArgumentType.getString((CommandContext)c, (String)"label"))))));
    }

    private static int openingGui(OpeningGui gui) {
        openingGui = gui;
        compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
        return 1;
    }

    private static int openingCompendium() {
        return ClientEventHandler.openingGui(OpeningGui.COMPENDIUM);
    }

    private static int openingCompendium(String labelString) {
        CompendiumData.CompendiumLabel label = CompendiumData.CompendiumLabel.fromString(labelString);
        if (label == null) {
            throw LangKey.MESSAGE_INVALID_LABEL.asCommandException(new Object[0]);
        }
        openingGui = OpeningGui.COMPENDIUM;
        compendiumLabel = label;
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?, EntityModel<?>> event) {
        if (event.getEntity().m_6095_() == EntityType.f_20532_ && (EffectHelper.isPotionActive(event.getEntity(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive(event.getEntity()))) {
            renderInfo = Pair.of((Object)event.getEntity(), (Object)event.getPoseStack());
        }
        if (hasTrueSight && event.getEntity().m_20145_()) {
            if (Optional.ofNullable(Minecraft.m_91087_().f_91074_).map(arg_0 -> ((LivingEntity)event.getEntity()).m_20177_(arg_0)).orElse(false).booleanValue()) {
                event.getEntity().m_6842_(false);
                requireRemovalVisibility = true;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, EntityModel<?>> event) {
        if (requireRemovalVisibility) {
            event.getEntity().m_6842_(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(ScreenEvent.Opening event) {
        LocalPlayer player;
        if (event.getScreen() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && !player.f_19853_.m_6106_().m_5466_()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.m_7583_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        FluidState fluidState;
        boolean isWater;
        if ((hasTrueSight || hasWaterVision) && ((isWater = (fluidState = event.getCamera().getBlockAtCamera().m_60819_()).m_205070_(FluidTags.f_13131_)) || hasTrueSight && fluidState.m_205070_(FluidTags.f_13132_))) {
            event.setCanceled(true);
            event.setFarPlaneDistance(192.0f * (isWater ? 1.0f : 0.09375f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(ViewportEvent.ComputeFogColor event) {
        if (hasTrueSight || hasWaterVision) {
            FluidState fluidState = event.getCamera().getBlockAtCamera().m_60819_();
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.m_205070_(FluidTags.f_13132_) && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockScreenEffectEvent event) {
        if ((hasTrueSight || hasWaterVision) && (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_151058_)) {
            event.getToolTip().add(1, Component.m_237115_((String)"tombstone.item.enchanted_bundle.desc").m_6270_(StyleType.TOOLTIP_USE));
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().m_41782_()) {
            boolean isEnchantedBook = event.getItemStack().m_150930_(Items.f_42690_);
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListTag taglist = isEnchantedBook ? EnchantedBookItem.m_41163_((ItemStack)event.getItemStack()) : event.getItemStack().m_41785_();
            List<TombstoneEnchantment> list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListTag)taglist).m_128728_(arg_0)).map(nbt -> nbt.m_128461_("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().containsKey(id)).map(ModEnchantments.getEnchantments()::get).toList();
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    Component currentTooltip = (Component)event.getToolTip().get(line);
                    return currentTooltip.m_214077_() instanceof TranslatableContents && enchant.m_44704_().equals(((TranslatableContents)currentTooltip.m_214077_()).m_237508_());
                }).findFirst().ifPresent(line -> {
                    List<Component> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (Component info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                MarkerHandler.instance.renderBox(event.getPoseStack());
            }
        }
    }

    @SubscribeEvent
    public static void renderOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        if (toDisplay != null) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack poseStack = new PoseStack();
            int halfWidth = mc.m_91268_().m_85445_() / 2;
            int minY = 50;
            int halfLength = mc.f_91062_.m_92895_(toDisplay) / 2;
            Objects.requireNonNull(mc.f_91062_);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(halfWidth - halfLength - 2), (int)(minY - 2), (int)(halfWidth + halfLength + 2), (int)(minY + 9 + 1), (int)Integer.MIN_VALUE);
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)mc.f_91062_, (String)toDisplay, (int)halfWidth, (int)minY, (int)-8347488);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(ComputeFovModifierEvent event) {
        if (!event.getPlayer().m_6117_() && event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.christmas_hat) && event.getPlayer().m_150110_().m_35947_() != 0.0f) {
            event.setNewFovModifier(event.getNewFovModifier() - 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClickAttack(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_21205_().m_150930_((Item)ModItems.ankh_of_pray)) {
                BlockState state;
                BlockHitResult result;
                event.setCanceled(true);
                if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (result = (BlockHitResult)mc.f_91077_).m_82448_((Entity)mc.f_91074_) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = mc.f_91073_.m_8055_(result.m_82425_())).m_60734_()) && mc.f_91073_.m_46467_() >= LAST_PACKET + 20L) {
                    LAST_PACKET = mc.f_91073_.m_46467_();
                    PacketHandler.sendToServer(new ResetPerkMessage(result.m_82450_(), result.m_82434_(), result.m_82425_(), result.m_82436_()));
                    mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                event.setSwingHand(false);
            }
        }
    }

    static {
        LABEL_SUGGESTION = (ctx, build) -> SharedSuggestionProvider.m_82981_(Arrays.stream(CompendiumData.CompendiumLabel.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.US)), (SuggestionsBuilder)build);
        LAST_PACKET = 0L;
    }

    private static enum OpeningGui implements ISubCommand
    {
        NONE,
        KNOWLEDGE,
        CONFIG,
        COMPENDIUM;


        private boolean isOpening() {
            return this != NONE;
        }
    }
}

