/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;

public class RegistryHelper {
    @Nullable
    public static ResourceLocation getRegistryName(Enchantment enchantment) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
    }

    @Nullable
    public static Enchantment getEnchantment(ResourceLocation rl) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rl);
    }

    public static String getRegistryString(Enchantment enchantment) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(enchantment)).map(ResourceLocation::toString).orElse("");
    }

    @Nullable
    public static ResourceLocation getRegistryName(MobEffect enchantment) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)enchantment);
    }

    @Nullable
    public static MobEffect getEffect(ResourceLocation rl) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rl);
    }

    public static String getRegistryString(MobEffect enchantment) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(enchantment)).map(ResourceLocation::toString).orElse("");
    }

    @Nullable
    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    @Nullable
    public static Block getBlock(ResourceLocation rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }

    public static String getRegistryString(Block block) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(block)).map(ResourceLocation::toString).orElse("");
    }

    @Nullable
    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @Nullable
    public static Item getItem(ResourceLocation rl) {
        return (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    public static String getRegistryString(Item item) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(item)).map(ResourceLocation::toString).orElse("");
    }

    public static boolean isValid(Item item, Predicate<ResourceLocation> rlPredicate) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(item)).map(rlPredicate::test).orElse(false);
    }

    @Nullable
    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }

    @Nullable
    public static EntityType<?> getEntity(ResourceLocation rl) {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
    }

    public static String getRegistryString(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(Entity::m_6095_).map(RegistryHelper::getRegistryString).orElse("");
    }

    public static String getRegistryString(EntityType<?> entityType) {
        return Optional.ofNullable(RegistryHelper.getRegistryName(entityType)).map(ResourceLocation::toString).orElse("");
    }

    public static <T> Optional<T> findRandom(IForgeRegistry<T> registry, Predicate<T> predicate) {
        return Helper.getRandomInList(registry.getValues().stream().filter(predicate).collect(Collectors.toList()));
    }
}

