/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.IChanneling;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer,
IChanneling {
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_())).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    protected abstract boolean doEffects(ServerLevel var1, ServerPlayer var2, ItemStack var3);

    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            return ItemStack.f_41583_;
        }
        return this.setUseCount(stack, --useCount);
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(tooltip, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(level, stack)) > 10) {
                this.addWarn(tooltip, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_150930_((Item)this) || !this.isEnchanted(heldStack)) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (EntityHelper.hasGlobalItemCooldown(player, this)) {
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        int cd = this.getCooldown(level, heldStack);
        if (cd > 0) {
            if (!level.m_5776_()) {
                EntityHelper.setGlobalItemCooldown(player, this, 20);
                LangKey.MESSAGE_IN_COOLDOWN.sendMessage(player, TimeHelper.getTimeStringWithUnit(cd));
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (EntityHelper.isValidPlayer(context.m_43723_())) {
            if (this.canBlockInteractFirst(context.m_43725_().m_8055_(context.m_8083_()), stack)) {
                return InteractionResult.PASS;
            }
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return InteractionResult.FAIL;
    }

    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(state.m_60734_());
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (this.isEnchanted(stack)) {
            this.onChanneling(stack, entity, timeLeft);
        }
    }

    @Override
    public CastingType getCastingType(ItemStack stack) {
        return CastingType.SIMPLE_TELEPORT;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (EntityHelper.isValidPlayer((Entity)entity)) {
            Player player = (Player)entity;
            if (!player.f_19853_.m_5776_() && this.isEnchanted(stack) && this.doEffects((ServerLevel)level, (ServerPlayer)player, stack)) {
                ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundSource.PLAYERS, level, player.m_20183_(), 0.5f, 0.5f);
                if (!player.m_150110_().f_35937_ && this.canConsumeOnUse()) {
                    stack = this.onConsumeItem(player, stack);
                }
                if (!stack.m_41619_()) {
                    this.setCooldown(level, stack, this.getCastingCooldown());
                }
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 80;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public int m_6473_() {
        return 0;
    }

    public abstract int getCastingCooldown();

    public int getCooldown(@Nullable Level level, ItemStack stack) {
        return level != null && stack.m_150930_((Item)this) ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, COOLDOWN_TIME_NBT_LONG, this.getCastingCooldown()) : 0;
    }

    public void setCooldown(@Nullable Level level, ItemStack stack, int time) {
        if (level != null && stack.m_150930_((Item)this)) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(level) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.min(NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT, 0), this.getUseMax());
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, Math.min(useCount, this.getUseMax()));
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }

    protected static Item.Properties getBuilder() {
        return ItemGeneric.getBuilder().m_41487_(1).m_41486_();
    }
}

