/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModBlocks;

public record TombstoneActivatedMessage(BlockPos currentPos) {
    static TombstoneActivatedMessage fromBytes(FriendlyByteBuf buf) {
        return new TombstoneActivatedMessage(BlockPos.m_122022_((long)buf.readLong()));
    }

    static void toBytes(TombstoneActivatedMessage msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.currentPos.m_121878_());
    }

    public static class Handler {
        static void handle(TombstoneActivatedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    MinecraftServer server;
                    ServerLevel world;
                    BlockState state;
                    Block block;
                    ServerPlayer player = ctx.getSender();
                    if (player != null && ModBlocks.isPlayerGrave(block = (state = (world = player.m_9236_()).m_8055_(message.currentPos)).m_60734_()) && (server = player.m_20194_()) != null && server.m_6982_() && server.m_7762_(world, message.currentPos, (Player)player)) {
                        block.m_6227_(state, (Level)world, message.currentPos, (Player)player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3((double)message.currentPos.m_123341_(), (double)message.currentPos.m_123342_(), (double)message.currentPos.m_123343_()), Direction.DOWN, message.currentPos, true));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

