/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.tombstone.enchantment.EnchantmentBlessing;
import ovh.corail.tombstone.enchantment.EnchantmentCurseOfBones;
import ovh.corail.tombstone.enchantment.EnchantmentFrostbite;
import ovh.corail.tombstone.enchantment.EnchantmentMagicSiphon;
import ovh.corail.tombstone.enchantment.EnchantmentPlagueBringer;
import ovh.corail.tombstone.enchantment.EnchantmentShadowStep;
import ovh.corail.tombstone.enchantment.EnchantmentSoulBound;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.Helper;

public final class ModEnchantments {
    public static TombstoneEnchantment shadow_step = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment soulbound = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment magic_siphon = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment plague_bringer = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment curse_of_bones = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment blessing = (TombstoneEnchantment)Helper.unsafeNullCast();
    public static TombstoneEnchantment frostbite = (TombstoneEnchantment)Helper.unsafeNullCast();
    private static final Map<String, TombstoneEnchantment> ENCHANTMENTS = new HashMap<String, TombstoneEnchantment>();

    static void onRegister(RegisterEvent event) {
        shadow_step = new EnchantmentShadowStep();
        ModEnchantments.registerEnchantment(event, shadow_step);
        soulbound = new EnchantmentSoulBound();
        ModEnchantments.registerEnchantment(event, soulbound);
        magic_siphon = new EnchantmentMagicSiphon();
        ModEnchantments.registerEnchantment(event, magic_siphon);
        plague_bringer = new EnchantmentPlagueBringer();
        ModEnchantments.registerEnchantment(event, plague_bringer);
        curse_of_bones = new EnchantmentCurseOfBones();
        ModEnchantments.registerEnchantment(event, curse_of_bones);
        blessing = new EnchantmentBlessing();
        ModEnchantments.registerEnchantment(event, blessing);
        frostbite = new EnchantmentFrostbite();
        ModEnchantments.registerEnchantment(event, frostbite);
    }

    private static void registerEnchantment(RegisterEvent event, TombstoneEnchantment enchantment) {
        ResourceLocation registryName = new ResourceLocation("tombstone", enchantment.getSimpleName());
        event.register(ForgeRegistries.Keys.ENCHANTMENTS, registryName, () -> enchantment);
        ENCHANTMENTS.put(registryName.toString(), enchantment);
    }

    public static Map<String, TombstoneEnchantment> getEnchantments() {
        return ENCHANTMENTS;
    }
}

