/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class BlockWritableGrave
extends BlockEntity {
    protected String ownerName = "";
    protected long deathDate;
    protected long deathMCTime = 0L;
    public int countTicks = 0;

    public BlockWritableGrave(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public abstract boolean canShowFog();

    public static void commonTick(Level level, BlockPos pos, BlockState state, BlockWritableGrave grave) {
        if (level.m_5776_() & grave.countTicks > 0) {
            if (grave.canShowFog()) {
                ModTombstone.PROXY.produceGraveSmoke(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5);
            }
        } else if (TimeHelper.isAprilFoolsDay() && TimeHelper.atInterval(grave.countTicks, 600) && Helper.RANDOM.nextFloat() < 0.3f) {
            Helper.handleAprilFoolsDayGrave(level, pos);
        }
        ++grave.countTicks;
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
        if (this.f_58857_ != null) {
            this.deathMCTime = TimeHelper.worldTicks(this.f_58857_);
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return !this.ownerName.isEmpty();
    }

    public long getDeathMCTime() {
        if (this.f_58857_ != null) {
            long worldTicks = TimeHelper.worldTicks(this.f_58857_);
            if (this.deathMCTime > worldTicks) {
                this.deathMCTime = worldTicks;
            }
            return worldTicks - this.deathMCTime;
        }
        return 0L;
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
        this.countTicks = 0;
        if (this.f_58857_ != null) {
            this.deathMCTime = TimeHelper.worldTicks(this.f_58857_);
        }
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public void m_183515_(CompoundTag compound) {
        this.writeShared(compound);
    }

    protected CompoundTag writeShared(CompoundTag compound) {
        compound.m_128359_("ownerName", this.ownerName);
        compound.m_128356_("deathDate", this.deathDate);
        compound.m_128356_("deathMCTime", this.deathMCTime);
        compound.m_128405_("countTicks", this.countTicks);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("ownerName", 8)) {
            this.ownerName = compound.m_128461_("ownerName");
        }
        if (compound.m_128425_("deathDate", 4)) {
            this.deathDate = compound.m_128454_("deathDate");
        }
        if (compound.m_128425_("deathMCTime", 4)) {
            this.deathMCTime = compound.m_128454_("deathMCTime");
        }
        if (compound.m_128425_("countTicks", 3)) {
            this.countTicks = compound.m_128451_("countTicks");
        }
    }

    public CompoundTag m_5995_() {
        return this.writeShared(new CompoundTag());
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_7531_(int id, int type) {
        return true;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1));
    }

    public boolean isPlayerGrave() {
        return false;
    }
}

