/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class InOpenWaterCondition
implements LootItemCondition {
    private static final InOpenWaterCondition INSTANCE = new InOpenWaterCondition();
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "in_open_water");
    public static final Serializer SERIALIZER = new Serializer();

    private InOpenWaterCondition() {
    }

    public LootItemConditionType m_7940_() {
        return ModLootFunctions.OPEN_WATER;
    }

    public boolean test(LootContext context) {
        return Optional.ofNullable((Entity)context.m_78953_(LootContextParams.f_81455_)).map(hook -> InOpenWaterCondition.isOpenWaterAround(hook.f_19853_, hook.m_20183_())).orElse(false);
    }

    private static boolean isOpenWater(Level level, BlockPos pos, boolean inStillWater) {
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = state.m_60819_();
        if (inStillWater) {
            return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && state.m_60734_() != Blocks.f_50628_ && Helper.hasNoCollision((BlockGetter)level, pos, state);
        }
        return state.m_60795_() || state.m_60734_() == Blocks.f_50196_ || Helper.hasNoCollision((BlockGetter)level, pos, state);
    }

    public static boolean isOpenWaterAround(Level level, BlockPos pos) {
        int inStillWater = pos.m_123342_();
        return SpawnHelper.getAllInBox(pos.m_7918_(-2, -2, -2), pos.m_7918_(2, 1, 2)).allMatch(aPos -> InOpenWaterCondition.isOpenWater(level, aPos, aPos.m_123342_() <= inStillWater));
    }

    public static LootItemCondition.Builder builder() {
        return () -> INSTANCE;
    }

    private static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<InOpenWaterCondition> {
        private Serializer() {
        }

        public void serialize(JsonObject json, InOpenWaterCondition condition, JsonSerializationContext context) {
        }

        public InOpenWaterCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

