/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleMagicCircle
extends CustomParticle {
    private static final Quaternionf QUATERNION_ONE = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/aura/aura1.png");
    private static final double HEIGHT = 0.1111;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleMagicCircle(ClientLevel level, CastingType castingType, LivingEntity entity, Predicate<LivingEntity> requireRemoval) {
        super(level, entity.m_20185_(), entity.m_20186_() + 0.1111, entity.m_20189_());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.requireRemoval = requireRemoval;
        this.m_6569_((float)(castingType.radius * 5.0));
        this.setRolling(0.0f, 0.009738938f);
        this.m_107253_(castingType.r, castingType.g, castingType.b);
        this.m_107271_(0.5f);
    }

    @Override
    protected void updatePosition() {
        Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).ifPresent(e -> this.m_107264_(e.m_20185_(), e.m_20186_() + 0.1111, e.m_20189_()));
    }

    @Override
    protected boolean requireRemoval() {
        return Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true);
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.f_107224_ > 1) {
            super.m_5744_(buffer, renderInfo, partialTicks);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }

    @Override
    protected Quaternionf getRollQuaternion(Camera renderInfo, float partialTicks) {
        if (this.f_107231_ == 0.0f) {
            return QUATERNION_ONE;
        }
        Quaternionf rollTransform = new Quaternionf((Quaternionfc)QUATERNION_ONE);
        rollTransform.mul((Quaternionfc)Axis.f_252436_.m_252961_(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_)));
        return rollTransform;
    }

    @Override
    protected Vector3f[] getFaceQuad() {
        return new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
    }

    @Override
    protected void addQuad(VertexConsumer buffer, Vector3f[] points, int light) {
        super.addQuad(buffer, points, light);
        super.addQuad(buffer, new Vector3f[]{points[3], points[2], points[1], points[0]}, light);
    }
}

