/*
 * Decompiled with CFR 0.152.
 */
package net.kings_of_devs.cozy_camping.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.kings_of_devs.cozy_camping.CozyCampingMain;
import net.kings_of_devs.cozy_camping.block.state.CozyCampProperties;
import net.kings_of_devs.cozy_camping.block.state.StumpShape;
import net.kings_of_devs.cozy_camping.entity.SeatEntity;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class StumpBlock
extends class_2248
implements class_3737 {
    public static final class_2754<StumpShape> SHAPE = CozyCampProperties.STUMP_SHAPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final Map<StumpShape, class_265> SHAPE_MAP = Maps.newHashMap();

    public StumpBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(SHAPE, (Comparable)((Object)StumpShape.VERTICAL)));
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_MAP.get(state.method_11654(SHAPE));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_5765() || player.method_7325() || !player.method_6047().method_7960()) {
                return class_1269.field_5814;
            }
            float posX = (float)pos.method_10263() + 0.5f;
            float posY = (float)pos.method_10264() + (state.method_11654(SHAPE) == StumpShape.VERTICAL ? 0.5f : 0.375f);
            float posZ = (float)pos.method_10260() + 0.5f;
            List active = world.method_18467(SeatEntity.class, new class_238(pos));
            if (!active.isEmpty()) {
                return class_1269.field_5814;
            }
            float yaw = player.method_5735().method_10144();
            SeatEntity entity = (SeatEntity)CozyCampingMain.SEAT.method_5883(world);
            entity.method_5641(posX, posY, posZ, yaw, 0.0f);
            entity.method_5875(true);
            entity.method_5803(true);
            entity.method_5648(true);
            entity.method_5847(yaw);
            entity.method_5636(yaw);
            if (world.method_8649((class_1297)entity)) {
                player.method_5873((class_1297)entity, true);
                player.method_5636(yaw);
                player.method_5847(yaw);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166() == ((StumpShape)((Object)state.method_11654(SHAPE))).getAxis()) {
            return this.getPlacementState(state, world, pos, direction);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState(this.method_9564(), (class_1936)ctx.method_8045(), ctx.method_8037(), ctx.method_8038());
    }

    private class_2680 getPlacementState(class_2680 state, class_1936 world, class_2338 pos, class_2350 direction) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2680 positiveState = world.method_8320(pos.method_10093(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis)));
        class_2680 negativeState = world.method_8320(pos.method_10093(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis)));
        boolean connectsOnPos = positiveState.method_26204() instanceof StumpBlock && ((StumpShape)((Object)positiveState.method_11654(SHAPE))).getAxis() == axis;
        boolean connectsOnNeg = negativeState.method_26204() instanceof StumpBlock && ((StumpShape)((Object)negativeState.method_11654(SHAPE))).getAxis() == axis;
        StumpShape side = this.determineSide(state, axis, connectsOnPos, connectsOnNeg);
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)side));
    }

    private StumpShape determineSide(class_2680 state, class_2350.class_2351 axis, boolean hasPositive, boolean hasNegative) {
        int checkNegative = hasNegative ? 7 : 1;
        int checkPositive = hasPositive ? 5 : checkNegative;
        int side = hasPositive && hasNegative ? 3 : checkPositive;
        switch (axis) {
            case field_11048: {
                side *= 2;
                break;
            }
            case field_11051: {
                side *= 4;
            }
        }
        return StumpShape.SHAPE_MAP.get(side) != null ? StumpShape.SHAPE_MAP.get(side) : (StumpShape)((Object)state.method_11654(SHAPE));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE, WATERLOGGED});
    }

    static {
        SHAPE_MAP.put(StumpShape.VERTICAL, class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0));
        SHAPE_MAP.put(StumpShape.X_POSITIVE, class_2248.method_9541((double)4.0, (double)0.0, (double)3.0, (double)16.0, (double)10.0, (double)13.0));
        SHAPE_MAP.put(StumpShape.X_NEGATIVE, class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0));
        SHAPE_MAP.put(StumpShape.X_CENTERED, class_2248.method_9541((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)10.0, (double)13.0));
        SHAPE_MAP.put(StumpShape.X_CENTERED_LARGE, class_259.method_1084((class_265)SHAPE_MAP.get((Object)StumpShape.X_POSITIVE), (class_265)SHAPE_MAP.get((Object)StumpShape.X_NEGATIVE)));
        SHAPE_MAP.put(StumpShape.Z_POSITIVE, class_2248.method_9541((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)10.0, (double)16.0));
        SHAPE_MAP.put(StumpShape.Z_NEGATIVE, class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)10.0, (double)12.0));
        SHAPE_MAP.put(StumpShape.Z_CENTERED, class_2248.method_9541((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)10.0, (double)14.0));
        SHAPE_MAP.put(StumpShape.Z_CENTERED_LARGE, class_259.method_1084((class_265)SHAPE_MAP.get((Object)StumpShape.Z_POSITIVE), (class_265)SHAPE_MAP.get((Object)StumpShape.Z_NEGATIVE)));
    }
}

