/*
 * Decompiled with CFR 0.152.
 */
package net.kings_of_devs.cozy_camping.block;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.kings_of_devs.cozy_camping.block.BlockRegistry;
import net.kings_of_devs.cozy_camping.block.BlockUtils;
import net.kings_of_devs.cozy_camping.block.entity.TentBlockEntity;
import net.kings_of_devs.cozy_camping.block.state.CozyCampProperties;
import net.kings_of_devs.cozy_camping.block.state.TentPiece;
import net.kings_of_devs.cozy_camping.util.PlayerEntityDuck;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class TentBlock
extends class_2237 {
    private static final class_265 NORTH_SHAPE;
    private static final class_265 SOUTH_SHAPE;
    private static final class_265 EAST_SHAPE;
    private static final class_265 WEST_SHAPE;
    private static final class_265 NORTH_COLLISION_SHAPE;
    private static final class_265 SOUTH_COLLISION_SHAPE;
    private static final class_265 EAST_COLLISION_SHAPE;
    private static final class_265 WEST_COLLISION_SHAPE;
    private static final class_265 UPPER_NORTH_SHAPE;
    private static final class_265 UPPER_SOUTH_SHAPE;
    private static final class_265 UPPER_EAST_SHAPE;
    private static final class_265 UPPER_WEST_SHAPE;
    private static final class_265 UPPER_NORTH_EAST_SHAPE;
    private static final class_265 UPPER_NORTH_WEST_SHAPE;
    private static final class_265 UPPER_SOUTH_EAST_SHAPE;
    private static final class_265 UPPER_SOUTH_WEST_SHAPE;
    public static final class_2753 FACING;
    public static final class_2754<class_2756> HALF;
    public static final class_2754<TentPiece> PIECE;
    public static final class_2746 LEFT_OCCUPIED;
    public static final class_2746 RIGHT_OCCUPIED;
    public static final class_2746 HAS_LEFT_BAG;
    public static final class_2746 HAS_RIGHT_BAG;
    private final class_1767 color;

    public TentBlock(class_1767 color, class_4970.class_2251 settings) {
        super(settings);
        this.color = color;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657(PIECE, (Comparable)((Object)TentPiece.CENTER))).method_11657((class_2769)LEFT_OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RIGHT_OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_LEFT_BAG, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_RIGHT_BAG, (Comparable)Boolean.valueOf(false)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(PIECE) == TentPiece.CENTER && state.method_11654(HALF) == class_2756.field_12607) {
            return new TentBlockEntity(pos, state, this.color);
        }
        return null;
    }

    @Nullable
    public static class_2350 getDirection(class_1922 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof TentBlock ? ((class_2350)state.method_11654((class_2769)FACING)).method_10153() : null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        AtomicReference<class_1269> actionResult = new AtomicReference<class_1269>();
        if (world.field_9236) {
            actionResult.set(class_1269.field_21466);
        } else if (player.method_6047().method_31574(BlockRegistry.SLEEPING_BAG.method_8389())) {
            actionResult.set(class_1269.field_5811);
        } else {
            this.loopThroughSlice(state, (x, z) -> {
                class_2338 newPos = pos.method_30513(class_2350.class_2351.field_11048, x.intValue()).method_30513(class_2350.class_2351.field_11051, z.intValue());
                class_2680 foundState = world.method_8320(newPos);
                if (foundState.method_27852(this.method_26160()) && foundState.method_11654(PIECE) == TentPiece.CENTER) {
                    class_2338 class_23382 = newPos = foundState.method_11654(HALF) == class_2756.field_12607 ? newPos : newPos.method_10074();
                    if (!world.method_8597().method_29956()) {
                        player.method_7353((class_2561)new class_2588("block.cozy_camping.tent.cannot_use"), true);
                        actionResult.set(class_1269.field_5811);
                    } else {
                        PlayerEntityDuck playerDuck = (PlayerEntityDuck)player;
                        if (((Boolean)state.method_11654((class_2769)LEFT_OCCUPIED)).booleanValue() && ((Boolean)state.method_11654((class_2769)RIGHT_OCCUPIED)).booleanValue()) {
                            player.method_7353((class_2561)new class_2588("block.cozy_camping.tent.full"), true);
                            actionResult.set(class_1269.field_5811);
                        } else {
                            playerDuck.sleepFromTent(newPos, (Boolean)state.method_11654((class_2769)LEFT_OCCUPIED) == false);
                            actionResult.set(class_1269.field_5812);
                        }
                    }
                }
            }, false);
        }
        actionResult.set(class_1269.field_5811);
        return (class_1269)actionResult.get();
    }

    public class_1767 getColor() {
        return this.color;
    }

    private void loopThroughSlice(class_2680 state, BiConsumer<Integer, Integer> consumer, boolean includeLowestEnds) {
        int minZ;
        int maxX;
        int minX;
        boolean isFacingZ;
        boolean bl = isFacingZ = ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11051;
        int n = includeLowestEnds ? -1 : (minX = isFacingZ ? -2 : -1);
        int n2 = includeLowestEnds ? 1 : (maxX = isFacingZ ? 2 : 1);
        int n3 = includeLowestEnds ? -1 : (minZ = isFacingZ ? -1 : -2);
        int maxZ = includeLowestEnds ? 1 : (isFacingZ ? 1 : 2);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                consumer.accept(x, z);
            }
        }
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        float value = 1.0f;
        if (state.method_11654(HALF) == class_2756.field_12607 && state.method_11654(PIECE) == TentPiece.CENTER) {
            value = 0.125f;
        }
        return value;
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2680 upperHalf = (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609);
        world.method_8652(pos.method_10084(), upperHalf, 3);
        world.method_8652(pos.method_10084().method_10095(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH)), 3);
        world.method_8652(pos.method_10084().method_10072(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH)), 3);
        world.method_8652(pos.method_10084().method_10078(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.EAST)), 3);
        world.method_8652(pos.method_10084().method_10067(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.WEST)), 3);
        world.method_8652(pos.method_10084().method_10095().method_10078(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_EAST)), 3);
        world.method_8652(pos.method_10084().method_10095().method_10067(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_WEST)), 3);
        world.method_8652(pos.method_10084().method_10072().method_10078(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_EAST)), 3);
        world.method_8652(pos.method_10084().method_10072().method_10067(), (class_2680)upperHalf.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_WEST)), 3);
        world.method_8652(pos.method_10095(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH)), 3);
        world.method_8652(pos.method_10072(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH)), 3);
        world.method_8652(pos.method_10078(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.EAST)), 3);
        world.method_8652(pos.method_10067(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.WEST)), 3);
        world.method_8652(pos.method_10095().method_10078(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_EAST)), 3);
        world.method_8652(pos.method_10095().method_10067(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_WEST)), 3);
        world.method_8652(pos.method_10072().method_10078(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_EAST)), 3);
        world.method_8652(pos.method_10072().method_10067(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_WEST)), 3);
        this.placeLowestEnds(world, pos, state);
    }

    private void placeLowestEnds(class_1937 world, class_2338 pos, class_2680 state) {
        switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case field_11043: 
            case field_11035: {
                world.method_8652(pos.method_10089(2), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.EAST_LOWEST)), 3);
                world.method_8652(pos.method_10089(2).method_10095(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_EAST_LOWEST)), 3);
                world.method_8652(pos.method_10089(2).method_10072(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_EAST_LOWEST)), 3);
                world.method_8652(pos.method_10088(2), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.WEST_LOWEST)), 3);
                world.method_8652(pos.method_10088(2).method_10095(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_WEST_LOWEST)), 3);
                world.method_8652(pos.method_10088(2).method_10072(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_WEST_LOWEST)), 3);
                break;
            }
            case field_11034: 
            case field_11039: {
                world.method_8652(pos.method_10076(2), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_LOWEST)), 3);
                world.method_8652(pos.method_10076(2).method_10078(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_EAST_LOWEST)), 3);
                world.method_8652(pos.method_10076(2).method_10067(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.NORTH_WEST_LOWEST)), 3);
                world.method_8652(pos.method_10077(2), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_LOWEST)), 3);
                world.method_8652(pos.method_10077(2).method_10078(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_EAST_LOWEST)), 3);
                world.method_8652(pos.method_10077(2).method_10067(), (class_2680)state.method_11657(PIECE, (Comparable)((Object)TentPiece.SOUTH_WEST_LOWEST)), 3);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (state.method_11654(HALF) == class_2756.field_12607 && !world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036)) {
            world.method_8651(pos, true, null);
            this.tryBreak(world, pos, state, null);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        AtomicBoolean canPlace = new AtomicBoolean(true);
        this.loopThroughSlice(state, (x, z) -> {
            class_2338 newPos = pos.method_30513(class_2350.class_2351.field_11048, x.intValue()).method_30513(class_2350.class_2351.field_11051, z.intValue());
            class_2680 downState = world.method_8320(newPos.method_10074());
            if (!world.method_8320(newPos).method_26215()) {
                canPlace.set(false);
            }
            if (!downState.method_26206((class_1922)world, newPos.method_10074(), class_2350.field_11036) && !downState.method_27852(this.method_26160())) {
                canPlace.set(false);
            }
        }, false);
        this.loopThroughSlice(state, (x, z) -> {
            class_2338 newPos = pos.method_30513(class_2350.class_2351.field_11048, x.intValue()).method_30513(class_2350.class_2351.field_11051, z.intValue());
            if (!world.method_8320(newPos.method_10084()).method_26215()) {
                canPlace.set(false);
            }
        }, true);
        return canPlace.get();
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.tryBreak(world, pos, state, player);
        super.method_9576(world, pos, state, player);
    }

    private void tryBreak(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2350 half = state.method_11654(HALF) == class_2756.field_12609 ? class_2350.field_11033 : class_2350.field_11036;
        switch ((TentPiece)((Object)state.method_11654(PIECE))) {
            case CENTER: {
                this.breakFromMiddle(state, half, world, pos, player);
                break;
            }
            case NORTH_LOWEST: {
                this.breakFromLowestSide(world, pos, player, class_2350.field_11035, TentPiece.NORTH);
                break;
            }
            case SOUTH_LOWEST: {
                this.breakFromLowestSide(world, pos, player, class_2350.field_11043, TentPiece.SOUTH);
                break;
            }
            case EAST_LOWEST: {
                this.breakFromLowestSide(world, pos, player, class_2350.field_11039, TentPiece.EAST);
                break;
            }
            case WEST_LOWEST: {
                this.breakFromLowestSide(world, pos, player, class_2350.field_11034, TentPiece.WEST);
                break;
            }
            case NORTH_EAST_LOWEST: {
                this.breakFromLowestCorner(world, pos, player, class_2350.field_11039, class_2350.field_11035, TentPiece.NORTH_EAST);
                break;
            }
            case NORTH_WEST_LOWEST: {
                this.breakFromLowestCorner(world, pos, player, class_2350.field_11034, class_2350.field_11035, TentPiece.NORTH_WEST);
                break;
            }
            case SOUTH_EAST_LOWEST: {
                this.breakFromLowestCorner(world, pos, player, class_2350.field_11039, class_2350.field_11043, TentPiece.SOUTH_EAST);
                break;
            }
            case SOUTH_WEST_LOWEST: {
                this.breakFromLowestCorner(world, pos, player, class_2350.field_11034, class_2350.field_11043, TentPiece.SOUTH_WEST);
                break;
            }
            default: {
                this.checkBlocksAroundAndTryBreak(state, pos, world, player);
            }
        }
    }

    private void breakFromLowestCorner(class_1937 world, class_2338 pos, class_1657 player, class_2350 directionX, class_2350 directionZ, TentPiece piece) {
        this.breakFromLowestSide(world, pos, player, directionZ, piece);
        this.breakFromLowestSide(world, pos, player, directionX, piece);
    }

    private void breakFromLowestSide(class_1937 world, class_2338 pos, class_1657 player, class_2350 direction, TentPiece piece) {
        class_2338 posToCheck = pos.method_10093(direction);
        class_2680 stateToCheck = world.method_8320(posToCheck);
        if (stateToCheck.method_27852(this.method_26160()) && stateToCheck.method_11654(PIECE) == piece) {
            this.checkBlocksAroundAndTryBreak(stateToCheck, posToCheck, world, player);
        }
    }

    private void checkBlocksAroundAndTryBreak(class_2680 state, class_2338 pos, class_1937 world, class_1657 player) {
        this.loopThroughSlice(state, (x, z) -> {
            class_2338 newPos = pos.method_30513(class_2350.class_2351.field_11048, x.intValue()).method_30513(class_2350.class_2351.field_11051, z.intValue());
            class_2680 foundState = world.method_8320(newPos);
            if (foundState.method_27852(this.method_26160()) && foundState.method_11654(PIECE) == TentPiece.CENTER) {
                class_2350 half = foundState.method_11654(HALF) == class_2756.field_12609 ? class_2350.field_11033 : class_2350.field_11036;
                this.breakFromMiddle(state, half, world, newPos, player);
            }
        }, true);
    }

    private void breakFromMiddle(class_2680 state, class_2350 half, class_1937 world, class_2338 pos, class_1657 player) {
        boolean canLoot = player == null || !player.method_7337();
        class_2338 basePos = pos.method_10093(half);
        this.loopThroughSlice(state, (x, z) -> {
            class_2338 newPos = basePos.method_30513(class_2350.class_2351.field_11048, x.intValue()).method_30513(class_2350.class_2351.field_11051, z.intValue());
            if (world.method_8320(newPos).method_27852(this.method_26160())) {
                BlockUtils.breakBlockSilent(world, newPos, canLoot, (class_1297)player);
            }
            if (world.method_8320(newPos.method_10093(half.method_10153())).method_27852(this.method_26160())) {
                BlockUtils.breakBlockSilent(world, newPos.method_10093(half.method_10153()), canLoot, (class_1297)player);
            }
        }, false);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 defaultShape = switch ((TentPiece)((Object)state.method_11654(PIECE))) {
            case TentPiece.NORTH_LOWEST -> UPPER_NORTH_SHAPE;
            case TentPiece.SOUTH_LOWEST -> UPPER_SOUTH_SHAPE;
            case TentPiece.EAST_LOWEST -> UPPER_EAST_SHAPE;
            case TentPiece.WEST_LOWEST -> UPPER_WEST_SHAPE;
            case TentPiece.NORTH_EAST_LOWEST -> UPPER_NORTH_EAST_SHAPE;
            case TentPiece.NORTH_WEST_LOWEST -> UPPER_NORTH_WEST_SHAPE;
            case TentPiece.SOUTH_EAST_LOWEST -> UPPER_SOUTH_EAST_SHAPE;
            case TentPiece.SOUTH_WEST_LOWEST -> UPPER_SOUTH_WEST_SHAPE;
            default -> super.method_9530(state, world, pos, context);
        };
        boolean isUpper = state.method_11654(HALF) == class_2756.field_12609;
        class_265 northShape = isUpper ? UPPER_NORTH_SHAPE : defaultShape;
        class_265 southShape = isUpper ? UPPER_SOUTH_SHAPE : defaultShape;
        class_265 eastShape = isUpper ? UPPER_EAST_SHAPE : defaultShape;
        class_265 westShape = isUpper ? UPPER_WEST_SHAPE : defaultShape;
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11043, class_2350.field_11035 -> this.getShapeForPiece(state, defaultShape, NORTH_SHAPE, SOUTH_SHAPE, eastShape, westShape);
            case class_2350.field_11034, class_2350.field_11039 -> this.getShapeForPiece(state, defaultShape, northShape, southShape, EAST_SHAPE, WEST_SHAPE);
            case class_2350.field_11036, class_2350.field_11033 -> defaultShape;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 westShapeX;
        boolean isUpper = state.method_11654(HALF) == class_2756.field_12609;
        class_265 centerShape = isUpper ? class_259.method_1084((class_265)NORTH_COLLISION_SHAPE, (class_265)SOUTH_COLLISION_SHAPE) : class_259.method_1073();
        class_265 defaultShape = switch ((TentPiece)((Object)state.method_11654(PIECE))) {
            case TentPiece.NORTH_LOWEST -> UPPER_NORTH_SHAPE;
            case TentPiece.SOUTH_LOWEST -> UPPER_SOUTH_SHAPE;
            case TentPiece.EAST_LOWEST -> UPPER_EAST_SHAPE;
            case TentPiece.WEST_LOWEST -> UPPER_WEST_SHAPE;
            case TentPiece.NORTH_EAST_LOWEST -> UPPER_NORTH_EAST_SHAPE;
            case TentPiece.NORTH_WEST_LOWEST -> UPPER_NORTH_WEST_SHAPE;
            case TentPiece.SOUTH_EAST_LOWEST -> UPPER_SOUTH_EAST_SHAPE;
            case TentPiece.SOUTH_WEST_LOWEST -> UPPER_SOUTH_WEST_SHAPE;
            default -> super.method_9530(state, world, pos, context);
        };
        class_265 northShapeX = isUpper ? UPPER_NORTH_SHAPE : defaultShape;
        class_265 southShapeX = isUpper ? UPPER_SOUTH_SHAPE : defaultShape;
        class_265 eastShapeZ = isUpper ? UPPER_EAST_SHAPE : defaultShape;
        class_265 westShapeZ = isUpper ? UPPER_WEST_SHAPE : defaultShape;
        class_265 northShapeZ = isUpper ? NORTH_COLLISION_SHAPE : class_259.method_1073();
        class_265 southShapeZ = isUpper ? SOUTH_COLLISION_SHAPE : class_259.method_1073();
        class_265 eastShapeX = isUpper ? EAST_COLLISION_SHAPE : class_259.method_1073();
        class_265 class_2652 = westShapeX = isUpper ? WEST_COLLISION_SHAPE : class_259.method_1073();
        if (state.method_11654(PIECE) != TentPiece.CENTER) {
            return switch (((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
                case class_2350.class_2351.field_11051 -> this.getShapeForPiece(state, defaultShape, northShapeZ, southShapeZ, eastShapeZ, westShapeZ);
                case class_2350.class_2351.field_11048 -> this.getShapeForPiece(state, defaultShape, northShapeX, southShapeX, eastShapeX, westShapeX);
                case class_2350.class_2351.field_11052 -> defaultShape;
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return centerShape;
    }

    private class_265 getShapeForPiece(class_2680 state, class_265 defaultShape, class_265 north, class_265 south, class_265 east, class_265 west) {
        return switch ((TentPiece)((Object)state.method_11654(PIECE))) {
            case TentPiece.NORTH -> north;
            case TentPiece.SOUTH -> south;
            case TentPiece.EAST -> east;
            case TentPiece.WEST -> west;
            case TentPiece.NORTH_EAST -> this.getCornerOutline(state, defaultShape, UPPER_NORTH_EAST_SHAPE, NORTH_SHAPE, EAST_SHAPE);
            case TentPiece.NORTH_WEST -> this.getCornerOutline(state, defaultShape, UPPER_NORTH_WEST_SHAPE, NORTH_SHAPE, WEST_SHAPE);
            case TentPiece.SOUTH_EAST -> this.getCornerOutline(state, defaultShape, UPPER_SOUTH_EAST_SHAPE, SOUTH_SHAPE, EAST_SHAPE);
            case TentPiece.SOUTH_WEST -> this.getCornerOutline(state, defaultShape, UPPER_SOUTH_WEST_SHAPE, SOUTH_SHAPE, WEST_SHAPE);
            default -> defaultShape;
        };
    }

    private class_265 getCornerOutline(class_2680 state, class_265 defaultShape, class_265 upperShape, class_265 lowerShapeOnZ, class_265 lowerShapeOnX) {
        boolean isUpper = state.method_11654(HALF) == class_2756.field_12609;
        return switch (((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
            case class_2350.class_2351.field_11051 -> {
                if (isUpper) {
                    yield upperShape;
                }
                yield lowerShapeOnZ;
            }
            case class_2350.class_2351.field_11048 -> {
                if (isUpper) {
                    yield upperShape;
                }
                yield lowerShapeOnX;
            }
            default -> defaultShape;
        };
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, HALF, PIECE, LEFT_OCCUPIED, RIGHT_OCCUPIED, HAS_LEFT_BAG, HAS_RIGHT_BAG});
    }

    static {
        HALF = class_2741.field_12533;
        FACING = class_2741.field_12481;
        PIECE = CozyCampProperties.TENT_PIECE;
        LEFT_OCCUPIED = CozyCampProperties.LEFT_OCCUPIED;
        RIGHT_OCCUPIED = CozyCampProperties.RIGHT_OCCUPIED;
        HAS_LEFT_BAG = CozyCampProperties.HAS_LEFT_BAG;
        HAS_RIGHT_BAG = CozyCampProperties.HAS_RIGHT_BAG;
        UPPER_NORTH_EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
        UPPER_NORTH_WEST_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
        UPPER_SOUTH_EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
        UPPER_SOUTH_WEST_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        UPPER_NORTH_SHAPE = class_259.method_1084((class_265)UPPER_NORTH_EAST_SHAPE, (class_265)UPPER_NORTH_WEST_SHAPE);
        UPPER_SOUTH_SHAPE = class_259.method_1084((class_265)UPPER_SOUTH_EAST_SHAPE, (class_265)UPPER_SOUTH_WEST_SHAPE);
        UPPER_EAST_SHAPE = class_259.method_1084((class_265)UPPER_NORTH_EAST_SHAPE, (class_265)UPPER_SOUTH_EAST_SHAPE);
        UPPER_WEST_SHAPE = class_259.method_1084((class_265)UPPER_NORTH_WEST_SHAPE, (class_265)UPPER_SOUTH_WEST_SHAPE);
        NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        WEST_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        EAST_COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        WEST_COLLISION_SHAPE = class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

