/*
 * Decompiled with CFR 0.152.
 */
package net.kings_of_devs.cozy_camping.datagen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kings_of_devs.cozy_camping.CozyCampingMain;
import net.kings_of_devs.cozy_camping.mixin.accessor.ShapedRecipeAccessor;
import net.kings_of_devs.cozy_camping.util.Utils;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeDatagen {
    private static final Map<class_3956<?>, List<class_1860<?>>> RECIPES = new Object2ObjectOpenHashMap();
    private static final Map<class_1860<?>, String> RECIPES_CATEGORIES = new Object2ObjectOpenHashMap();
    private static final Map<class_2960, class_161.class_162> RECIPE_ADVANCEMENTS = new Object2ObjectOpenHashMap();
    public static final Logger LOGGER = LogManager.getLogger((String)"Cozy Camping Datagen Recipes");

    public static void applyAdvancements(Map<class_2960, class_161.class_162> builder) {
        RECIPE_ADVANCEMENTS.forEach((identifier, task) -> {
            task.method_701((class_161)null);
            builder.put((class_2960)identifier, (class_161.class_162)task);
        });
    }

    public static void applyRecipes(Map<class_2960, JsonElement> map, Map<class_3956<?>, ImmutableMap.Builder<class_2960, class_1860<?>>> builderMap) {
        int[] recipeCount = new int[]{0};
        RECIPES.forEach((key, recipes) -> {
            ImmutableMap.Builder recipeBuilder = builderMap.computeIfAbsent((class_3956<?>)key, o -> ImmutableMap.builder());
            recipes.forEach(recipe -> {
                if (!map.containsKey(recipe.method_8114())) {
                    recipeBuilder.put((Object)recipe.method_8114(), recipe);
                    recipeCount[0] = recipeCount[0] + 1;
                }
            });
        });
        LOGGER.info("Loaded {} additional recipe" + (recipeCount[0] > 1 ? "s" : ""), (Object)recipeCount[0]);
    }

    public static void registerRecipe(class_1860<?> recipe, String category) {
        List recipes = RECIPES.computeIfAbsent(recipe.method_17716(), recipeType -> new ArrayList());
        for (class_1860 currentRecipe : recipes) {
            if (!currentRecipe.method_8114().equals((Object)recipe.method_8114())) continue;
            return;
        }
        recipes.add(recipe);
        RECIPES_CATEGORIES.put(recipe, category);
        String advancementIdPath = "recipes/" + category + "/" + recipe.method_8114().method_12832();
        class_2960 advancementId = new class_2960(recipe.method_8114().method_12836(), advancementIdPath);
        RECIPE_ADVANCEMENTS.put(advancementId, RecipeDatagen.simpleRecipeUnlock(recipe));
    }

    public static void registerRecipes(List<class_1860<?>> recipes, String category) {
        for (class_1860<?> recipe : recipes) {
            RecipeDatagen.registerRecipe(recipe, category);
        }
    }

    public static class_161.class_162 simpleRecipeUnlock(class_1860<?> recipe) {
        class_161.class_162 advancement = class_161.class_162.method_707();
        advancement.method_708(new class_2960("recipes/root"));
        advancement.method_703(class_170.class_171.method_753((class_2960)recipe.method_8114()));
        advancement.method_704(class_193.field_1257);
        advancement.method_709("has_self", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{recipe.method_8110().method_7909()}));
        advancement.method_709("has_the_recipe", (class_184)new class_2119.class_2121(class_2048.class_5258.field_24388, recipe.method_8114()));
        ArrayList ingredients = Lists.newArrayList();
        for (class_1856 ingredient : recipe.method_8117()) {
            if (ingredient.method_8103()) continue;
            Set items = ingredient.method_8089().getAsJsonObject().entrySet();
            for (Map.Entry item : items) {
                class_2960 ingredientId = new class_2960(((JsonElement)item.getValue()).getAsString());
                if (ingredients.contains(ingredientId)) continue;
                advancement.method_709("has_" + ingredientId.method_12832(), (class_184)RecipeDatagen.inventoryChangedCriteria(ingredient));
                ingredients.add(ingredientId);
            }
        }
        return advancement;
    }

    public static class_2066.class_2068 inventoryChangedCriteria(class_1856 item) {
        JsonArray ingredients = new JsonArray();
        JsonElement ingredient = item.method_8089();
        JsonElement jsonElement = ingredient;
        if (jsonElement instanceof JsonObject) {
            JsonObject json = (JsonObject)jsonElement;
            if (json.has("item")) {
                JsonObject child = new JsonObject();
                child.add("items", (JsonElement)Utils.jsonArray(class_3518.method_15265((JsonObject)json, (String)"item")));
                ingredients.add((JsonElement)child);
            } else {
                ingredients.add(ingredient);
            }
        }
        class_2048.class_5258 entityPredicate = class_2048.class_5258.field_24388;
        class_2096.class_2100 intRange = class_2096.class_2100.field_9708;
        class_2073[] items = class_2073.method_8972((JsonElement)ingredients);
        return new class_2066.class_2068(entityPredicate, intRange, intRange, intRange, items);
    }

    public static class_1860<?> shapedRecipe(class_2960 recipeId, String group, String[] pattern, Multimap<Character, class_1856> keys, class_1935 output, int count) {
        HashMap keyMap = Maps.newHashMap();
        class_1799 outStack = class_1799.field_8037;
        for (Map.Entry pair : keys.entries()) {
            keyMap.put(((Character)pair.getKey()).toString(), (class_1856)pair.getValue());
        }
        int x = pattern[0].length();
        int y = pattern.length;
        class_2371<class_1856> ingredients = ShapedRecipeAccessor.createPatternMatrix(pattern, keyMap, x, y);
        outStack = new class_1799(output);
        outStack.method_7939(count);
        return new class_1869(recipeId, group, x, y, ingredients, outStack);
    }

    public static class_1860<?> shapelessRecipe(class_2960 recipeId, String group, List<class_1935> input, class_1935 output, int count) {
        class_2371 ingredients = class_2371.method_10211();
        class_1799 outStack = class_1799.field_8037;
        for (class_1935 item : input) {
            ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        outStack = new class_1799(output);
        outStack.method_7939(count);
        return new class_1867(recipeId, group, new class_1799(output), ingredients);
    }

    public static void test() {
        class_2960 recipeId = CozyCampingMain.id("testo");
        HashMultimap keys = HashMultimap.create();
        keys.put((Object)Character.valueOf('X'), (Object)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8820}));
        keys.put((Object)Character.valueOf('E'), (Object)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8229}));
        class_1860<?> test = RecipeDatagen.shapedRecipe(recipeId, "", new String[]{"XX", "E", "E"}, (Multimap<Character, class_1856>)keys, (class_1935)class_1802.field_27064, 1);
        RecipeDatagen.registerRecipe(test, "aaa");
    }

    public static class_1860<?> stonecuttingRecipe(class_2960 recipeId, String group, class_1856 input, class_1935 output, int count) {
        class_1799 outStack = class_1799.field_8037;
        outStack = new class_1799(output);
        outStack.method_7939(count);
        return new class_3975(recipeId, group, input, outStack);
    }

    public static class_1860<?> smeltingRecipe(class_2960 recipeId, String group, class_1856 input, class_1935 output, float exp, int cookTime) {
        return new class_3861(recipeId, group, input, new class_1799(output), exp, cookTime);
    }
}

