/*
 * Decompiled with CFR 0.152.
 */
package net.kings_of_devs.cozy_camping.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import net.kings_of_devs.cozy_camping.CozyCampingMain;
import net.kings_of_devs.cozy_camping.block.state.TentPiece;
import net.kings_of_devs.cozy_camping.dev.ModelMethods;
import net.minecraft.class_1767;
import net.minecraft.class_310;

public class AutoJsonWriter {
    public void write(String fileName, JsonObject jsonObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        class_310 client = class_310.method_1551();
        File file = new File(client.field_1697, "cozy_camping_dev_output/" + fileName + ".json");
        if (file.getParentFile().mkdirs()) {
            CozyCampingMain.LOGGER.info(file.getParentFile().getAbsolutePath() + " folders created.");
        }
        try {
            if (file.createNewFile()) {
                CozyCampingMain.LOGGER.info(file.getName() + " created.");
            }
        }
        catch (IOException e) {
            CozyCampingMain.LOGGER.info("Failed to create " + file.getName());
            e.printStackTrace();
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(gson.toJson((JsonElement)jsonObject));
            writer.close();
            CozyCampingMain.LOGGER.info("Successfully wrote to " + file.getName());
        }
        catch (IOException e) {
            CozyCampingMain.LOGGER.info("An error occurred writing to " + file.getName());
            e.printStackTrace();
        }
    }

    private static void writeTents(boolean ripped) {
        AutoJsonWriter writer = new AutoJsonWriter();
        String modelsFolder = "models/block/tent/";
        for (class_1767 color : class_1767.values()) {
            for (TentPiece piece : TentPiece.values()) {
                String root = "cozy_camping:block/tent/";
                String name = ripped ? "ripped_tent" : "tent";
                Map<String, String> texture = Map.ofEntries(Map.entry("texture", "cozy_camping:block/" + color + "_" + name));
                if (piece.method_15434().contains("lowest")) {
                    String newPiece = piece.method_15434().replace("_lowest", "");
                    String parent = root + "template_tent_lowest_lower_" + newPiece;
                    JsonObject model = ModelMethods.modelFromParent(parent, texture);
                    writer.write(modelsFolder + color.method_7792() + "_" + name + "_lowest_lower_" + newPiece, model);
                    continue;
                }
                JsonObject lowerModel = ModelMethods.modelFromParent(root + "template_tent_lower_" + piece.method_15434(), texture);
                JsonObject upperModel = ModelMethods.modelFromParent(root + "template_tent_upper_" + piece.method_15434(), texture);
                writer.write(modelsFolder + color.method_7792() + "_" + name + "_lower_" + piece.method_15434(), lowerModel);
                writer.write(modelsFolder + color.method_7792() + "_" + name + "_upper_" + piece.method_15434(), upperModel);
            }
        }
    }

    private static void writeTentItems(boolean ripped) {
        AutoJsonWriter writer = new AutoJsonWriter();
        String modelsFolder = "models/item/";
        for (class_1767 color : class_1767.values()) {
            String name = ripped ? "ripped_tent" : "tent";
            Map<String, String> texture = Map.ofEntries(Map.entry("layer0", "cozy_camping:item/" + color + "_" + name));
            JsonObject model = ModelMethods.modelFromParent("item/generated", texture);
            writer.write(modelsFolder + color.method_7792() + "_" + name, model);
        }
    }

    public static void writeAll() {
        AutoJsonWriter.writeTents(false);
        AutoJsonWriter.writeTents(true);
        AutoJsonWriter.writeTentItems(false);
        AutoJsonWriter.writeTentItems(true);
        CozyCampingMain.LOGGER.info("JSON files successfully written");
    }
}

