/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lolcroc.craftingautomat.CraftingAutomatTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class CraftingAutomatBlock
extends Block {
    public static final String NAME = "autocrafter";
    @CapabilityInject(value=IItemHandler.class)
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("craftingautomat", "autocrafter");
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public CraftingAutomatBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(3.5f));
        this.setRegistryName(REGISTRY_NAME);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ACTIVE, (Comparable)Boolean.FALSE)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ACTIVE, TRIGGERED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new CraftingAutomatTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (stack.func_82837_s()) {
            CraftingAutomatBlock.safeConsume(worldIn, pos, t -> t.setCustomName(stack.func_200301_q()));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            CraftingAutomatBlock.safeConsume(worldIn, pos, t -> {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)t, (BlockPos)pos);
                player.func_195066_a(Stats.field_188062_ab);
            });
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CraftingAutomatBlock.safeConsume(world, pos, t -> {
            boolean pow = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
            boolean triggered = (Boolean)state.func_177229_b((Property)TRIGGERED);
            if (pow && !triggered) {
                BlockState newstate = (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.TRUE);
                if (!((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
                    newstate = (BlockState)newstate.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(t.isReady()));
                }
                world.func_180501_a(pos, newstate, 4);
            } else if (!pow && triggered) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
            }
        });
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            CraftingAutomatBlock.safeConsume(world, pos, t -> t.getCapability(ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)h.getStackInSlot(i));
                }
            }));
            world.func_175666_e(pos, (Block)this);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return CraftingAutomatBlock.safeFunc(worldIn, pos, t -> {
            int count = t.getRecipeCount();
            return count != 0 ? (int)(Math.log(count) / Math.log(2.0)) + 1 : 0;
        }, () -> 0);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    private static void safeConsume(World world, BlockPos pos, Consumer<CraftingAutomatTileEntity> c) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof CraftingAutomatTileEntity) {
            c.accept((CraftingAutomatTileEntity)tile);
        }
    }

    private static <T> T safeFunc(World world, BlockPos pos, Function<CraftingAutomatTileEntity, T> f, Supplier<T> other) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof CraftingAutomatTileEntity ? f.apply((CraftingAutomatTileEntity)tile) : other.get();
    }
}

