/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import lolcroc.craftingautomat.CraftingAutomatContainer;
import lolcroc.craftingautomat.CraftingAutomatTileEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CraftingAutomatScreen
extends ContainerScreen<CraftingAutomatContainer> {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 197;
    private static final ResourceLocation TEXTURE = new ResourceLocation("craftingautomat", "textures/gui/container/crafting_automat.png");
    private static final Supplier<Integer> CRAFTING_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.CRAFTING_TICKS);
    private static final Supplier<Integer> COOLDOWN_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.COOLDOWN_TICKS);

    public CraftingAutomatScreen(CraftingAutomatContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 197;
        this.field_238742_p_ = 28;
    }

    private int getProgressWidth(int width) {
        int ticks = ((CraftingAutomatContainer)this.field_147002_h).getProgress();
        if (ticks <= 0) {
            return 0;
        }
        if (ticks > CRAFTING_TICKS.get()) {
            return (COOLDOWN_TICKS.get() + CRAFTING_TICKS.get() - ticks) * width / COOLDOWN_TICKS.get();
        }
        return ticks * width / CRAFTING_TICKS.get();
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(stack);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int w = this.getProgressWidth(24);
        this.func_238474_b_(stack, i + 89, j + 34, 176, 0, w + 1, 16);
        CraftingAutomatTileEntity.CraftingFlag flag = ((CraftingAutomatContainer)this.field_147002_h).getCraftingFlag();
        if (flag != CraftingAutomatTileEntity.CraftingFlag.NONE) {
            this.func_238474_b_(stack, i + 142, j + 26, 176 + 8 * (flag.getIndex() - 1), 17, 8, 8);
            if (this.func_195359_a(142, 26, 8, 8, mouseX, mouseY)) {
                this.func_243308_b(stack, flag.getDisplayTags(), mouseX, mouseY);
            }
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }
}

