/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lolcroc.craftingautomat.BufferHandler;
import lolcroc.craftingautomat.CraftingAutomat;
import lolcroc.craftingautomat.CraftingAutomatBlock;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import lolcroc.craftingautomat.CraftingAutomatContainer;
import lolcroc.craftingautomat.CraftingInventoryWrapper;
import lolcroc.craftingautomat.MatrixHandler;
import lolcroc.craftingautomat.ResultHandler;
import lolcroc.craftingautomat.ReversedInvWrapper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class CraftingAutomatTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IRecipeHolder {
    private ITextComponent customName;
    private LockCode lock = LockCode.field_180162_a;
    private RecipeItemHelper itemHelper = new RecipeItemHelper();
    private Optional<ICraftingRecipe> recipeUsed = Optional.empty();
    private int ticksActive;
    IntReferenceHolder ticksHolder = new IntReferenceHolder(){

        public int func_221495_b() {
            return CraftingAutomatTileEntity.this.ticksActive;
        }

        public void func_221494_a(int value) {
            CraftingAutomatTileEntity.this.ticksActive = value;
        }
    };
    private CraftingFlag craftingFlag = CraftingFlag.NONE;
    protected IntReferenceHolder craftingFlagHolder = new IntReferenceHolder(){

        public int func_221495_b() {
            return CraftingAutomatTileEntity.this.craftingFlag.getIndex();
        }

        public void func_221494_a(int value) {
            CraftingAutomatTileEntity.this.craftingFlag = CraftingFlag.fromIndex(value);
        }
    };
    private static final EmptyHandler EMPTYHANDLER = new EmptyHandler();
    protected LazyOptional<IItemHandlerModifiable> bufferHandler = LazyOptional.of(() -> new BufferHandler(this));
    protected LazyOptional<IItemHandlerModifiable> matrixHandler = LazyOptional.of(() -> new MatrixHandler(this));
    protected LazyOptional<IItemHandlerModifiable> resultHandler = LazyOptional.of(ResultHandler::new);
    protected LazyOptional<IItemHandlerModifiable> combinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER), (IItemHandlerModifiable)this.bufferHandler.orElse((Object)EMPTYHANDLER)}));
    protected LazyOptional<IItemHandler> reversedBufferHandler = LazyOptional.of(() -> new ReversedInvWrapper((IItemHandlerModifiable)this.bufferHandler.orElse((Object)EMPTYHANDLER)));
    protected LazyOptional<CraftingInventory> matrixWrapper = LazyOptional.of(() -> new CraftingInventoryWrapper((IItemHandlerModifiable)this.matrixHandler.orElse((Object)EMPTYHANDLER)));
    private static final ITextComponent DEFAULT_NAME = new TranslationTextComponent("container." + CraftingAutomatBlock.REGISTRY_NAME.toString());
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;

    public CraftingAutomatTileEntity() {
        super(CraftingAutomat.TileEntityTypes.autocrafter);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ((Boolean)this.func_195044_w().func_177229_b((Property)CraftingAutomatBlock.ACTIVE)).booleanValue()) {
            ++this.ticksActive;
            if (this.ticksActive <= (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get() && !this.isReady() || this.ticksActive >= (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get() + (Integer)CraftingAutomatConfig.COOLDOWN_TICKS.get()) {
                this.ticksActive = 0;
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CraftingAutomatBlock.ACTIVE, (Comparable)Boolean.FALSE));
            } else if (this.ticksActive == (Integer)CraftingAutomatConfig.CRAFTING_TICKS.get()) {
                this.resultHandler.ifPresent(h -> {
                    ItemStack stack = h.getStackInSlot(0).func_77946_l();
                    if (!stack.func_190926_b()) {
                        ResultHandler.outputStack(this, stack, false);
                    }
                });
                this.consumeIngredients(null);
            }
            this.func_70296_d();
        }
    }

    public boolean isReady() {
        return this.craftingFlag == CraftingFlag.READY;
    }

    public void onLoad() {
        super.onLoad();
        this.updateRecipe();
    }

    public void updateRecipe() {
        if (this.func_145830_o()) {
            this.matrixWrapper.ifPresent(w -> {
                this.recipeUsed = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)w, this.field_145850_b).filter(r -> this.func_201561_a(this.field_145850_b, null, (IRecipe<?>)r));
                this.resultHandler.ifPresent(h -> h.setStackInSlot(0, this.recipeUsed.map(r -> r.func_77572_b((IInventory)w)).orElse(ItemStack.field_190927_a)));
            });
            this.craftingFlag = CraftingFlag.getNewFlag(this.recipeUsed, this.itemHelper);
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        this.recipeUsed = Optional.ofNullable((ICraftingRecipe)recipe);
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return this.recipeUsed.orElse(null);
    }

    public boolean func_201561_a(World worldIn, @Nullable ServerPlayerEntity player, IRecipe<?> recipe) {
        return !worldIn.func_82736_K().func_223586_b(GameRules.field_223618_u) || recipe.func_192399_d();
    }

    public void updateHelper() {
        this.bufferHandler.ifPresent(h -> ((BufferHandler)((Object)h)).func_194018_a(this.itemHelper));
        this.craftingFlag = CraftingFlag.getNewFlag(this.recipeUsed, this.itemHelper);
    }

    public int getRecipeCount() {
        return this.recipeUsed.map(r -> this.itemHelper.func_194114_b((IRecipe)r, null)).orElse(0);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? this.customName : DEFAULT_NAME;
    }

    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return LockableTileEntity.func_213905_a((PlayerEntity)player, (LockCode)this.lock, (ITextComponent)this.func_145748_c_()) ? new CraftingAutomatContainer(id, inventory, this) : null;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(@Nullable ITextComponent name) {
        this.customName = name;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (!compound.func_150295_c("Items", 10).isEmpty()) {
            NonNullList items = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)items);
            int i = 1;
            while (i < items.size()) {
                int finalI = i++;
                this.combinedHandler.ifPresent(h -> h.setStackInSlot(finalI - 1, (ItemStack)items.get(finalI)));
            }
        } else {
            this.bufferHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)compound.func_74775_l("Buffer")));
            this.matrixHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)compound.func_74775_l("Matrix")));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.ticksActive = compound.func_74762_e("TicksActive");
        this.lock = LockCode.func_180158_b((CompoundNBT)compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.bufferHandler.ifPresent(h -> compound.func_218657_a("Buffer", ((INBTSerializable)h).serializeNBT()));
        this.matrixHandler.ifPresent(h -> compound.func_218657_a("Matrix", ((INBTSerializable)h).serializeNBT()));
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74768_a("TicksActive", this.ticksActive);
        this.lock.func_180157_a(compound);
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && capability == ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.combinedHandler.cast();
            }
            if (facing == this.func_195044_w().func_177229_b((Property)CraftingAutomatBlock.FACING)) {
                return this.resultHandler.cast();
            }
            if (facing == Direction.DOWN) {
                return this.reversedBufferHandler.cast();
            }
            return this.bufferHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void consumeIngredients(@Nullable PlayerEntity player) {
        this.recipeUsed.ifPresent(recipe -> {
            boolean ready = this.isReady();
            NonNullList remainingStacks = this.matrixWrapper.map(arg_0 -> ((ICraftingRecipe)recipe).func_179532_b(arg_0)).orElse(NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a));
            if (ready) {
                this.reversedBufferHandler.ifPresent(h -> recipe.func_192400_c().forEach(i -> {
                    for (int j = 0; j < h.getSlots(); ++j) {
                        if (!i.test(h.getStackInSlot(j))) continue;
                        h.extractItem(j, 1, false);
                        break;
                    }
                }));
            } else {
                this.matrixHandler.ifPresent(h -> {
                    for (int i = 0; i < h.getSlots(); ++i) {
                        h.extractItem(i, 1, false);
                    }
                });
            }
            IntStream.range(0, remainingStacks.size()).mapToObj(i -> {
                ItemStack stack = (ItemStack)remainingStacks.get(i);
                return ready ? stack : this.matrixHandler.map(h -> h.insertItem(i, stack, false)).orElse(stack);
            }).filter(stack -> !stack.func_190926_b()).map(stack -> this.reversedBufferHandler.map(h -> ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)false)).orElse(stack)).filter(stack -> !stack.func_190926_b()).forEach(stack -> {
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
                } else {
                    ResultHandler.outputStack(this, stack, true);
                }
            });
        });
    }

    static enum CraftingFlag {
        NONE,
        READY,
        MISSING,
        INVALID;

        private final List<ITextComponent> displayTags;
        private static final CraftingFlag[] VALUES;

        private CraftingFlag() {
            ArrayList list = Lists.newArrayList();
            list.add(new TranslationTextComponent(this.toString()).func_240699_a_(TextFormatting.GRAY));
            this.displayTags = list;
        }

        public int getIndex() {
            return this.ordinal();
        }

        public List<ITextComponent> getDisplayTags() {
            return this.displayTags;
        }

        public static CraftingFlag fromIndex(int idx) {
            return VALUES[idx];
        }

        public static CraftingFlag getNewFlag(Optional<ICraftingRecipe> recipe, RecipeItemHelper helper) {
            return recipe.map(r -> r.func_192399_d() ? INVALID : (helper.func_194114_b((IRecipe)r, null) > 0 ? READY : MISSING)).orElse(NONE);
        }

        public String toString() {
            return "container." + CraftingAutomatBlock.REGISTRY_NAME.toString() + ".flag." + StringUtils.toLowerCase((String)this.name());
        }

        static {
            VALUES = CraftingFlag.values();
        }
    }
}

