/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lolcroc.craftingautomat.CraftingAutomat;
import lolcroc.craftingautomat.CraftingAutomatTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class CraftingAutomatBlock
extends BaseEntityBlock {
    public static final String NAME = "autocrafter";
    @CapabilityInject(value=IItemHandler.class)
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("craftingautomat", "autocrafter");
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public CraftingAutomatBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(3.5f).m_60924_((state, getter, pos) -> false));
        this.setRegistryName(REGISTRY_NAME);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE, TRIGGERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CraftingAutomatTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ || (Boolean)state.m_61143_((Property)ACTIVE) == false ? null : CraftingAutomatBlock.m_152132_(type, CraftingAutomat.BlockEntityTypes.autocrafter, CraftingAutomatTileEntity::serverTick);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (stack.m_41788_()) {
            CraftingAutomatBlock.safeConsume(level, pos, t -> t.setCustomName(stack.m_41611_()));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            CraftingAutomatBlock.safeConsume(level, pos, t -> {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)t, (BlockPos)pos);
                player.m_36220_(Stats.f_12967_);
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        CraftingAutomatBlock.safeConsume(level, pos, t -> {
            boolean pow = level.m_46753_(pos) || level.m_46753_(pos.m_7494_());
            boolean triggered = (Boolean)state.m_61143_((Property)TRIGGERED);
            if (pow && !triggered) {
                BlockState newstate = (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.TRUE);
                if (!((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                    newstate = (BlockState)newstate.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(t.isReady()));
                }
                level.m_7731_(pos, newstate, 4);
            } else if (!pow && triggered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
            }
        });
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            CraftingAutomatBlock.safeConsume(level, pos, t -> t.getCapability(ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)h.getStackInSlot(i));
                }
            }));
            level.m_46717_(pos, (Block)this);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return CraftingAutomatBlock.safeFunc(level, pos, t -> {
            int count = t.getRecipeCount();
            return count != 0 ? (int)(Math.log(count) / Math.log(2.0)) + 1 : 0;
        }, () -> 0);
    }

    private static void safeConsume(Level level, BlockPos pos, Consumer<CraftingAutomatTileEntity> c) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CraftingAutomatTileEntity) {
            c.accept((CraftingAutomatTileEntity)tile);
        }
    }

    private static <T> T safeFunc(Level level, BlockPos pos, Function<CraftingAutomatTileEntity, T> f, Supplier<T> other) {
        BlockEntity tile = level.m_7702_(pos);
        return tile instanceof CraftingAutomatTileEntity ? f.apply((CraftingAutomatTileEntity)tile) : other.get();
    }
}

