/*
 * Decompiled with CFR 0.152.
 */
package lolcroc.craftingautomat;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import lolcroc.craftingautomat.CraftingAutomatConfig;
import lolcroc.craftingautomat.CraftingAutomatContainer;
import lolcroc.craftingautomat.CraftingAutomatTileEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CraftingAutomatScreen
extends ContainerScreen<CraftingAutomatContainer> {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 197;
    private static final ResourceLocation TEXTURE = new ResourceLocation("craftingautomat", "textures/gui/container/crafting_automat.png");
    private static final Supplier<Integer> CRAFTING_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.CRAFTING_TICKS);
    private static final Supplier<Integer> COOLDOWN_TICKS = () -> CraftingAutomatConfig.Client.get(CraftingAutomatConfig.COOLDOWN_TICKS);

    public CraftingAutomatScreen(CraftingAutomatContainer container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 197;
    }

    private int getProgressWidth(int width) {
        int ticks = ((CraftingAutomatContainer)this.field_147002_h).getProgress();
        if (ticks <= 0) {
            return 0;
        }
        if (ticks > CRAFTING_TICKS.get()) {
            return (COOLDOWN_TICKS.get() + CRAFTING_TICKS.get() - ticks) * width / COOLDOWN_TICKS.get();
        }
        return ticks * width / CRAFTING_TICKS.get();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 28.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int w = this.getProgressWidth(24);
        this.blit(i + 89, j + 34, 176, 0, w + 1, 16);
        CraftingAutomatTileEntity.CraftingFlag flag = ((CraftingAutomatContainer)this.field_147002_h).getCraftingFlag();
        if (flag != CraftingAutomatTileEntity.CraftingFlag.NONE) {
            this.blit(i + 142, j + 26, 176 + 8 * (flag.getIndex() - 1), 17, 8, 8);
            if (this.func_195359_a(142, 26, 8, 8, mouseX, mouseY)) {
                this.renderTooltip(I18n.func_135052_a((String)flag.getDisplayName().func_150254_d(), (Object[])new Object[0]), mouseX, mouseY);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

