/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper;

import com.google.common.io.Files;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationPropertiesHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.CustomizationButton;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.MenuBar;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHYesNoPopup;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class CustomizationHelperUI
extends UIBase {
    public static MenuBar bar;
    public static CustomizationHelperScreen currentHelperScreen;
    protected static final ResourceLocation CLOSE_BUTTON_TEXTURE;
    protected static final ResourceLocation RELOAD_BUTTON_TEXTURE;

    public static void updateUI() {
        try {
            boolean extended = true;
            if (bar != null) {
                extended = bar.isExtended();
            }
            bar = new MenuBar();
            FHContextMenu hudMenu = new FHContextMenu();
            hudMenu.setAutoclose(true);
            bar.addChild(hudMenu, "fh.ui.tab.hud", MenuBar.ElementAlignment.LEFT);
            FHContextMenu layoutsMenu = new FHContextMenu();
            layoutsMenu.setAutoclose(true);
            hudMenu.addChild(layoutsMenu);
            CustomizationButton newLayoutButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.new", (String[])new String[0]), true, press -> {
                LayoutEditorScreen.isActive = true;
                Minecraft.func_71410_x().func_147108_a((Screen)new LayoutEditorScreen());
            });
            newLayoutButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.new.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(newLayoutButton);
            ManageLayoutsContextMenu manageLayoutsMenu = new ManageLayoutsContextMenu();
            manageLayoutsMenu.setAutoclose(true);
            layoutsMenu.addChild(manageLayoutsMenu);
            CustomizationButton manageLayoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.manage", (String[])new String[0]), true, press -> {
                manageLayoutsMenu.setParentButton((AdvancedButton)press);
                manageLayoutsMenu.openMenuAt((Widget)press);
            });
            manageLayoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.manage.desc", (String[])new String[0]), (String)"%n%"));
            layoutsMenu.addContent(manageLayoutsButton);
            CustomizationButton layoutsButton = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts", (String[])new String[0]), true, press -> {
                layoutsMenu.setParentButton((AdvancedButton)press);
                layoutsMenu.openMenuAt(0, press.field_230691_m_);
            });
            layoutsButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.desc", (String[])new String[0]), (String)"%n%"));
            hudMenu.addContent(layoutsButton);
            CustomizationButton hudTab = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.ui.hud", (String[])new String[0]), true, press -> {
                hudMenu.setParentButton((AdvancedButton)press);
                hudMenu.openMenuAt(press.field_230690_l_, press.field_230691_m_ + press.func_238483_d_());
            });
            bar.addElement(hudTab, "fh.ui.tab.hud", MenuBar.ElementAlignment.LEFT, false);
            AdvancedImageButton closeGuiButtonTab = new AdvancedImageButton(20, 20, 20, 20, CLOSE_BUTTON_TEXTURE, true, press -> {
                CustomizationHelperScreen.resetScale();
                Minecraft.func_71410_x().func_147108_a(null);
            }){

                public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
                    this.field_230688_j_ = this.field_230689_k_;
                    super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
                }
            };
            closeGuiButtonTab.ignoreLeftMouseDownClickBlock = true;
            closeGuiButtonTab.ignoreBlockedInput = true;
            closeGuiButtonTab.enableRightclick = true;
            closeGuiButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.closehelper", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)closeGuiButtonTab, "fh.ui.tab.closehelper", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedImageButton reloadButtonTab = new AdvancedImageButton(20, 20, 20, 20, RELOAD_BUTTON_TEXTURE, true, press -> CustomizationHandler.reloadSystem()){

                public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
                    this.field_230688_j_ = this.field_230689_k_;
                    super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
                }
            };
            reloadButtonTab.ignoreLeftMouseDownClickBlock = true;
            reloadButtonTab.ignoreBlockedInput = true;
            reloadButtonTab.enableRightclick = true;
            reloadButtonTab.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.reload.desc", (String[])new String[0]), (String)"%n%"));
            bar.addElement((AdvancedButton)reloadButtonTab, "fh.ui.tab.reload", MenuBar.ElementAlignment.RIGHT, false);
            AdvancedButton expandButton = bar.getElement("menubar.default.extendbtn");
            if (expandButton != null && expandButton instanceof AdvancedImageButton && !extended) {
                ((AdvancedImageButton)expandButton).setImage(MenuBar.EXPAND_BTN_TEXTURE);
                expandButton.setDescription(new String[]{Locals.localize((String)"drippyloadingscreen.helper.menubar.expand", (String[])new String[0])});
            }
            bar.setExtended(extended);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void render(MatrixStack matrix, Screen screen) {
        try {
            if (bar != null && !PopupHandler.isPopupActive()) {
                RenderUtils.setZLevelPre((MatrixStack)matrix, (int)400);
                CustomizationHelperUI.renderUnicodeWarning(matrix, screen);
                RenderUtils.setZLevelPost((MatrixStack)matrix);
                bar.render(matrix, screen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void renderUnicodeWarning(MatrixStack matrix, Screen screen) {
        if (Minecraft.func_71410_x().field_71474_y.field_211842_aO) {
            String[] lines;
            String title = Locals.localize((String)"drippyloadingscreen.helper.ui.warning", (String[])new String[0]);
            int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(title);
            for (String s : lines = StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.warning.unicode", (String[])new String[0]), (String)"%n%")) {
                int w2 = Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
                if (w2 <= w) continue;
                w = w2;
            }
            int x = screen.field_230708_k_ - w - 5;
            int y = (int)((float)(bar.getHeight() + 5) * UIBase.getUIScale());
            RenderSystem.enableBlend();
            int h = 13;
            if (lines.length > 0) {
                h += 10 * lines.length;
            }
            CustomizationHelperUI.func_238467_a_((MatrixStack)matrix, (int)(x - 4), (int)y, (int)(x + w + 2), (int)(y + h), (int)new Color(230, 15, 0, 240).getRGB());
            CustomizationHelperUI.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)title, (int)x, (int)(y + 2), (int)Color.WHITE.getRGB());
            int i = 0;
            for (String s : lines) {
                CustomizationHelperUI.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)s, (int)x, (int)(y + 13 + i), (int)Color.WHITE.getRGB());
                i += 10;
            }
            RenderSystem.disableBlend();
        }
    }

    static {
        CLOSE_BUTTON_TEXTURE = new ResourceLocation("drippyloadingscreen", "close_btn.png");
        RELOAD_BUTTON_TEXTURE = new ResourceLocation("keksuccino", "/filechooser/back_icon.png");
    }

    private static class ManageLayoutsSubContextMenu
    extends FHContextMenu {
        private ManageLayoutsSubContextMenu() {
        }

        public void openMenuAt(int x, int y, File layout, boolean disabled) {
            this.content.clear();
            String toggleLabel = Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.disable", (String[])new String[0]);
            if (disabled) {
                toggleLabel = Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.enable", (String[])new String[0]);
            }
            CustomizationButton toggleLayoutBtn = new CustomizationButton(0, 0, 0, 0, toggleLabel, press -> {
                if (disabled) {
                    String name = FileUtils.generateAvailableFilename((String)DrippyLoadingScreen.CUSTOMIZATION_DIR.getPath(), (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"dllayout");
                    FileUtils.copyFile((File)layout, (File)new File(DrippyLoadingScreen.CUSTOMIZATION_DIR.getPath() + "/" + name));
                    layout.delete();
                } else {
                    String disPath = DrippyLoadingScreen.CUSTOMIZATION_DIR.getPath() + "/.disabled";
                    String name = FileUtils.generateAvailableFilename((String)disPath, (String)Files.getNameWithoutExtension((String)layout.getName()), (String)"dllayout");
                    FileUtils.copyFile((File)layout, (File)new File(disPath + "/" + name));
                    layout.delete();
                }
                CustomizationHandler.reloadSystem();
                if (this.parent != null && this.parent instanceof ManageLayoutsContextMenu) {
                    ((ManageLayoutsContextMenu)this.parent).forceCloseMenu();
                }
            });
            this.addContent(toggleLayoutBtn);
            CustomizationButton editLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.manage.edit", (String[])new String[0]), press -> CustomizationHandler.editLayout(layout));
            editLayoutBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.ui.hud.layouts.manage.edit.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(editLayoutBtn);
            CustomizationButton openInTextEditorBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.openintexteditor", (String[])new String[0]), press -> CustomizationHandler.openFile(layout));
            openInTextEditorBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.openintexteditor.desc", (String[])new String[0]), (String)"%n%"));
            this.addContent(openInTextEditorBtn);
            CustomizationButton deleteLayoutBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.delete", (String[])new String[0]), press -> {
                PopupHandler.displayPopup((Popup)new FHYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                    if (call.booleanValue() && layout.exists()) {
                        layout.delete();
                        CustomizationHandler.reloadSystem();
                        if (this.parent != null && this.parent instanceof ManageLayoutsContextMenu) {
                            ((ManageLayoutsContextMenu)this.parent).forceCloseMenu();
                        }
                    }
                }, Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.delete.msg", (String[])new String[0]), "", "", "", ""));
                CustomizationHandler.reloadSystem();
                if (this.parent != null && this.parent instanceof ManageLayoutsContextMenu) {
                    ((ManageLayoutsContextMenu)this.parent).forceCloseMenu();
                }
            });
            this.addContent(deleteLayoutBtn);
            this.openMenuAt(x, y);
        }
    }

    private static class ManageLayoutsContextMenu
    extends FHContextMenu {
        private ManageLayoutsSubContextMenu manageSubPopup = new ManageLayoutsSubContextMenu();

        public ManageLayoutsContextMenu() {
            this.addChild(this.manageSubPopup);
        }

        public void openMenuAt(Widget parentBtn) {
            List<PropertiesSet> disabled;
            this.content.clear();
            List<PropertiesSet> enabled = CustomizationPropertiesHandler.getProperties();
            if (!enabled.isEmpty()) {
                for (PropertiesSet s : enabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7a" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.field_230691_m_, f, false);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.enabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (!(disabled = CustomizationPropertiesHandler.getDisabledProperties()).isEmpty()) {
                for (PropertiesSet s : disabled) {
                    List secs = s.getPropertiesOfType("customization-meta");
                    if (secs.isEmpty()) {
                        secs = s.getPropertiesOfType("type-meta");
                    }
                    if (secs.isEmpty()) continue;
                    String name = "<missing name>";
                    PropertiesSection meta = (PropertiesSection)secs.get(0);
                    File f = new File(meta.getEntryValue("path"));
                    if (!f.isFile()) continue;
                    name = Files.getNameWithoutExtension((String)f.getName());
                    int totalactions = s.getProperties().size() - 1;
                    CustomizationButton layoutEntryBtn = new CustomizationButton(0, 0, 0, 0, "\u00a7c" + name, press -> {
                        this.manageSubPopup.setParentButton((AdvancedButton)press);
                        this.manageSubPopup.openMenuAt(0, press.field_230691_m_, f, true);
                    });
                    layoutEntryBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.layout.btndesc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.buttons.customization.managelayouts.disabled", (String[])new String[0]), "" + totalactions}), (String)"%n%"));
                    this.addContent(layoutEntryBtn);
                }
            }
            if (enabled.isEmpty() && disabled.isEmpty()) {
                CustomizationButton emptyBtn = new CustomizationButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.empty", (String[])new String[0]), press -> {});
                this.addContent(emptyBtn);
            }
            this.openMenuAt(parentBtn.field_230690_l_ - this.getWidth() - 2, parentBtn.field_230691_m_);
        }

        public void render(MatrixStack matrix, int mouseX, int mouseY) {
            super.render(matrix, mouseX, mouseY);
            if (this.manageSubPopup != null) {
                this.manageSubPopup.render(matrix, mouseX, mouseY);
                if (!this.isOpen()) {
                    this.manageSubPopup.closeMenu();
                }
            }
        }

        public void closeMenu() {
            if (!this.manageSubPopup.isHovered()) {
                super.closeMenu();
            }
        }

        public void forceCloseMenu() {
            super.closeMenu();
        }

        @Override
        public boolean isHovered() {
            if (this.manageSubPopup.isOpen() && this.manageSubPopup.isHovered()) {
                return true;
            }
            return super.isHovered();
        }
    }
}

