/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;

public class UIBase
extends AbstractGui {
    protected static Color idleButtonColor;
    protected static Color hoveredButtonColor;
    protected static Color idleButtonBorderColor;
    protected static Color hoveredButtonBorderColor;
    protected static float buttonBorderWidth;
    protected static float baseUIScale;

    protected static void initButtonColors() {
        if (idleButtonColor == null) {
            idleButtonColor = new Color(71, 71, 71);
            hoveredButtonColor = new Color(83, 156, 212);
            idleButtonBorderColor = new Color(209, 194, 209);
            hoveredButtonBorderColor = new Color(227, 211, 227);
        }
    }

    public static void colorizeButton(AdvancedButton button) {
        UIBase.initButtonColors();
        button.setBackgroundColor(idleButtonColor, hoveredButtonColor, idleButtonBorderColor, hoveredButtonBorderColor, buttonBorderWidth);
    }

    public static Color getButtonIdleColor() {
        UIBase.initButtonColors();
        return idleButtonColor;
    }

    public static Color getButtonBorderIdleColor() {
        UIBase.initButtonColors();
        return idleButtonBorderColor;
    }

    public static Color getButtonHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonColor;
    }

    public static Color getButtonBorderHoverColor() {
        UIBase.initButtonColors();
        return hoveredButtonBorderColor;
    }

    public static float getUIScale() {
        float uiScale = ((Float)DrippyLoadingScreen.config.getOrDefault("uiscale", (Object)Float.valueOf(1.0f))).floatValue();
        double mcScale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        return (float)((double)baseUIScale * ((double)baseUIScale / mcScale) * (double)uiScale);
    }

    public static void openScaledContextMenuAt(FHContextMenu menu, int x, int y) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null) {
            menu.openMenuAt((int)((float)x / UIBase.getUIScale()), (int)((float)y / UIBase.getUIScale()), (int)((float)s.field_230708_k_ / UIBase.getUIScale()), (int)((float)s.field_230709_l_ / UIBase.getUIScale()));
        }
    }

    public static void openScaledContextMenuAtMouse(FHContextMenu menu) {
        UIBase.openScaledContextMenuAt(menu, MouseInput.getMouseX(), MouseInput.getMouseY());
    }

    public static void renderScaledContextMenu(MatrixStack matrix, FHContextMenu menu) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null && menu != null) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(UIBase.getUIScale(), UIBase.getUIScale(), UIBase.getUIScale());
            MouseInput.setRenderScale((float)UIBase.getUIScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            MouseInput.resetRenderScale();
            menu.render(matrix, mouseX, mouseY, (int)((float)s.field_230708_k_ / UIBase.getUIScale()), (int)((float)s.field_230709_l_ / UIBase.getUIScale()));
            matrix.func_227865_b_();
        }
    }

    static {
        buttonBorderWidth = 1.0f;
        baseUIScale = 1.0f;
    }
}

